/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.item;

import java.util.Optional;
import net.frozenblock.lib.FrozenMain;
import net.frozenblock.lib.item.impl.CooldownInterface;
import net.frozenblock.lib.sound.api.FrozenSoundPackets;
import net.frozenblock.wilderwild.entity.AncientHornProjectile;
import net.frozenblock.wilderwild.misc.WilderSharedConstants;
import net.frozenblock.wilderwild.registry.RegisterItems;
import net.frozenblock.wilderwild.registry.RegisterSounds;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7430;
import net.minecraft.class_7444;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AncientHorn
extends class_7430 {
    public static final int DEFAULT_COOLDOWN = 600;
    public static final int CREATIVE_COOLDOWN = 5;
    public static final int SHRIEKER_COOLDOWN = 1200;
    public static final int SENSOR_COOLDOWN = 800;
    public static final int TENDRIL_COOLDOWN = 780;
    public static final int MIN_BUBBLES = 10;
    public static final int MAX_BUBBLES = 25;

    public AncientHorn(@NotNull class_1792.class_1793 settings, @NotNull class_6862<class_7444> instruments) {
        super(settings, instruments);
    }

    public static int getCooldown(@Nullable class_1297 entity, int cooldown) {
        class_1657 player;
        if (entity instanceof class_1657 && (player = (class_1657)entity).method_7337()) {
            return 5;
        }
        return cooldown;
    }

    public static int decreaseCooldown(@NotNull class_1657 user, int time) {
        if (!user.method_7337()) {
            int between;
            class_1796 manager = user.method_7357();
            class_1796.class_1797 entry = (class_1796.class_1797)manager.field_8024.get((Object)RegisterItems.ANCIENT_HORN);
            if (entry != null && (between = entry.field_8027 - entry.field_8028) > 140 && between >= time) {
                ((CooldownInterface)user.method_7357()).changeCooldown((class_1792)RegisterItems.ANCIENT_HORN, -time);
                return time;
            }
        }
        return -1;
    }

    private static void play(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_7444 instrument) {
        class_3414 soundEvent = (class_3414)instrument.comp_772().comp_349();
        float range = instrument.comp_774() / 16.0f;
        level.method_43129(player, (class_1297)player, soundEvent, class_3419.field_15247, range, 1.0f);
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, @NotNull class_1657 user, @NotNull class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        Optional optional = this.method_43711(itemStack);
        if (optional.isPresent()) {
            user.method_6019(hand);
            AncientHorn.play(level, user, (class_7444)((class_6880)optional.get()).comp_349());
            user.method_7357().method_7906((class_1792)RegisterItems.ANCIENT_HORN, AncientHorn.getCooldown((class_1297)user, 600));
            if (level instanceof class_3218) {
                class_3218 server = (class_3218)level;
                AncientHornProjectile projectileEntity = new AncientHornProjectile(level, user.method_23317(), user.method_23320(), user.method_23321());
                projectileEntity.method_24919((class_1297)user, user.method_36455(), user.method_36454(), 0.0f, 1.0f, 0.0f);
                projectileEntity.setShotByPlayer(true);
                server.method_8649((class_1297)projectileEntity);
                FrozenSoundPackets.createMovingRestrictionLoopingSound((class_1937)server, (class_1297)projectileEntity, (class_3414)RegisterSounds.ENTITY_ANCIENT_HORN_PROJECTILE_LOOP, (class_3419)class_3419.field_15254, (float)1.0f, (float)1.0f, (class_2960)FrozenMain.id((String)"default"), (boolean)true);
                class_1799 mainHand = user.method_5998(class_1268.field_5808);
                class_1799 offHand = user.method_5998(class_1268.field_5810);
                if (mainHand.method_31574(class_1802.field_8705) || mainHand.method_31574(class_1802.field_8574) || offHand.method_31574(class_1802.field_8705) || offHand.method_31574(class_1802.field_8574)) {
                    projectileEntity.setBubbles(level.field_9229.method_39332(10, 25));
                }
            }
            return class_1271.method_22428((Object)itemStack);
        }
        WilderSharedConstants.LOGGER.error("Ancient Horn use failed");
        return class_1271.method_22431((Object)itemStack);
    }

    public int method_7881(@NotNull class_1799 stack) {
        Optional optional = this.method_43711(stack);
        return optional.map(instrumentRegistryEntry -> ((class_7444)instrumentRegistryEntry.comp_349()).comp_773()).orElse(0);
    }
}

