/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.misc;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WilderSharedConstants {
    public static final String MOD_ID = "wilderwild";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"wilderwild");
    public static final int DATA_VERSION = 15;
    public static final Map<Object, Long> INSTANT_MAP = new Object2ObjectOpenHashMap();
    public static boolean UNSTABLE_LOGGING = FabricLoader.getInstance().isDevelopmentEnvironment();
    public static boolean MC_LIVE_TENDRILS = false;
    public static boolean IN_MESOGLEA = false;

    public static void log(String string, boolean shouldLog) {
        if (shouldLog) {
            LOGGER.info(string);
        }
    }

    public static void log(class_1297 entity, String string, boolean shouldLog) {
        if (shouldLog) {
            LOGGER.info(entity.toString() + " : " + string + " : " + entity.method_19538());
        }
    }

    public static void log(class_2248 block, String string, boolean shouldLog) {
        if (shouldLog) {
            LOGGER.info(block.toString() + " : " + string + " : ");
        }
    }

    public static void log(class_2248 block, class_2338 pos, String string, boolean shouldLog) {
        if (shouldLog) {
            LOGGER.info(block.toString() + " : " + string + " : " + pos);
        }
    }

    public static void logWild(String string, boolean shouldLog) {
        if (shouldLog) {
            LOGGER.info(string + " wilderwild");
        }
    }

    public static void startMeasuring(@NotNull Object object) {
        long started = System.nanoTime();
        String name = object.getClass().getName();
        LOGGER.info("Started measuring {}", (Object)name.substring(name.lastIndexOf(".") + 1));
        INSTANT_MAP.put(object, started);
    }

    public static void stopMeasuring(Object object) {
        if (INSTANT_MAP.containsKey(object)) {
            String name = object.getClass().getName();
            LOGGER.info("{} took {} nanoseconds", (Object)name.substring(name.lastIndexOf(".") + 1), (Object)(System.nanoTime() - INSTANT_MAP.get(object)));
            INSTANT_MAP.remove(object);
        }
    }

    @NotNull
    public static class_2960 id(@NotNull String path) {
        return new class_2960(MOD_ID, path);
    }

    @NotNull
    public static class_2960 vanillaId(@NotNull String path) {
        return new class_2960("minecraft", path);
    }

    @NotNull
    public static String string(@NotNull String path) {
        return WilderSharedConstants.id(path).toString();
    }

    public static String safeString(String path) {
        return "wilderwild_" + path;
    }

    public static class_2561 text(String key) {
        return class_2561.method_43471((String)("option.wilderwild." + key));
    }

    public static class_2561 tooltip(String key) {
        return class_2561.method_43471((String)("tooltip.wilderwild." + key));
    }

    public static Path configPath(String name, boolean json5) {
        return Path.of("./config/wilderwild/" + name + "." + (json5 ? "json5" : "json"), new String[0]);
    }
}

