/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.misc.wind;

import net.frozenblock.lib.wind.api.WindManager;
import net.frozenblock.lib.wind.api.WindManagerExtension;
import net.frozenblock.wilderwild.misc.WilderSharedConstants;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;

public class WilderWindManager
implements WindManagerExtension {
    private final WindManager manager;
    public double cloudX;
    public double cloudY;
    public double cloudZ;

    public WilderWindManager(WindManager manager) {
        this.manager = manager;
    }

    public void tick() {
        this.cloudX += this.manager.laggedWindX * 0.007;
        this.cloudY += this.manager.laggedWindY * 0.01;
        this.cloudZ += this.manager.laggedWindZ * 0.007;
    }

    public void baseTick() {
    }

    public boolean runResetsIfNeeded() {
        boolean needsReset = false;
        if (this.cloudX == Double.MAX_VALUE || this.cloudX == Double.MIN_VALUE) {
            needsReset = true;
            this.cloudX = 0.0;
        }
        if (this.cloudY == Double.MAX_VALUE || this.cloudY == Double.MIN_VALUE) {
            needsReset = true;
            this.cloudY = 0.0;
        }
        if (this.cloudZ == Double.MAX_VALUE || this.cloudZ == Double.MIN_VALUE) {
            needsReset = true;
            this.cloudZ = 0.0;
        }
        return needsReset;
    }

    public void createSyncByteBuf(@NotNull class_2540 original) {
        original.writeDouble(this.cloudX);
        original.writeDouble(this.cloudY);
        original.writeDouble(this.cloudZ);
    }

    public void load(@NotNull class_2487 compoundTag) {
        this.cloudX = compoundTag.method_10574(WilderSharedConstants.safeString("cloudX"));
        this.cloudY = compoundTag.method_10574(WilderSharedConstants.safeString("cloudY"));
        this.cloudZ = compoundTag.method_10574(WilderSharedConstants.safeString("cloudZ"));
    }

    public void save(@NotNull class_2487 compoundTag) {
        compoundTag.method_10549(WilderSharedConstants.safeString("cloudX"), this.cloudX);
        compoundTag.method_10549(WilderSharedConstants.safeString("cloudY"), this.cloudY);
        compoundTag.method_10549(WilderSharedConstants.safeString("cloudZ"), this.cloudZ);
    }
}

