/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.mixin;

import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.frozenblock.lib.FrozenBools;
import net.frozenblock.wilderwild.config.MixinsConfig;
import net.frozenblock.wilderwild.misc.WilderPreMixinInjectConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class WilderWildMixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
    }

    @Nullable
    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, @NotNull String mixinClassName) {
        boolean enableSodium;
        MixinsConfig config = MixinsConfig.get();
        boolean disableNonSodium = FabricLoader.getInstance().isModLoaded("embeddium") || FrozenBools.HAS_SODIUM;
        boolean bl = enableSodium = FrozenBools.HAS_SODIUM && ((ModContainer)FabricLoader.getInstance().getModContainer("sodium").orElseThrow()).getMetadata().getVersion().getFriendlyString().contains("0.5.");
        if (mixinClassName.contains("client.sodium")) {
            return config.client_sodium && enableSodium;
        }
        if (mixinClassName.contains("client.allay")) {
            return config.client_allay;
        }
        if (mixinClassName.contains("client.brush")) {
            return config.client_brush;
        }
        if (mixinClassName.contains("client.easter")) {
            return config.client_easter;
        }
        if (mixinClassName.contains("client.mesoglea")) {
            if ((mixinClassName.contains("LiquidBlockRenderer") || mixinClassName.contains("EntityRenderDispatcher")) && disableNonSodium) {
                return false;
            }
            return config.client_mesoglea;
        }
        if (mixinClassName.contains("client.shrieker")) {
            return config.client_shrieker;
        }
        if (mixinClassName.contains("client.warden")) {
            return config.client_warden;
        }
        if (mixinClassName.contains("client.wind")) {
            if (mixinClassName.contains("fallingleaves") && !WilderPreMixinInjectConstants.HAS_FALLINGLEAVES) {
                return false;
            }
            if (mixinClassName.contains("particlerain") && !WilderPreMixinInjectConstants.HAS_PARTICLERAIN) {
                return false;
            }
            if (mixinClassName.contains("CloudRenderer") && disableNonSodium) {
                return false;
            }
            return config.client_wind;
        }
        if (mixinClassName.contains("block.cactus")) {
            return config.block_cactus;
        }
        if (mixinClassName.contains("block.chest")) {
            return config.block_chest;
        }
        if (mixinClassName.contains("block.dripleaf")) {
            return config.block_dripleaf;
        }
        if (mixinClassName.contains("block.dripstone")) {
            return config.block_dripstone;
        }
        if (mixinClassName.contains("block.fire")) {
            return config.block_fire;
        }
        if (mixinClassName.contains("block.ice")) {
            return config.block_ice;
        }
        if (mixinClassName.contains("block.lava")) {
            return config.block_lava;
        }
        if (mixinClassName.contains("block.leaves")) {
            return config.block_leaves;
        }
        if (mixinClassName.contains("block.mesoglea")) {
            return config.block_mesoglea;
        }
        if (mixinClassName.contains("block.reinforced_deepslate")) {
            return config.block_reinforced_deepslate;
        }
        if (mixinClassName.contains("block.spawner")) {
            return config.block_spawner;
        }
        if (mixinClassName.contains("block.termite")) {
            return config.block_termite;
        }
        if (mixinClassName.contains("entity.ai")) {
            return config.entity_ai;
        }
        if (mixinClassName.contains("entity.allay")) {
            return config.entity_allay;
        }
        if (mixinClassName.contains("entity.boat")) {
            return config.entity_boat;
        }
        if (mixinClassName.contains("entity.easter")) {
            return config.entity_easter;
        }
        if (mixinClassName.contains("entity.enderman")) {
            return config.entity_enderman;
        }
        if (mixinClassName.contains("entity.experience")) {
            return config.entity_experience;
        }
        if (mixinClassName.contains("entity.jellyfish")) {
            return config.entity_jellyfish;
        }
        if (mixinClassName.contains("entity.lightning")) {
            return config.entity_lightning;
        }
        if (mixinClassName.contains("entity.slime")) {
            return config.entity_slime;
        }
        if (mixinClassName.contains("entity.tumbleweed")) {
            return config.entity_tumbleweed;
        }
        if (mixinClassName.contains("entity.turtle")) {
            return config.entity_turtle;
        }
        if (mixinClassName.contains("item.axe")) {
            return config.item_axe;
        }
        if (mixinClassName.contains("item.brush")) {
            return config.item_brush;
        }
        if (mixinClassName.contains("item.instrument")) {
            return config.item_instrument;
        }
        if (mixinClassName.contains("loot")) {
            return config.loot;
        }
        if (mixinClassName.contains("projectile")) {
            return config.projectile;
        }
        if (mixinClassName.contains("sculk")) {
            return config.sculk;
        }
        if (mixinClassName.contains("warden")) {
            return config.warden;
        }
        if (mixinClassName.contains("worldgen.biome")) {
            return config.worldgen_biome;
        }
        if (mixinClassName.contains("worldgen.structure")) {
            return config.worldgen_structure;
        }
        if (mixinClassName.contains("worldgen.tree")) {
            return config.worldgen_tree;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @Nullable
    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

