/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.mixin.worldgen.biome;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.frozenblock.lib.worldgen.biome.api.parameters.OverworldBiomeBuilderParameters;
import net.frozenblock.lib.worldgen.biome.api.parameters.Temperature;
import net.frozenblock.wilderwild.config.WorldgenConfig;
import net.frozenblock.wilderwild.registry.RegisterWorldgen;
import net.frozenblock.wilderwild.world.generation.WilderSharedWorldgen;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6554;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_6554.class}, priority=69420)
public final class OverworldBiomeBuilderMixin {
    @Shadow
    @Final
    private class_6544.class_6546[] field_34507;
    @Shadow
    @Final
    private class_6544.class_6546 field_34513;
    @Shadow
    @Final
    private class_6544.class_6546 field_34515;
    @Shadow
    @Final
    private class_6544.class_6546 field_34517;
    @Shadow
    @Final
    private class_5321<class_1959>[][] field_34519;
    @Shadow
    @Final
    private class_5321<class_1959>[][] field_34520;
    @Shadow
    @Final
    private class_6544.class_6546[] field_34505;

    @Unique
    private static void wilderWild$replaceParameters(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_5321<class_1959> biome, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset) {
        parameters.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.0f), (class_6544.class_6546)weirdness, (float)offset), biome));
        parameters.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38120((float)1.0f), (class_6544.class_6546)weirdness, (float)offset), biome));
    }

    @Unique
    private static void wilderWild$addDeepBiome(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset, class_5321<class_1959> biome) {
        parameters.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)WilderSharedWorldgen.deepParameters(temperature, humidity, continentalness, erosion, weirdness, offset), biome));
    }

    @Unique
    private static void wilderWild$addSemiDeepBiome(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset, class_5321<class_1959> biome) {
        parameters.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)WilderSharedWorldgen.semiDeepParameters(temperature, humidity, continentalness, erosion, weirdness, offset), biome));
    }

    @Shadow
    private void method_38187(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset, class_5321<class_1959> biome) {
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void wilderWild$injectBiomes(CallbackInfo ci) {
        if (WorldgenConfig.get().biomePlacement.modifyJunglePlacement) {
            this.field_34520[4][3] = class_1972.field_9417;
            this.field_34519[4][4] = class_1972.field_9417;
        }
    }

    @Unique
    private void wilderWild$injectBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters) {
        if (WorldgenConfig.get().biomeGeneration.generateDarkTaiga) {
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9475)) {
                this.method_38187(parameters, WilderSharedWorldgen.DarkTaiga.TEMPERATURE, WilderSharedWorldgen.DarkTaiga.HUMIDITY, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.DARK_TAIGA);
            }
        }
        if (WorldgenConfig.get().biomeGeneration.generateMixedForest) {
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9420)) {
                this.method_38187(parameters, WilderSharedWorldgen.MixedForest.TEMPERATURE, WilderSharedWorldgen.MixedForest.HUMIDITY, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.MIXED_FOREST);
            }
        }
        if (WorldgenConfig.get().biomeGeneration.generateTemperateRainforest) {
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9420)) {
                this.method_38187(parameters, WilderSharedWorldgen.TemperateRainforest.TEMPERATURE, WilderSharedWorldgen.TemperateRainforest.HUMIDITY, point.comp_107(), WilderSharedWorldgen.TemperateRainforest.EROSION, point.comp_110(), point.comp_111(), RegisterWorldgen.TEMPERATE_RAINFOREST);
            }
        }
        if (WorldgenConfig.get().biomeGeneration.generateRainforest) {
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9409)) {
                this.method_38187(parameters, WilderSharedWorldgen.Rainforest.TEMPERATURE_A, WilderSharedWorldgen.Rainforest.HUMIDITY_A, WilderSharedWorldgen.Rainforest.CONTINENTALNESS_A, WilderSharedWorldgen.Rainforest.EROSION_A, WilderSharedWorldgen.Rainforest.WEIRDNESS_A, point.comp_111(), RegisterWorldgen.RAINFOREST);
                if (point.comp_105().equals((Object)Temperature.FOUR)) {
                    this.method_38187(parameters, WilderSharedWorldgen.Rainforest.TEMPERATURE_B, WilderSharedWorldgen.Rainforest.HUMIDITY_B, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.RAINFOREST);
                }
                if (!point.comp_105().equals((Object)Temperature.THREE)) continue;
                this.method_38187(parameters, WilderSharedWorldgen.Rainforest.TEMPERATURE_C, WilderSharedWorldgen.Rainforest.HUMIDITY_C, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.RAINFOREST);
            }
        }
        if (WorldgenConfig.get().biomeGeneration.generateBirchTaiga) {
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9420)) {
                this.method_38187(parameters, WilderSharedWorldgen.BirchTaiga.TEMPERATURE, WilderSharedWorldgen.BirchTaiga.HUMIDITY, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.BIRCH_TAIGA);
            }
        }
        if (WorldgenConfig.get().biomeGeneration.generateOldGrowthBirchTaiga) {
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_35112)) {
                this.method_38187(parameters, WilderSharedWorldgen.BirchTaiga.TEMPERATURE, WilderSharedWorldgen.BirchTaiga.HUMIDITY, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.OLD_GROWTH_BIRCH_TAIGA);
            }
        }
        if (WorldgenConfig.get().biomeGeneration.generateBirchJungle) {
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9417)) {
                this.method_38187(parameters, WilderSharedWorldgen.BirchJungle.TEMPERATURE, WilderSharedWorldgen.BirchJungle.HUMIDITY, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.BIRCH_JUNGLE);
            }
        }
        if (WorldgenConfig.get().biomeGeneration.generateSparseBirchJungle) {
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_35118)) {
                this.method_38187(parameters, WilderSharedWorldgen.BirchJungle.TEMPERATURE, WilderSharedWorldgen.BirchJungle.HUMIDITY, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.SPARSE_BIRCH_JUNGLE);
            }
        }
        if (WorldgenConfig.get().biomeGeneration.generateFlowerField) {
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9414)) {
                this.method_38187(parameters, WilderSharedWorldgen.FlowerField.TEMPERATURE_A, WilderSharedWorldgen.FlowerField.HUMIDITY_A, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.FLOWER_FIELD);
                this.method_38187(parameters, WilderSharedWorldgen.FlowerField.TEMPERATURE_B, WilderSharedWorldgen.FlowerField.HUMIDITY_B, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.FLOWER_FIELD);
                this.method_38187(parameters, WilderSharedWorldgen.FlowerField.TEMPERATURE_A, WilderSharedWorldgen.FlowerField.HUMIDITY_AB, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.FLOWER_FIELD);
            }
        }
        if (WorldgenConfig.get().biomeGeneration.generateAridSavanna) {
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9449)) {
                this.method_38187(parameters, WilderSharedWorldgen.AridSavanna.TEMPERATURE, WilderSharedWorldgen.AridSavanna.HUMIDITY, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.ARID_SAVANNA);
            }
        }
        if (WorldgenConfig.get().biomeGeneration.generateParchedForest) {
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9409)) {
                this.method_38187(parameters, WilderSharedWorldgen.ParchedForest.TEMPERATURE, WilderSharedWorldgen.ParchedForest.HUMIDITY, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.PARCHED_FOREST);
            }
        }
        if (WorldgenConfig.get().biomeGeneration.generateAridForest) {
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9424)) {
                this.method_38187(parameters, WilderSharedWorldgen.AridForest.TEMPERATURE, WilderSharedWorldgen.AridForest.HUMIDITY, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.ARID_FOREST);
            }
        }
        if (WorldgenConfig.get().biomeGeneration.generateOldGrowthSnowyTaiga) {
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9454)) {
                this.method_38187(parameters, WilderSharedWorldgen.OldGrowthSnowySpruceTaiga.TEMPERATURE, WilderSharedWorldgen.OldGrowthSnowySpruceTaiga.HUMIDITY, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.SNOWY_OLD_GROWTH_PINE_TAIGA);
            }
        }
        if (WorldgenConfig.get().biomeGeneration.generateOldGrowthDarkForest) {
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9475)) {
                if (point.comp_110().comp_104() >= 0L) continue;
                this.method_38187(parameters, WilderSharedWorldgen.OldGrowthDarkForest.TEMPERATURE, WilderSharedWorldgen.OldGrowthDarkForest.HUMIDITY, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.OLD_GROWTH_DARK_FOREST);
            }
        }
        if (WorldgenConfig.get().biomeGeneration.generateDarkBirchForest) {
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9475)) {
                this.method_38187(parameters, WilderSharedWorldgen.DarkBirchForest.TEMPERATURE, WilderSharedWorldgen.DarkBirchForest.HUMIDITY, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.DARK_BIRCH_FOREST);
            }
        }
        if (WorldgenConfig.get().biomeGeneration.generateSemiBirchForest) {
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9412)) {
                this.method_38187(parameters, WilderSharedWorldgen.SemiBirchForest.TEMPERATURE_A, WilderSharedWorldgen.SemiBirchForest.HUMIDITY, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.SEMI_BIRCH_FOREST);
                this.method_38187(parameters, WilderSharedWorldgen.SemiBirchForest.TEMPERATURE_B, WilderSharedWorldgen.SemiBirchForest.HUMIDITY, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.SEMI_BIRCH_FOREST);
            }
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_35112)) {
                this.method_38187(parameters, WilderSharedWorldgen.SemiBirchForest.TEMPERATURE_A, WilderSharedWorldgen.SemiBirchForest.HUMIDITY, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.SEMI_BIRCH_FOREST);
                this.method_38187(parameters, WilderSharedWorldgen.SemiBirchForest.TEMPERATURE_B, WilderSharedWorldgen.SemiBirchForest.HUMIDITY, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111(), RegisterWorldgen.SEMI_BIRCH_FOREST);
            }
            if (WorldgenConfig.get().biomePlacement.modifyStonyShorePlacement) {
                for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9434)) {
                    this.method_38187(parameters, WilderSharedWorldgen.StonyShoreTaiga.TEMPERATURE, WilderSharedWorldgen.StonyShoreTaiga.HUMIDITY, WilderSharedWorldgen.StonyShoreTaiga.CONTINENTALNESS, WilderSharedWorldgen.StonyShoreTaiga.EROSION, point.comp_110(), point.comp_111(), (class_5321<class_1959>)class_1972.field_9419);
                }
            }
        }
    }

    @Inject(method={"addLowSlice"}, at={@At(value="TAIL")})
    private void wilderWild$injectLowSlice(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness, CallbackInfo info) {
        if (WorldgenConfig.get().biomeGeneration.generateCypressWetlands) {
            this.method_38187(parameters, WilderSharedWorldgen.CypressWetlands.TEMPERATURE, WilderSharedWorldgen.CypressWetlands.HUMIDITY, WilderSharedWorldgen.CypressWetlands.CONTINENTALNESS, WilderSharedWorldgen.CypressWetlands.EROSION, weirdness, 0.0f, RegisterWorldgen.CYPRESS_WETLANDS);
        }
        if (WorldgenConfig.get().biomeGeneration.generateOasis) {
            this.method_38187(parameters, WilderSharedWorldgen.Oasis.TEMPERATURE, WilderSharedWorldgen.Oasis.HUMIDITY, WilderSharedWorldgen.Oasis.CONTINENTALNESS, WilderSharedWorldgen.Oasis.EROSION, weirdness, 0.0f, RegisterWorldgen.OASIS);
        }
        this.wilderWild$injectBiomes(parameters);
    }

    @Inject(method={"addMidSlice"}, at={@At(value="TAIL")})
    private void wilderWild$injectMixedBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness, CallbackInfo info) {
        if (WorldgenConfig.get().biomeGeneration.generateCypressWetlands) {
            this.method_38187(parameters, WilderSharedWorldgen.CypressWetlands.TEMPERATURE, WilderSharedWorldgen.CypressWetlands.HUMIDITY, WilderSharedWorldgen.CypressWetlands.CONTINENTALNESS, WilderSharedWorldgen.CypressWetlands.EROSION, weirdness, 0.0f, RegisterWorldgen.CYPRESS_WETLANDS);
        }
        if (WorldgenConfig.get().biomeGeneration.generateOasis) {
            this.method_38187(parameters, WilderSharedWorldgen.Oasis.TEMPERATURE, WilderSharedWorldgen.Oasis.HUMIDITY, WilderSharedWorldgen.Oasis.CONTINENTALNESS, WilderSharedWorldgen.Oasis.EROSION, weirdness, 0.0f, RegisterWorldgen.OASIS);
        }
        if (WorldgenConfig.get().biomePlacement.modifyCherryGrovePlacement) {
            this.method_38187(parameters, WilderSharedWorldgen.CherryGrove.TEMPERATURE, WilderSharedWorldgen.CherryGrove.HUMIDITY, WilderSharedWorldgen.CherryGrove.CONTINENTALNESS, WilderSharedWorldgen.CherryGrove.EROSION, WilderSharedWorldgen.CherryGrove.WEIRDNESS, 0.0f, (class_5321<class_1959>)class_1972.field_42720);
        }
    }

    @Inject(method={"addValleys"}, at={@At(value="TAIL")})
    private void wilderWild$injectRiverBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness, CallbackInfo info) {
        if (WorldgenConfig.get().biomeGeneration.generateCypressWetlands) {
            this.method_38187(parameters, WilderSharedWorldgen.CypressWetlands.TEMPERATURE, WilderSharedWorldgen.CypressWetlands.HUMIDITY, WilderSharedWorldgen.CypressWetlands.CONTINENTALNESS, WilderSharedWorldgen.CypressWetlands.EROSION, weirdness, 0.0f, RegisterWorldgen.CYPRESS_WETLANDS);
        }
        if (WorldgenConfig.get().biomeGeneration.generateOasis) {
            this.method_38187(parameters, WilderSharedWorldgen.Oasis.TEMPERATURE, WilderSharedWorldgen.Oasis.HUMIDITY, WilderSharedWorldgen.Oasis.CONTINENTALNESS, WilderSharedWorldgen.Oasis.EROSION, weirdness, 0.0f, RegisterWorldgen.OASIS);
        }
    }

    @Inject(method={"addUndergroundBiomes"}, at={@At(value="TAIL")})
    private void wilderWild$addUndergroundBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> consumer, CallbackInfo info) {
        if (WorldgenConfig.get().biomeGeneration.generateJellyfishCaves) {
            OverworldBiomeBuilderMixin.wilderWild$addSemiDeepBiome(consumer, WilderSharedWorldgen.JellyfishCaves.TEMPERATURE, WilderSharedWorldgen.JellyfishCaves.HUMIDITY, WilderSharedWorldgen.JellyfishCaves.CONTINENTALNESS, WilderSharedWorldgen.JellyfishCaves.EROSION, WilderSharedWorldgen.JellyfishCaves.WEIRDNESS, 0.0f, RegisterWorldgen.JELLYFISH_CAVES);
        }
    }

    @Inject(method={"maybePickWindsweptSavannaBiome"}, at={@At(value="HEAD")}, cancellable=true)
    private void wilderWild$getBiomeOrWindsweptSavanna(int temperature, int humidity, class_6544.class_6546 weirdness, class_5321<class_1959> biomeKey, CallbackInfoReturnable<class_5321<class_1959>> info) {
        if (WorldgenConfig.get().biomePlacement.modifyWindsweptSavannaPlacement) {
            info.setReturnValue(temperature > 2 && humidity < 2 && weirdness.comp_104() >= 0L ? class_1972.field_35114 : biomeKey);
            info.cancel();
        }
    }

    @Inject(method={"addSurfaceBiome"}, at={@At(value="HEAD")}, cancellable=true)
    private void wilderWild$modifyPlacement(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset, class_5321<class_1959> biome, CallbackInfo info) {
        if (biome.equals((Object)class_1972.field_38748) && WorldgenConfig.get().biomePlacement.modifyMangroveSwampPlacement) {
            OverworldBiomeBuilderMixin.wilderWild$replaceParameters(parameters, biome, WilderSharedWorldgen.MangroveSwamp.TEMPERATURE, WilderSharedWorldgen.MangroveSwamp.HUMIDITY, continentalness, erosion, weirdness, offset);
            info.cancel();
        } else if (biome.equals((Object)class_1972.field_9471) && WorldgenConfig.get().biomePlacement.modifySwampPlacement) {
            OverworldBiomeBuilderMixin.wilderWild$replaceParameters(parameters, biome, WilderSharedWorldgen.Swamp.TEMPERATURE, WilderSharedWorldgen.Swamp.HUMIDITY, continentalness, erosion, weirdness, offset);
            info.cancel();
        }
    }

    @Inject(method={"addValleys"}, at={@At(value="HEAD")})
    private void wilderWild$addValleys(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> consumer, class_6544.class_6546 weirdness, CallbackInfo info) {
        if (WorldgenConfig.get().biomeGeneration.generateWarmRiver) {
            if (weirdness.comp_104() < 0L) {
                this.method_38187(consumer, this.field_34505[3], WilderSharedWorldgen.WarmRiver.HUMIDITY_TO_TWO, this.field_34513, class_6544.class_6546.method_38123((class_6544.class_6546)this.field_34507[0], (class_6544.class_6546)this.field_34507[1]), weirdness, 0.0f, RegisterWorldgen.WARM_RIVER);
            }
            this.method_38187(consumer, this.field_34505[3], WilderSharedWorldgen.WarmRiver.HUMIDITY_TO_TWO, this.field_34515, class_6544.class_6546.method_38123((class_6544.class_6546)this.field_34507[0], (class_6544.class_6546)this.field_34507[1]), weirdness, 0.0f, RegisterWorldgen.WARM_RIVER);
            this.method_38187(consumer, this.field_34505[3], WilderSharedWorldgen.WarmRiver.HUMIDITY_TO_TWO, class_6544.class_6546.method_38123((class_6544.class_6546)this.field_34513, (class_6544.class_6546)this.field_34517), class_6544.class_6546.method_38123((class_6544.class_6546)this.field_34507[2], (class_6544.class_6546)this.field_34507[5]), weirdness, 0.0f, RegisterWorldgen.WARM_RIVER);
            this.method_38187(consumer, this.field_34505[3], WilderSharedWorldgen.WarmRiver.HUMIDITY_TO_TWO, this.field_34513, this.field_34507[6], weirdness, 0.0f, RegisterWorldgen.WARM_RIVER);
            if (WorldgenConfig.get().biomePlacement.modifyJunglePlacement) {
                if (weirdness.comp_104() < 0L) {
                    this.method_38187(consumer, this.field_34505[4], WilderSharedWorldgen.WarmRiver.HUMIDITY_TO_THREE, this.field_34513, class_6544.class_6546.method_38123((class_6544.class_6546)this.field_34507[0], (class_6544.class_6546)this.field_34507[1]), weirdness, 0.0f, RegisterWorldgen.WARM_RIVER);
                }
                this.method_38187(consumer, this.field_34505[4], WilderSharedWorldgen.WarmRiver.HUMIDITY_TO_THREE, this.field_34515, class_6544.class_6546.method_38123((class_6544.class_6546)this.field_34507[0], (class_6544.class_6546)this.field_34507[1]), weirdness, 0.0f, RegisterWorldgen.WARM_RIVER);
                this.method_38187(consumer, this.field_34505[4], WilderSharedWorldgen.WarmRiver.HUMIDITY_TO_THREE, class_6544.class_6546.method_38123((class_6544.class_6546)this.field_34513, (class_6544.class_6546)this.field_34517), class_6544.class_6546.method_38123((class_6544.class_6546)this.field_34507[2], (class_6544.class_6546)this.field_34507[5]), weirdness, 0.0f, RegisterWorldgen.WARM_RIVER);
                this.method_38187(consumer, this.field_34505[4], WilderSharedWorldgen.WarmRiver.HUMIDITY_TO_THREE, this.field_34513, this.field_34507[6], weirdness, 0.0f, RegisterWorldgen.WARM_RIVER);
            } else {
                if (weirdness.comp_104() < 0L) {
                    this.method_38187(consumer, this.field_34505[4], class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), this.field_34513, class_6544.class_6546.method_38123((class_6544.class_6546)this.field_34507[0], (class_6544.class_6546)this.field_34507[1]), weirdness, 0.0f, RegisterWorldgen.WARM_RIVER);
                }
                this.method_38187(consumer, this.field_34505[4], class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), this.field_34515, class_6544.class_6546.method_38123((class_6544.class_6546)this.field_34507[0], (class_6544.class_6546)this.field_34507[1]), weirdness, 0.0f, RegisterWorldgen.WARM_RIVER);
                this.method_38187(consumer, this.field_34505[4], class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), class_6544.class_6546.method_38123((class_6544.class_6546)this.field_34513, (class_6544.class_6546)this.field_34517), class_6544.class_6546.method_38123((class_6544.class_6546)this.field_34507[2], (class_6544.class_6546)this.field_34507[5]), weirdness, 0.0f, RegisterWorldgen.WARM_RIVER);
                this.method_38187(consumer, this.field_34505[4], class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f), this.field_34513, this.field_34507[6], weirdness, 0.0f, RegisterWorldgen.WARM_RIVER);
            }
        }
    }

    @Inject(method={"pickBeachBiome"}, at={@At(value="HEAD")}, cancellable=true)
    private void wilderWild$injectWarmBeach(int temperature, int humidity, CallbackInfoReturnable<class_5321<class_1959>> info) {
        if (WorldgenConfig.get().biomeGeneration.generateWarmBeach && temperature == 3) {
            info.setReturnValue(RegisterWorldgen.WARM_BEACH);
        }
    }

    @ModifyArgs(method={"addValleys"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/OverworldBiomeBuilder;addSurfaceBiome(Ljava/util/function/Consumer;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;FLnet/minecraft/resources/ResourceKey;)V", ordinal=1))
    private void wilderWild$fixPar1(Args args) {
        if (WorldgenConfig.get().biomeGeneration.generateWarmRiver) {
            args.set(1, (Object)WilderSharedWorldgen.WarmRiver.UNFROZEN_NOT_WARM_RANGE);
        }
    }

    @ModifyArgs(method={"addValleys"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/OverworldBiomeBuilder;addSurfaceBiome(Ljava/util/function/Consumer;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;FLnet/minecraft/resources/ResourceKey;)V", ordinal=3))
    private void wilderWild$fixPar2(Args args) {
        if (WorldgenConfig.get().biomeGeneration.generateWarmRiver) {
            args.set(1, (Object)WilderSharedWorldgen.WarmRiver.UNFROZEN_NOT_WARM_RANGE);
        }
    }

    @ModifyArgs(method={"addValleys"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/OverworldBiomeBuilder;addSurfaceBiome(Ljava/util/function/Consumer;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;FLnet/minecraft/resources/ResourceKey;)V", ordinal=5))
    private void wilderWild$fixPar3(Args args) {
        if (WorldgenConfig.get().biomeGeneration.generateWarmRiver) {
            args.set(1, (Object)WilderSharedWorldgen.WarmRiver.UNFROZEN_NOT_WARM_RANGE);
        }
    }

    @ModifyArgs(method={"addValleys"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/OverworldBiomeBuilder;addSurfaceBiome(Ljava/util/function/Consumer;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;Lnet/minecraft/world/level/biome/Climate$Parameter;FLnet/minecraft/resources/ResourceKey;)V", ordinal=7))
    private void wilderWild$fixPar4(Args args) {
        if (WorldgenConfig.get().biomeGeneration.generateWarmRiver) {
            args.set(1, (Object)WilderSharedWorldgen.WarmRiver.UNFROZEN_NOT_WARM_RANGE);
        }
    }
}

