/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.world.additions.gen;

import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.frozenblock.wilderwild.config.WorldgenConfig;
import net.frozenblock.wilderwild.misc.WilderSharedConstants;
import net.frozenblock.wilderwild.registry.RegisterWorldgen;
import net.frozenblock.wilderwild.tag.WilderBiomeTags;
import net.frozenblock.wilderwild.world.additions.feature.WilderMiscPlaced;
import net.frozenblock.wilderwild.world.additions.feature.WilderPlacedFeatures;
import net.frozenblock.wilderwild.world.additions.gen.WilderBiomeSettings;
import net.frozenblock.wilderwild.world.additions.gen.WilderMiscGeneration;
import net.frozenblock.wilderwild.world.additions.gen.WilderTreesGeneration;
import net.frozenblock.wilderwild.world.additions.gen.WilderVegetationGeneration;
import net.frozenblock.wilderwild.world.generation.treedecorators.WilderTreeDecorators;
import net.minecraft.class_1972;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6814;
import net.minecraft.class_6819;

public final class WilderWorldGen {
    private WilderWorldGen() {
        throw new UnsupportedOperationException("WilderWorldGen contains only static declarations.");
    }

    public static void generateWildWorldGen() {
        WilderWorldGen.configureBuiltInBiomes();
        WilderWorldGen.replaceFeatures();
        WilderVegetationGeneration.generateFlower();
        WilderVegetationGeneration.generateBush();
        WilderVegetationGeneration.generateCacti();
        WilderVegetationGeneration.generateAlgae();
        WilderVegetationGeneration.generateGrass();
        WilderMiscGeneration.generateMisc();
        WilderTreeDecorators.generateTreeDecorators();
        WilderTreesGeneration.generateTrees();
        WilderVegetationGeneration.generateMushroom();
        WilderBiomeSettings.init();
        WilderWorldGen.generatePollen();
    }

    private static void configureBuiltInBiomes() {
        BiomeModifications.create((class_2960)WilderSharedConstants.id("remove_fallen_trees")).add(ModificationPhase.REMOVALS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{RegisterWorldgen.CYPRESS_WETLANDS}), context -> {
            if (!WorldgenConfig.get().fallenLogs) {
                context.getGenerationSettings().removeFeature(WilderPlacedFeatures.FALLEN_OAK_AND_CYPRESS_PLACED.getKey());
            }
        }).add(ModificationPhase.REMOVALS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{RegisterWorldgen.MIXED_FOREST}), context -> {
            if (!WorldgenConfig.get().fallenLogs) {
                context.getGenerationSettings().removeFeature(WilderPlacedFeatures.FALLEN_TREES_MIXED_PLACED.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("rainforest_flowers")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{RegisterWorldgen.RAINFOREST}), context -> {
            if (WorldgenConfig.get().wilderWildFlowerGen) {
                context.getGenerationSettings().removeFeature(WilderPlacedFeatures.FLOWER_RAINFOREST_VANILLA.getKey());
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.FLOWER_RAINFOREST.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("temperate_rainforest_flowers")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{RegisterWorldgen.TEMPERATE_RAINFOREST}), context -> {
            if (WorldgenConfig.get().wilderWildFlowerGen) {
                context.getGenerationSettings().removeFeature(WilderPlacedFeatures.FLOWER_TEMPERATE_RAINFOREST_VANILLA.getKey());
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.FLOWER_TEMPERATE_RAINFOREST.getKey());
            }
        });
    }

    private static void replaceFeatures() {
        BiomeModifications.create((class_2960)WilderSharedConstants.id("add_new_snow")).add(ModificationPhase.POST_PROCESSING, BiomeSelectors.all(), context -> {
            if (context.getGenerationSettings().removeFeature(class_6814.field_36012)) {
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13179, class_6814.field_36012);
                if (WorldgenConfig.get().snowBelowTrees) {
                    context.getGenerationSettings().addFeature(class_2893.class_2895.field_13179, WilderMiscPlaced.SNOW_BLANKET.getKey());
                }
                if (WorldgenConfig.get().surfaceTransitions) {
                    context.getGenerationSettings().addFeature(class_2893.class_2895.field_13179, WilderMiscPlaced.SNOW_AND_ICE_TRANSITION.getKey());
                }
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("replace_forest_grass")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.FOREST_GRASS), context -> {
            if (WorldgenConfig.get().wilderWildGrassGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36166);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.GRASS_PLACED.getKey());
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.TALL_GRASS.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("replace_plains_grass")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.PLAINS_GRASS), context -> {
            if (WorldgenConfig.get().wilderWildGrassGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36165);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.GRASS_PLAINS_PLACED.getKey());
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.TALL_GRASS_PLAINS.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("replace_cherry_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.CHERRY_TREES), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_42965);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.CHERRY_TREES.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("replace_forest_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9409}), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36154);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.TREES_BIRCH_AND_OAK_ORIGINAL.getKey());
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.TREES_BIRCH_AND_OAK.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("replace_birch_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9412, class_1972.field_35112}), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36150);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.TREES_BIRCH.getKey());
            }
        }).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_35112}), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36149);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.BIRCH_TALL.getKey());
            }
        }).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9414}), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36154);
                context.getGenerationSettings().removeFeature(class_6819.field_36139);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.TREES_FLOWER_FOREST.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("replace_plains_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.NON_FROZEN_PLAINS), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36135);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.TREES_PLAINS.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("replace_badlands_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_35110}), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36144);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.WOODED_BADLANDS_TREES.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("replace_swamp_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.SWAMP_TREES), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36146);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.TREES_SWAMP.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("replace_taiga_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.SHORT_TAIGA), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36142);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.SPRUCE_PLACED.getKey());
            }
        }).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.TALL_PINE_TAIGA), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36157);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.TREES_OLD_GROWTH_PINE_TAIGA.getKey());
            }
        }).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.TALL_SPRUCE_TAIGA), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36156);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.TREES_OLD_GROWTH_SPRUCE_TAIGA1.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("replace_grove_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.GROVE), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36143);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.TREES_GROVE.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("replace_savanna_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.NORMAL_SAVANNA), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36148);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.SAVANNA_TREES.getKey());
            }
        }).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.WINDSWEPT_SAVANNA), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36147);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.WINDSWEPT_SAVANNA_TREES.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("replace_snowy_plains_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.SNOWY_PLAINS), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36145);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.TREES_SNOWY.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("replace_windswept_hills_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.WINDSWEPT_HILLS), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36152);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.TREES_WINDSWEPT_HILLS.getKey());
            }
        }).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.WINDSWEPT_FOREST), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36151);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.TREES_WINDSWEPT_FOREST.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("replace_dark_forest_vegetation")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.DARK_FOREST), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36136);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.DARK_FOREST_VEGETATION.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("replace_meadow_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.MEADOW), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36141);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.TREES_MEADOW.getKey());
            }
        });
        BiomeModifications.create((class_2960)WilderSharedConstants.id("replace_water_trees")).add(ModificationPhase.REPLACEMENTS, BiomeSelectors.tag(WilderBiomeTags.HAS_WATER_SHRUBS), context -> {
            if (WorldgenConfig.get().wilderWildTreeGen) {
                context.getGenerationSettings().removeFeature(class_6819.field_36153);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, WilderPlacedFeatures.SHRUBS_WATER.getKey());
            }
        });
    }

    private static void generatePollen() {
        BiomeModifications.addFeature((Predicate)BiomeSelectors.tag(WilderBiomeTags.HAS_POLLEN), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)WilderPlacedFeatures.POLLEN_PLACED.getKey());
    }
}

