/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.world.generation.foliage;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.wilderwild.registry.RegisterBlocks;
import net.frozenblock.wilderwild.registry.RegisterFeatures;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4648;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import org.jetbrains.annotations.NotNull;

public class PalmFoliagePlacer
extends class_4647 {
    public static final Codec<PalmFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> PalmFoliagePlacer.palmCodec(instance).apply((Applicative)instance, PalmFoliagePlacer::new));
    private static final double SURROUNDING_LEAF_THRESHOLD = 0.175;
    public final class_6017 fronds;

    public PalmFoliagePlacer(@NotNull class_6017 intProvider, @NotNull class_6017 intProvider2, @NotNull class_6017 fronds) {
        super(intProvider, intProvider2);
        this.fronds = fronds;
    }

    protected static <P extends PalmFoliagePlacer> Products.P3<RecordCodecBuilder.Mu<P>, class_6017, class_6017, class_6017> palmCodec(RecordCodecBuilder.Instance<P> builder) {
        return PalmFoliagePlacer.method_30411(builder).and((App)class_6017.method_35004((int)0, (int)16).fieldOf("fronds").forGetter(placer -> placer.fronds));
    }

    public static void placeLeavesAtPos(@NotNull class_3746 level, @NotNull class_4647.class_8179 blockSetter, @NotNull class_5819 random, @NotNull class_4643 config, @NotNull class_2338 pos, double offX, double offY, double offZ) {
        class_2338.class_2339 mutableBlockPos = pos.method_25503().method_30927((class_2382)class_2338.method_49637((double)offX, (double)offY, (double)offZ));
        class_2338 basePos = mutableBlockPos.method_10062();
        PalmFoliagePlacer.method_34359((class_3746)level, (class_4647.class_8179)blockSetter, (class_5819)random, (class_4643)config, (class_2338)mutableBlockPos);
        if (PalmFoliagePlacer.shouldPlaceAbove(offX)) {
            PalmFoliagePlacer.method_34359((class_3746)level, (class_4647.class_8179)blockSetter, (class_5819)random, (class_4643)config, (class_2338)mutableBlockPos.method_10100(1, 0, 0));
        }
        if (PalmFoliagePlacer.shouldPlaceBelow(offX)) {
            PalmFoliagePlacer.method_34359((class_3746)level, (class_4647.class_8179)blockSetter, (class_5819)random, (class_4643)config, (class_2338)mutableBlockPos.method_10101((class_2382)basePos).method_10100(-1, 0, 0));
        }
        if (PalmFoliagePlacer.shouldPlaceAbove(offY)) {
            PalmFoliagePlacer.method_34359((class_3746)level, (class_4647.class_8179)blockSetter, (class_5819)random, (class_4643)config, (class_2338)mutableBlockPos.method_10101((class_2382)basePos).method_10100(0, 1, 0));
        }
        if (PalmFoliagePlacer.shouldPlaceBelow(offY)) {
            PalmFoliagePlacer.method_34359((class_3746)level, (class_4647.class_8179)blockSetter, (class_5819)random, (class_4643)config, (class_2338)mutableBlockPos.method_10101((class_2382)basePos).method_10100(0, -1, 0));
        }
        if (PalmFoliagePlacer.shouldPlaceAbove(offZ)) {
            PalmFoliagePlacer.method_34359((class_3746)level, (class_4647.class_8179)blockSetter, (class_5819)random, (class_4643)config, (class_2338)mutableBlockPos.method_10101((class_2382)basePos).method_10100(0, 0, 1));
        }
        if (PalmFoliagePlacer.shouldPlaceBelow(offZ)) {
            PalmFoliagePlacer.method_34359((class_3746)level, (class_4647.class_8179)blockSetter, (class_5819)random, (class_4643)config, (class_2338)mutableBlockPos.method_10101((class_2382)basePos).method_10100(0, 0, -1));
        }
    }

    public static boolean shouldPlaceAbove(double d) {
        return d > 0.675;
    }

    public static boolean shouldPlaceBelow(double d) {
        return d < 0.325;
    }

    @NotNull
    protected class_4648<?> method_28843() {
        return RegisterFeatures.PALM_FOLIAGE_PLACER;
    }

    protected void method_23448(@NotNull class_3746 level, @NotNull class_4647.class_8179 blockSetter, @NotNull class_5819 random, @NotNull class_4643 config, int i, @NotNull class_4647.class_5208 foliageAttachment, int j, int k, int l) {
        class_2338 blockPos = foliageAttachment.method_27388().method_10086(l);
        blockSetter.method_49240(blockPos.method_10074(), RegisterBlocks.PALM_CROWN.method_9564());
        class_243 origin = new class_243((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
        double minRadius = this.field_21296.method_35009();
        double radius = minRadius + ((double)this.field_21296.method_35011() - minRadius) * random.method_43058();
        double minus = Math.PI * radius / (radius * radius);
        int fronds = this.fronds.method_35008(random);
        double rotAngle = 360.0 / (double)fronds;
        double angle = random.method_43058() * 360.0;
        for (int a = 0; a < fronds; ++a) {
            class_243 offsetPos = AdvancedMath.rotateAboutXZ((class_243)origin, (double)1.0, (double)(angle + random.method_43058() * rotAngle * 0.35 * (double)(random.method_43056() ? 1 : -1)));
            double dirX = offsetPos.field_1352 - origin.field_1352;
            double dirZ = offsetPos.field_1350 - origin.field_1350;
            for (double r = 0.0; r < radius; r += 0.2) {
                double yOffset = 2.0 * (Math.sin(Math.PI * (r - 0.1) / radius) - minus) + 4.2 * (minus * 0.4);
                PalmFoliagePlacer.placeLeavesAtPos(level, blockSetter, random, config, blockPos, dirX * r, yOffset, dirZ * r);
            }
            angle += rotAngle;
        }
    }

    public int method_26989(@NotNull class_5819 randomSource, int i, @NotNull class_4643 treeConfiguration) {
        return 0;
    }

    protected boolean method_23451(@NotNull class_5819 randomSource, int i, int j, int k, int l, boolean bl) {
        if (j == 0) {
            return (i > 1 || k > 1) && i != 0 && k != 0;
        }
        return i == l && k == l && l > 0;
    }
}

