/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.world.generation.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.frozenblock.wilderwild.registry.RegisterFeatures;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2944;
import net.minecraft.class_3486;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4651;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import org.jetbrains.annotations.NotNull;

public class FallenTrunkWithLogs
extends class_5141 {
    public static final Codec<FallenTrunkWithLogs> CODEC = RecordCodecBuilder.create(instance -> FallenTrunkWithLogs.fallenTrunkCodec(instance).apply((Applicative)instance, FallenTrunkWithLogs::new));
    public final class_4651 hollowedState;
    public final float logChance;
    public final class_6017 maxLogs;
    public final float hollowedChance;
    public final float successInWaterChance;

    public FallenTrunkWithLogs(int baseHeight, int firstRandomHeight, int secondRandomHeight, class_4651 hollowedState, float logChance, float successInWaterChance, float hollowedChance, @NotNull class_6017 maxLogs) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.hollowedState = hollowedState;
        this.logChance = logChance;
        this.maxLogs = maxLogs;
        this.hollowedChance = hollowedChance;
        this.successInWaterChance = successInWaterChance;
    }

    protected static <P extends FallenTrunkWithLogs> Products.P8<RecordCodecBuilder.Mu<P>, Integer, Integer, Integer, class_4651, Float, Float, Float, class_6017> fallenTrunkCodec(RecordCodecBuilder.Instance<P> builder) {
        return FallenTrunkWithLogs.method_28904(builder).and((App)class_4651.field_24937.fieldOf("hollowed_state").forGetter(trunkPlacer -> trunkPlacer.hollowedState)).and((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_chance").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.logChance))).and((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("success_in_water_chance").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.successInWaterChance))).and((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("hollow_chance").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.hollowedChance))).and((App)class_6017.field_33450.fieldOf("max_logs").forGetter(trunkPlacer -> trunkPlacer.maxLogs));
    }

    private static boolean isWaterAt(@NotNull class_3746 level, @NotNull class_2338 blockpos) {
        return level.method_35237(blockpos, fluidState -> fluidState.method_15767(class_3486.field_15517));
    }

    @NotNull
    protected class_5142<?> method_28903() {
        return RegisterFeatures.FALLEN_TRUNK_WITH_LOGS_PLACER_TYPE;
    }

    @NotNull
    public List<class_4647.class_5208> method_26991(@NotNull class_3746 level, @NotNull BiConsumer<class_2338, class_2680> replacer, @NotNull class_5819 random, int height, @NotNull class_2338 startPos, @NotNull class_4643 config) {
        ArrayList list = Lists.newArrayList();
        ArrayList logs = Lists.newArrayList();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int maxLogs = this.maxLogs.method_35008(random);
        boolean hollow = random.method_43057() < this.hollowedChance;
        class_2350 logDir = class_2350.class_2353.field_11062.method_10183(random);
        int extraLogs = 0;
        if (FallenTrunkWithLogs.isWaterAt(level, startPos) && random.method_43057() > this.successInWaterChance) {
            return list;
        }
        class_2338 endPos = startPos.method_10079(logDir, height);
        class_2338 secondToEndPos = endPos.method_10093(logDir.method_10153());
        int aboveSolidAmount = 0;
        boolean isEndAboveSolid = false;
        Iterable poses = class_2338.method_10097((class_2338)startPos, (class_2338)endPos);
        for (class_2338 blockPos : poses) {
            mutable.method_10101((class_2382)blockPos);
            if (class_2944.method_27371((class_3746)level, (class_2338)mutable)) {
                if (!class_2944.method_27371((class_3746)level, (class_2338)mutable.method_10098(class_2350.field_11033)) && !class_2944.method_16420((class_3746)level, (class_2338)mutable)) {
                    ++aboveSolidAmount;
                    mutable.method_10098(class_2350.field_11036);
                    if (!mutable.equals((Object)endPos) && !mutable.equals((Object)secondToEndPos)) continue;
                    isEndAboveSolid = true;
                    continue;
                }
                mutable.method_10098(class_2350.field_11036);
                if (!mutable.equals((Object)startPos)) continue;
                return list;
            }
            return list;
        }
        if (isEndAboveSolid || (double)aboveSolidAmount / (double)height > 0.5) {
            for (class_2338 blockPos : poses) {
                mutable.method_10101((class_2382)blockPos);
                this.placeLog(logs, level, replacer, random, config, mutable, logDir, hollow);
                if (!(random.method_43057() < this.logChance) || extraLogs >= maxLogs) continue;
                class_2350 direction = (double)random.method_43057() >= 0.33 ? class_2350.class_2353.field_11062.method_10183(random) : class_2350.class_2353.field_11064.method_10183(random);
                this.generateExtraBranch(logs, level, replacer, random, config, mutable, logDir, direction, hollow);
                ++extraLogs;
            }
        }
        return list;
    }

    private void generateExtraBranch(@NotNull List<class_2338> logs, class_3746 level, @NotNull BiConsumer<class_2338, class_2680> replacer, @NotNull class_5819 random, @NotNull class_4643 config, @NotNull class_2338.class_2339 pos, @NotNull class_2350 offsetDir, @NotNull class_2350 direction, boolean hollow) {
        int x = pos.method_10263();
        int z = pos.method_10260();
        int y = pos.method_10264();
        if (offsetDir.method_10166() != direction.method_10166() && class_2944.method_27371((class_3746)level, (class_2338)pos.method_10103(x += direction.method_10148(), y += direction.method_10164(), z += direction.method_10165()))) {
            this.placeLog(logs, level, replacer, random, config, pos, direction, hollow);
        }
    }

    private void placeLog(@NotNull List<class_2338> logs, class_3746 level, @NotNull BiConsumer<class_2338, class_2680> replacer, @NotNull class_5819 random, @NotNull class_4643 config, @NotNull class_2338.class_2339 pos, @NotNull class_2350 direction, boolean hollow) {
        class_2680 setState;
        class_2680 class_26802 = setState = !hollow ? config.field_21288.method_23455(random, (class_2338)pos) : this.hollowedState.method_23455(random, (class_2338)pos);
        if (setState.method_28498((class_2769)class_2741.field_12496)) {
            class_2350.class_2351 axis = direction.method_10148() != 0 ? class_2350.class_2351.field_11048 : (direction.method_10164() != 0 ? class_2350.class_2351.field_11052 : class_2350.class_2351.field_11051);
            setState = (class_2680)setState.method_11657((class_2769)class_2741.field_12496, (Comparable)axis);
        }
        if (setState.method_28498((class_2769)class_2741.field_12508)) {
            setState = (class_2680)setState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(FallenTrunkWithLogs.isWaterAt(level, (class_2338)pos)));
        }
        replacer.accept((class_2338)pos, setState);
        logs.add(pos.method_10062());
    }
}

