/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.world.generation.trunk;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.frozenblock.wilderwild.registry.RegisterFeatures;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import org.jetbrains.annotations.NotNull;

public class JuniperTrunkPlacer
extends class_5141 {
    public static final Codec<JuniperTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> JuniperTrunkPlacer.juniperCodec(instance).apply((Applicative)instance, JuniperTrunkPlacer::new));
    public final class_6017 branchCount;
    public final class_6017 branchHorizontalLength;
    public final class_6019 branchStartOffsetFromTop;
    public final class_6019 secondBranchStartOffsetFromTop;
    public final class_6017 branchEndOffsetFromTop;

    public JuniperTrunkPlacer(int i, int j, int k, @NotNull class_6017 intProvider, @NotNull class_6017 intProvider2, @NotNull class_6019 uniformInt, @NotNull class_6017 intProvider3) {
        super(i, j, k);
        this.branchCount = intProvider;
        this.branchHorizontalLength = intProvider2;
        this.branchStartOffsetFromTop = uniformInt;
        this.secondBranchStartOffsetFromTop = class_6019.method_35017((int)uniformInt.method_35009(), (int)(uniformInt.method_35011() - 1));
        this.branchEndOffsetFromTop = intProvider3;
    }

    protected static <P extends JuniperTrunkPlacer> Products.P7<RecordCodecBuilder.Mu<P>, Integer, Integer, Integer, class_6017, class_6017, class_6019, class_6017> juniperCodec(RecordCodecBuilder.Instance<P> builder) {
        return JuniperTrunkPlacer.method_28904(builder).and((App)class_6017.method_35004((int)1, (int)3).fieldOf("branch_count").forGetter(placer -> placer.branchCount)).and((App)class_6017.method_35004((int)2, (int)16).fieldOf("branch_horizontal_length").forGetter(placer -> placer.branchHorizontalLength)).and((App)class_6019.field_29949.fieldOf("branch_start_offset_from_top").forGetter(placer -> placer.branchStartOffsetFromTop)).and((App)class_6017.method_35004((int)-16, (int)16).fieldOf("branch_end_offset_from_top").forGetter(placer -> placer.branchEndOffsetFromTop));
    }

    @NotNull
    protected class_5142<?> method_28903() {
        return RegisterFeatures.JUNIPER_TRUNK_PLACER;
    }

    @NotNull
    public List<class_4647.class_5208> method_26991(@NotNull class_3746 level, @NotNull BiConsumer<class_2338, class_2680> blockSetter, @NotNull class_5819 random, int freeTreeHeight, @NotNull class_2338 pos, @NotNull class_4643 config) {
        boolean moreThanOneBranch;
        int branchCount;
        JuniperTrunkPlacer.method_27400((class_3746)level, blockSetter, (class_5819)random, (class_2338)pos.method_10074(), (class_4643)config);
        int i = Math.max(0, freeTreeHeight - 1 + this.branchStartOffsetFromTop.method_35008(random));
        int j = Math.max(0, freeTreeHeight - 1 + this.secondBranchStartOffsetFromTop.method_35008(random));
        if (j >= i) {
            ++j;
        }
        boolean isThreeBranches = (branchCount = this.branchCount.method_35008(random)) == 3;
        boolean bl = moreThanOneBranch = branchCount >= 2;
        int l = isThreeBranches ? freeTreeHeight : (moreThanOneBranch ? Math.max(i, j) + 1 : i + 1);
        for (int m = 0; m < l; ++m) {
            this.method_35375(level, blockSetter, random, pos.method_10086(m), config);
        }
        ArrayList<class_4647.class_5208> list = new ArrayList<class_4647.class_5208>();
        if (isThreeBranches) {
            list.add(new class_4647.class_5208(pos.method_10086(l), 0, false));
        }
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
        Function<class_2680, class_2680> function = state -> (class_2680)state.method_11657((class_2769)class_2465.field_11459, (Comparable)direction.method_10166());
        list.add(this.generateBranch(level, blockSetter, random, freeTreeHeight, pos, config, function, direction, i, i < l - 1, mutableBlockPos));
        ArrayList<class_2350> allDirsMF = new ArrayList<class_2350>();
        for (class_2350 d : class_2350.class_2353.field_11062) {
            if (d == direction) continue;
            allDirsMF.add(d);
        }
        class_2350 secondDir = (class_2350)allDirsMF.get((int)(Math.random() * 2.0));
        if (moreThanOneBranch) {
            function = state -> (class_2680)state.method_11657((class_2769)class_2465.field_11459, (Comparable)secondDir.method_10166());
            list.add(this.generateBranch(level, blockSetter, random, freeTreeHeight, pos, config, function, secondDir, j, j < l - 1, mutableBlockPos));
        }
        return list;
    }

    @NotNull
    private class_4647.class_5208 generateBranch(@NotNull class_3746 world, @NotNull BiConsumer<class_2338, class_2680> biConsumer, @NotNull class_5819 random, int i, @NotNull class_2338 pos, @NotNull class_4643 treeConfiguration, @NotNull Function<class_2680, class_2680> function, @NotNull class_2350 direction, int j, boolean bl, @NotNull class_2338.class_2339 mutablePos) {
        int o;
        class_2350 direction2;
        mutablePos.method_10101((class_2382)pos).method_10104(class_2350.field_11036, j);
        int k = i - 1 + this.branchEndOffsetFromTop.method_35008(random);
        boolean bl2 = bl || k < j;
        int l = this.branchHorizontalLength.method_35008(random) + (bl2 ? 1 : 0);
        class_2338 blockPos = pos.method_10079(direction, l).method_10086(k);
        int m = bl2 ? 2 : 1;
        for (int n = 0; n < m; ++n) {
            this.method_27402(world, biConsumer, random, (class_2338)mutablePos.method_10098(direction), treeConfiguration, function);
        }
        class_2350 class_23502 = direction2 = blockPos.method_10264() > mutablePos.method_10264() ? class_2350.field_11036 : class_2350.field_11033;
        while ((o = mutablePos.method_19455((class_2382)blockPos)) != 0) {
            float f = (float)Math.abs(blockPos.method_10264() - mutablePos.method_10264()) / (float)o;
            boolean bl3 = random.method_43057() < f;
            mutablePos.method_10098(bl3 ? direction2 : direction);
            this.method_27402(world, biConsumer, random, (class_2338)mutablePos, treeConfiguration, bl3 ? Function.identity() : function);
        }
        return new class_4647.class_5208(blockPos.method_10084(), 0, false);
    }
}

