/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.spectrelib.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.collect.ImmutableMap;
import com.illusivesoulworks.spectrelib.SpectreConstants;
import com.illusivesoulworks.spectrelib.config.SpectreConfig;
import com.illusivesoulworks.spectrelib.config.SpectreConfigLoader;
import com.illusivesoulworks.spectrelib.platform.Services;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FilenameUtils;

public class SpectreConfigTracker {
    public static final SpectreConfigTracker INSTANCE = new SpectreConfigTracker();
    private final ConcurrentHashMap<String, SpectreConfig> files = new ConcurrentHashMap();
    private final EnumMap<SpectreConfig.Type, Set<SpectreConfig>> configsByType = new EnumMap(SpectreConfig.Type.class);
    private final ConcurrentHashMap<String, Map<SpectreConfig.Type, Set<SpectreConfig>>> configsByMod = new ConcurrentHashMap();
    private final Map<String, Map<String, Object>> defaultConfigs = new ConcurrentHashMap<String, Map<String, Object>>();

    private SpectreConfigTracker() {
        for (SpectreConfig.Type value : SpectreConfig.Type.values()) {
            this.configsByType.put(value, Collections.synchronizedSet(new LinkedHashSet()));
        }
    }

    void track(SpectreConfig config) {
        if (config.getType() == SpectreConfig.Type.CLIENT && Services.CONFIG.isDedicatedServer()) {
            return;
        }
        if (this.files.containsKey(config.getFileName())) {
            SpectreConstants.LOG.error(SpectreConfigLoader.CONFIG, "Detected config file conflict {} between {} and {}", new Object[]{config.getFileName(), this.files.get(config.getFileName()).getModId(), config.getModId()});
            throw new RuntimeException("Conflicting config files");
        }
        this.files.put(config.getFileName(), config);
        this.configsByType.get((Object)config.getType()).add(config);
        this.configsByMod.computeIfAbsent(config.getModId(), k -> new EnumMap(SpectreConfig.Type.class)).computeIfAbsent(config.getType(), k -> Collections.synchronizedSet(new LinkedHashSet())).add(config);
        SpectreConstants.LOG.debug(SpectreConfigLoader.CONFIG, "Config file {} for {} added to tracking", (Object)config.getFileName(), (Object)config.getModId());
    }

    void loadGlobalConfigs() {
        SpectreConstants.LOG.debug(SpectreConfigLoader.CONFIG, "Loading global configs");
        this.files.values().forEach(config -> {
            SpectreConstants.LOG.trace(SpectreConfigLoader.CONFIG, "Loading config file type {} at {} for {}", new Object[]{config.getType(), config.getFileName(), config.getModId()});
            Path path = Services.CONFIG.getGlobalConfigPath();
            boolean alreadyExists = Files.exists(path.resolve(config.getFileName()), new LinkOption[0]);
            CommentedFileConfig configData = this.read(path).apply((SpectreConfig)config);
            SpectreConfig.InstanceType type = SpectreConfig.InstanceType.GLOBAL;
            config.setConfigData(type, (CommentedConfig)configData, !alreadyExists);
            config.fireLoad(false);
            config.save(type);
        });
    }

    void loadServerConfigs(MinecraftServer server) {
        Path configDir = Services.CONFIG.getServerConfigPath(server);
        AtomicReference<SpectreConfig.InstanceType> type = new AtomicReference<SpectreConfig.InstanceType>(SpectreConfig.InstanceType.SERVER);
        SpectreConstants.LOG.debug(SpectreConfigLoader.CONFIG, "Loading {} configs from {} on server", (Object)type.get().id(), (Object)configDir);
        this.files.values().forEach(config -> {
            Path dir = null;
            String name = config.getFileName();
            Path configPath = configDir.resolve(name);
            if (Files.exists(configPath, new LinkOption[0])) {
                dir = configDir;
            } else {
                Path globalDir = Services.CONFIG.getGlobalConfigPath();
                Path globalPath = globalDir.resolve(name);
                if (Files.exists(globalPath, new LinkOption[0])) {
                    type.set(SpectreConfig.InstanceType.GLOBAL);
                    dir = globalDir;
                }
            }
            if (dir != null) {
                SpectreConstants.LOG.trace(SpectreConfigLoader.CONFIG, "Loading config file type {} at {} from {} for {}", new Object[]{config.getType(), config.getFileName(), dir, config.getModId()});
                CommentedFileConfig configData = this.read(dir).apply((SpectreConfig)config);
                config.setConfigData((SpectreConfig.InstanceType)((Object)((Object)type.get())), (CommentedConfig)configData, false);
                config.fireLoad(false);
                config.save((SpectreConfig.InstanceType)((Object)((Object)type.get())));
            }
        });
    }

    void unloadServerConfigs() {
        SpectreConstants.LOG.debug(SpectreConfigLoader.CONFIG, "Unloading server configs");
        this.files.values().forEach(config -> {
            SpectreConstants.LOG.trace(SpectreConfigLoader.CONFIG, "Unloading config file type {} at {}", (Object)config.getType(), (Object)config.getFileName());
            config.save(SpectreConfig.InstanceType.SERVER);
            config.clearServerConfigData();
        });
    }

    static void tryConfigFileLoad(FileConfig configData) {
        try {
            configData.load();
        }
        catch (ParsingException e) {
            try {
                Path path = configData.getNioPath();
                SpectreConfigTracker.backupConfig(path);
                Files.delete(path);
                configData.load();
                SpectreConstants.LOG.warn("Configuration file {} could not be parsed. Correcting", (Object)path);
                return;
            }
            catch (Throwable t) {
                e.addSuppressed(t);
                throw e;
            }
        }
    }

    private static void backupConfig(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            Path dir = path.getParent();
            String fileName = path.getFileName().toString();
            String extension = FilenameUtils.getExtension((String)fileName) + ".bak";
            fileName = FilenameUtils.removeExtension((String)fileName);
            try {
                Files.copy(path, dir.resolve(fileName + "." + extension), new CopyOption[0]);
            }
            catch (IOException e) {
                SpectreConstants.LOG.warn("Failed to backup configuration file {}", (Object)path, (Object)e);
            }
        }
    }

    private void tryDefaultConfigLoad(SpectreConfig modConfig) {
        String fileName = modConfig.getFileName();
        Path path = Services.CONFIG.getBackwardsCompatiblePath().resolve(fileName);
        if (Files.exists(path, new LinkOption[0])) {
            try (CommentedFileConfig config = CommentedFileConfig.of((Path)path);){
                config.load();
                Map values = config.valueMap();
                if (values != null && !values.isEmpty()) {
                    this.defaultConfigs.put(fileName.intern(), (Map<String, Object>)ImmutableMap.copyOf((Map)values));
                }
                SpectreConstants.LOG.info(SpectreConfigLoader.CONFIG, "Loaded default config values from file at path {}", (Object)path);
            }
            catch (Exception e) {
                SpectreConstants.LOG.error(SpectreConfigLoader.CONFIG, "Error loading default config values from file at path {}", (Object)path);
                e.printStackTrace();
            }
        }
    }

    Function<SpectreConfig, CommentedFileConfig> read(Path basePath) {
        return config -> {
            Path configPath = basePath.resolve(config.getFileName());
            CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath, (ConfigFormat)TomlFormat.instance()).sync().preserveInsertionOrder().autosave().onFileNotFound(this::setupConfigFile).writingMode(WritingMode.REPLACE).build();
            SpectreConstants.LOG.debug(SpectreConfigLoader.CONFIG, "Built TOML config for {}", (Object)configPath);
            try {
                SpectreConfigTracker.tryConfigFileLoad((FileConfig)configData);
            }
            catch (ParsingException ex) {
                SpectreConstants.LOG.error(SpectreConfigLoader.CONFIG, "Error loading TOML config for {}", (Object)configPath);
                throw new ConfigLoadingException((SpectreConfig)config, (Exception)((Object)ex));
            }
            this.tryDefaultConfigLoad((SpectreConfig)config);
            SpectreConstants.LOG.debug(SpectreConfigLoader.CONFIG, "Loaded TOML config file {}", (Object)configPath);
            return configData;
        };
    }

    private boolean setupConfigFile(Path path, ConfigFormat<?> conf) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Path p = Services.CONFIG.getBackwardsCompatiblePath().resolve(path.getFileName());
        if (Files.exists(p, new LinkOption[0])) {
            SpectreConstants.LOG.info(SpectreConfigLoader.CONFIG, "Loading default config file from path {}", (Object)p);
            Files.copy(p, path, new CopyOption[0]);
        } else {
            Files.createFile(path, new FileAttribute[0]);
            conf.initEmptyFile(path);
        }
        return true;
    }

    public Map<String, Map<String, Object>> getDefaultConfigs() {
        return ImmutableMap.copyOf(this.defaultConfigs);
    }

    public Map<String, Map<SpectreConfig.Type, Set<SpectreConfig>>> getConfigsByMod() {
        return ImmutableMap.copyOf(this.configsByMod);
    }

    public void acceptSyncedConfigs(String fileName, byte[] data) {
        SpectreConfig configFile = this.files.get(fileName);
        if (configFile != null) {
            CommentedConfig configData = (CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(data));
            configFile.setConfigData(SpectreConfig.InstanceType.SERVER, configData, false);
            configFile.fireLoad(true);
        }
    }

    public Map<String, byte[]> getConfigSync() {
        return this.configsByType.get((Object)SpectreConfig.Type.SERVER).stream().collect(Collectors.toMap(SpectreConfig::getFileName, file -> {
            try {
                return Files.readAllBytes(file.getFullPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private static class ConfigLoadingException
    extends RuntimeException {
        public ConfigLoadingException(SpectreConfig config, Exception cause) {
            super("Failed loading config file " + config.getFileName() + " of type " + config.getType() + " for " + config.getModId(), cause);
        }
    }
}

