/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import com.google.common.collect.ImmutableList;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import java.util.List;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;

public class MutantSnowGolemModel
extends class_583<MutantSnowGolem> {
    private final List<class_630> parts;
    private final class_630 pelvis;
    private final class_630 abdomen;
    private final class_630 chest;
    private final class_630 head;
    private final class_630 innerHead;
    private final class_630 arm1;
    private final class_630 innerArm1;
    private final class_630 arm2;
    private final class_630 innerArm2;
    private final class_630 foreArm1;
    private final class_630 innerForeArm1;
    private final class_630 foreArm2;
    private final class_630 innerForeArm2;
    private final class_630 leg1;
    private final class_630 innerLeg1;
    private final class_630 leg2;
    private final class_630 innerLeg2;
    private final class_630 foreLeg1;
    private final class_630 innerForeLeg1;
    private final class_630 foreLeg2;
    private final class_630 innerForeLeg2;
    private float partialTick;

    public MutantSnowGolemModel(class_630 modelPart) {
        this.parts = (List)modelPart.method_32088().collect(ImmutableList.toImmutableList());
        this.pelvis = modelPart.method_32086("pelvis");
        this.abdomen = this.pelvis.method_32086("abdomen");
        this.chest = this.abdomen.method_32086("chest");
        this.head = this.chest.method_32086("head");
        this.innerHead = this.head.method_32086("inner_head");
        this.arm1 = this.chest.method_32086("arm1");
        this.innerArm1 = this.arm1.method_32086("inner_arm1");
        this.arm2 = this.chest.method_32086("arm2");
        this.innerArm2 = this.arm2.method_32086("inner_arm2");
        this.foreArm1 = this.innerArm1.method_32086("fore_arm1");
        this.innerForeArm1 = this.foreArm1.method_32086("inner_fore_arm1");
        this.foreArm2 = this.innerArm2.method_32086("fore_arm2");
        this.innerForeArm2 = this.foreArm2.method_32086("inner_fore_arm2");
        this.leg1 = this.pelvis.method_32086("leg1");
        this.innerLeg1 = this.leg1.method_32086("inner_leg1");
        this.leg2 = this.pelvis.method_32086("leg2");
        this.innerLeg2 = this.leg2.method_32086("inner_leg2");
        this.foreLeg1 = this.innerLeg1.method_32086("fore_leg1");
        this.innerForeLeg1 = this.foreLeg1.method_32086("inner_fore_leg1");
        this.foreLeg2 = this.innerLeg2.method_32086("fore_leg2");
        this.innerForeLeg2 = this.foreLeg2.method_32086("inner_fore_leg2");
    }

    public MutantSnowGolemModel setRenderHeadOnly() {
        this.parts.forEach(t -> {
            t.field_38456 = true;
        });
        this.innerHead.field_38456 = false;
        this.head.field_38456 = false;
        return this;
    }

    public static class_5607 createBodyLayer(int textureWidth, int textureHeight) {
        class_5609 mesh = new class_5609();
        class_5610 root = mesh.method_32111();
        class_5610 pelvis = root.method_32117("pelvis", class_5606.method_32108().method_32101(0, 0), class_5603.method_32090((float)0.0f, (float)13.5f, (float)5.0f));
        class_5610 abdomen = pelvis.method_32117("abdomen", class_5606.method_32108().method_32101(0, 32).method_32097(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f), class_5603.field_27701);
        class_5610 chest = abdomen.method_32117("chest", class_5606.method_32108().method_32101(24, 36).method_32097(-8.0f, -12.0f, -6.0f, 16.0f, 12.0f, 12.0f), class_5603.method_32090((float)0.0f, (float)-6.0f, (float)0.0f));
        class_5610 head = chest.method_32117("head", class_5606.method_32108().method_32101(0, 0), class_5603.method_32090((float)0.0f, (float)-12.0f, (float)-2.0f));
        class_5610 innerHead = head.method_32117("inner_head", class_5606.method_32108().method_32101(0, 0).method_32098(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new class_5605(0.5f)), class_5603.field_27701);
        innerHead.method_32117("head_core", class_5606.method_32108().method_32101(64, 0).method_32097(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f).method_32101(80, 46).method_32098(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new class_5605(-0.5f)), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 arm1 = chest.method_32117("arm1", class_5606.method_32108().method_32101(68, 16), class_5603.method_32090((float)-9.0f, (float)-11.0f, (float)0.0f));
        class_5610 innerArm1 = arm1.method_32117("inner_arm1", class_5606.method_32108().method_32101(68, 16).method_32097(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f), class_5603.field_27701);
        class_5610 foreArm1 = innerArm1.method_32117("fore_arm1", class_5606.method_32108().method_32101(96, 0), class_5603.method_32090((float)0.0f, (float)10.0f, (float)0.0f));
        foreArm1.method_32117("inner_fore_arm1", class_5606.method_32108().method_32101(96, 0).method_32097(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f), class_5603.field_27701);
        class_5610 arm2 = chest.method_32117("arm2", class_5606.method_32108().method_32101(68, 16).method_32096(), class_5603.method_32090((float)9.0f, (float)-11.0f, (float)0.0f));
        class_5610 innerArm2 = arm2.method_32117("inner_arm2", class_5606.method_32108().method_32101(68, 16).method_32097(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f), class_5603.field_27701);
        class_5610 foreArm2 = innerArm2.method_32117("fore_arm2", class_5606.method_32108().method_32101(96, 0).method_32096(), class_5603.method_32090((float)0.0f, (float)10.0f, (float)0.0f));
        foreArm2.method_32117("inner_fore_arm2", class_5606.method_32108().method_32101(96, 0).method_32097(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f), class_5603.field_27701);
        class_5610 leg1 = pelvis.method_32117("leg1", class_5606.method_32108().method_32101(88, 18), class_5603.method_32090((float)-4.0f, (float)-1.0f, (float)-3.0f));
        class_5610 innerLeg1 = leg1.method_32117("inner_leg1", class_5606.method_32108().method_32101(88, 18).method_32097(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f), class_5603.field_27701);
        class_5610 foreLeg1 = innerLeg1.method_32117("fore_leg1", class_5606.method_32108().method_32101(88, 32), class_5603.method_32090((float)-1.0f, (float)6.0f, (float)-0.0f));
        foreLeg1.method_32117("inner_fore_leg1", class_5606.method_32108().method_32101(88, 32).method_32097(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f), class_5603.field_27701);
        class_5610 leg2 = pelvis.method_32117("leg2", class_5606.method_32108().method_32101(88, 18).method_32096(), class_5603.method_32090((float)4.0f, (float)-1.0f, (float)-3.0f));
        class_5610 innerLeg2 = leg2.method_32117("inner_leg2", class_5606.method_32108().method_32101(88, 18).method_32097(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f), class_5603.field_27701);
        class_5610 foreLeg2 = innerLeg2.method_32117("fore_leg2", class_5606.method_32108().method_32101(88, 32).method_32096(), class_5603.method_32090((float)1.0f, (float)6.0f, (float)-0.0f));
        foreLeg2.method_32117("inner_fore_leg2", class_5606.method_32108().method_32101(88, 32).method_32097(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f), class_5603.field_27701);
        return class_5607.method_32110((class_5609)mesh, (int)textureWidth, (int)textureHeight);
    }

    public void copyPropertiesTo(MutantSnowGolemModel otherModel) {
        for (int i = 0; i < this.parts.size(); ++i) {
            otherModel.parts.get(i).method_17138(this.parts.get(i));
        }
    }

    public void method_2828(class_4587 matrixStackIn, class_4588 bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.pelvis.method_22699(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void setupAnim(MutantSnowGolem entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setAngles();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    private void setAngles() {
        this.pelvis.field_3656 = 13.5f;
        this.abdomen.field_3654 = 0.1308997f;
        this.chest.field_3654 = 0.1308997f;
        this.chest.field_3675 = 0.0f;
        this.head.field_3654 = -0.2617994f;
        this.innerHead.field_3654 = 0.0f;
        this.innerHead.field_3675 = 0.0f;
        this.arm1.field_3654 = -0.31415927f;
        this.arm1.field_3674 = 0.0f;
        this.innerArm1.field_3654 = 0.0f;
        this.innerArm1.field_3675 = 0.5235988f;
        this.innerArm1.field_3674 = 0.5235988f;
        this.foreArm1.field_3675 = -0.5235988f;
        this.foreArm1.field_3674 = -0.2617994f;
        this.innerForeArm1.field_3654 = -0.5235988f;
        this.arm2.field_3654 = -0.31415927f;
        this.arm2.field_3674 = 0.0f;
        this.innerArm2.field_3654 = 0.0f;
        this.innerArm2.field_3675 = -0.5235988f;
        this.innerArm2.field_3674 = -0.5235988f;
        this.foreArm2.field_3675 = 0.5235988f;
        this.foreArm2.field_3674 = 0.2617994f;
        this.innerForeArm2.field_3654 = -0.5235988f;
        this.leg1.field_3654 = -0.62831855f;
        this.innerLeg1.field_3674 = 0.5235988f;
        this.foreLeg1.field_3674 = -0.5235988f;
        this.innerForeLeg1.field_3654 = 0.69813174f;
        this.leg2.field_3654 = -0.62831855f;
        this.innerLeg2.field_3674 = -0.5235988f;
        this.foreLeg2.field_3674 = 0.5235988f;
        this.innerForeLeg2.field_3654 = 0.69813174f;
    }

    private void animate(MutantSnowGolem golem, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float temp = 0.5f;
        float walkAnim = class_3532.method_15374((float)(limbSwing * 0.45f)) * limbSwingAmount;
        float walkAnim1 = (class_3532.method_15362((float)((limbSwing - temp) * 0.45f)) + temp) * limbSwingAmount;
        float walkAnim2 = (class_3532.method_15362((float)((limbSwing - temp + (float)Math.PI * 2) * 0.45f)) + temp) * limbSwingAmount;
        float breatheAnim = class_3532.method_15374((float)(ageInTicks * 0.11f));
        float faceYaw = netHeadYaw * (float)Math.PI / 180.0f;
        float facePitch = headPitch * (float)Math.PI / 180.0f;
        if (golem.isThrowing()) {
            this.animateThrow(golem.getThrowingTick());
            float scale = 1.0f - class_3532.method_15363((float)((float)golem.getThrowingTick() / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim *= scale;
        }
        this.innerHead.field_3654 -= breatheAnim * 0.01f;
        this.chest.field_3654 -= breatheAnim * 0.01f;
        this.arm1.field_3674 += breatheAnim * 0.03f;
        this.arm2.field_3674 -= breatheAnim * 0.03f;
        this.innerHead.field_3654 += facePitch;
        this.innerHead.field_3675 += faceYaw;
        this.pelvis.field_3656 += Math.abs(walkAnim) * 1.5f;
        this.abdomen.field_3654 += limbSwingAmount * 0.2f;
        this.chest.field_3675 -= walkAnim * 0.1f;
        this.head.field_3654 -= limbSwingAmount * 0.2f;
        this.arm1.field_3654 -= walkAnim * 0.6f;
        this.arm2.field_3654 += walkAnim * 0.6f;
        this.innerForeArm1.field_3654 -= walkAnim * 0.2f;
        this.innerForeArm2.field_3654 += walkAnim * 0.2f;
        this.leg1.field_3654 += walkAnim1 * 1.1f;
        this.leg2.field_3654 += walkAnim2 * 1.1f;
        this.innerForeLeg1.field_3654 += walkAnim * 0.2f;
        this.innerForeLeg2.field_3654 -= walkAnim * 0.2f;
    }

    private void animateThrow(int fullTick) {
        if (fullTick < 7) {
            float tick = ((float)fullTick + this.partialTick) / 7.0f;
            float f = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.field_3654 += -f * 0.2f;
            this.chest.field_3654 += -f * 0.4f;
            this.arm1.field_3654 += -f * 1.6f;
            this.arm1.field_3674 += f * 0.8f;
            this.arm2.field_3654 += -f * 1.6f;
            this.arm2.field_3674 += -f * 0.8f;
        } else if (fullTick < 10) {
            float tick = ((float)(fullTick - 7) + this.partialTick) / 3.0f;
            float f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.field_3654 += -f * 0.4f + 0.2f;
            this.chest.field_3654 += -f * 0.6f + 0.2f;
            this.arm1.field_3654 += -f * 0.8f - 0.8f;
            this.arm1.field_3674 += 0.8f;
            this.arm2.field_3654 += -f * 0.8f - 0.8f;
            this.arm2.field_3674 += -0.8f;
        } else if (fullTick < 14) {
            this.abdomen.field_3654 += 0.2f;
            this.chest.field_3654 += 0.2f;
            this.arm1.field_3654 += -0.8f;
            this.arm1.field_3674 += 0.8f;
            this.arm2.field_3654 += -0.8f;
            this.arm2.field_3674 += -0.8f;
        } else if (fullTick < 20) {
            float tick = ((float)(fullTick - 14) + this.partialTick) / 6.0f;
            float f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.field_3654 += f * 0.2f;
            this.chest.field_3654 += f * 0.2f;
            this.arm1.field_3654 += -f * 0.8f;
            this.arm1.field_3674 += f * 0.8f;
            this.arm2.field_3654 += -f * 0.8f;
            this.arm2.field_3674 += -f * 0.8f;
        }
    }

    public void prepareMobModel(MutantSnowGolem entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.partialTick = partialTick;
    }

    public void translateArm(boolean leftHanded, class_4587 matrixStackIn) {
        this.pelvis.method_22703(matrixStackIn);
        this.abdomen.method_22703(matrixStackIn);
        this.chest.method_22703(matrixStackIn);
        if (leftHanded) {
            this.arm2.method_22703(matrixStackIn);
            this.innerArm2.method_22703(matrixStackIn);
            this.foreArm2.method_22703(matrixStackIn);
            this.innerForeArm2.method_22703(matrixStackIn);
        } else {
            this.arm1.method_22703(matrixStackIn);
            this.innerArm1.method_22703(matrixStackIn);
            this.foreArm1.method_22703(matrixStackIn);
            this.innerForeArm1.method_22703(matrixStackIn);
        }
    }
}

