/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.condition;

import com.google.gson.JsonObject;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.condition.ResourceConditionContext;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import net.fabricmc.loader.api.FabricLoader;

public class ModLoadedResourceCondition
implements ResourceCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final String modid;

    public ModLoadedResourceCondition(String modid) {
        this.modid = modid;
    }

    @Override
    public boolean test(ResourceConditionContext context) {
        return FabricLoader.getInstance().isModLoaded(this.modid);
    }

    @Override
    public ResourceConditionSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements ResourceConditionSerializer<ModLoadedResourceCondition> {
        private Serializer() {
        }

        @Override
        public void serialize(JsonObject json, ModLoadedResourceCondition condition) {
            json.addProperty("modid", condition.modid);
        }

        @Override
        public ModLoadedResourceCondition deserialize(JsonObject json) {
            if (!(json.has("modid") && json.get("modid").isJsonPrimitive() && json.get("modid").getAsJsonPrimitive().isString())) {
                throw new RuntimeException("Condition must have key 'modid' with a string value!");
            }
            return new ModLoadedResourceCondition(json.get("modid").getAsString());
        }
    }
}

