/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_106;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_201;
import net.minecraft.class_2035;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_223;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_40;
import net.minecraft.class_44;
import net.minecraft.class_5270;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_6862;
import net.minecraft.class_73;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_83;
import net.minecraft.class_85;
import net.minecraft.class_91;

public abstract class LootTableGenerator
extends ResourceGenerator {
    private static final Gson GSON = class_5270.method_27862().create();
    private final Map<class_2960, LootTableBuilder> lootTables = new HashMap<class_2960, LootTableBuilder>();

    public LootTableGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (LootTableBuilder lootTableBuilder : this.lootTables.values()) {
            JsonObject json = new JsonObject();
            if (lootTableBuilder.parameters != class_173.field_1177) {
                json.addProperty("type", class_173.method_762((class_176)lootTableBuilder.parameters).toString());
            }
            if (!lootTableBuilder.functions.isEmpty()) {
                JsonArray functionsJson = new JsonArray();
                for (class_117 function : lootTableBuilder.functions) {
                    functionsJson.add(GSON.toJsonTree((Object)function));
                }
                json.add("functions", (JsonElement)functionsJson);
            }
            if (!lootTableBuilder.pools.isEmpty()) {
                JsonArray poolsJson = new JsonArray();
                for (LootPoolBuilder pool : lootTableBuilder.pools) {
                    JsonObject poolJson = new JsonObject();
                    if (pool.name != null && !pool.name.isEmpty()) {
                        poolJson.addProperty("name", pool.name);
                    }
                    poolJson.add("rolls", GSON.toJsonTree((Object)pool.rolls));
                    if (!(pool.bonusRolls instanceof class_44) || pool.bonusRolls.method_366(null) != 0) {
                        poolJson.add("bonus_rolls", GSON.toJsonTree((Object)pool.bonusRolls));
                    }
                    if (!pool.conditions.isEmpty()) {
                        JsonArray conditionsJson = new JsonArray();
                        for (class_5341 condition : pool.conditions) {
                            conditionsJson.add(GSON.toJsonTree((Object)condition));
                        }
                        poolJson.add("conditions", (JsonElement)conditionsJson);
                    }
                    if (!pool.functions.isEmpty()) {
                        JsonArray functionsJson = new JsonArray();
                        for (class_117 function : pool.functions) {
                            functionsJson.add(GSON.toJsonTree((Object)function));
                        }
                        poolJson.add("functions", (JsonElement)functionsJson);
                    }
                    if (pool.entries.isEmpty()) {
                        throw new RuntimeException("Loot table '" + lootTableBuilder.identifier + "' has loot pool without any entries!");
                    }
                    JsonArray entriesJson = new JsonArray();
                    for (class_79 entry : pool.entries) {
                        entriesJson.add(GSON.toJsonTree((Object)entry));
                    }
                    poolJson.add("entries", (JsonElement)entriesJson);
                    poolsJson.add((JsonElement)poolJson);
                }
                json.add("pools", (JsonElement)poolsJson);
            }
            class_2960 identifier = lootTableBuilder.identifier;
            this.cache.saveJsonResource(ResourceType.DATA, json, identifier.method_12836(), "loot_tables", identifier.method_12832());
        }
    }

    protected LootTableBuilder lootTable(class_2960 identifier) {
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, identifier.method_12836(), "loot_tables", identifier.method_12832(), ".json");
        return this.lootTables.computeIfAbsent(identifier, LootTableBuilder::new);
    }

    protected LootTableBuilder lootTable(String namespace, String path) {
        return this.lootTable(new class_2960(namespace, path));
    }

    protected LootTableBuilder lootTable(class_2248 block) {
        return this.lootTable(block.method_26162());
    }

    protected LootTableBuilder dropSelf(class_2248 block) {
        return this.lootTable(block).blockParameters().pool(poolBuilder -> poolBuilder.survivesExplosionCondition().itemEntry((class_1935)block));
    }

    protected LootTableBuilder dropSelfWhenSilkTouch(class_2248 block) {
        return this.lootTable(block).blockParameters().pool(poolBuilder -> poolBuilder.hasEnchantmentCondition(class_1893.field_9099).itemEntry((class_1935)block));
    }

    @Override
    public String getName() {
        return this.modName + " Loot Table Generator";
    }

    public static class LootTableBuilder {
        protected final class_2960 identifier;
        private final List<LootPoolBuilder> pools = new ArrayList<LootPoolBuilder>();
        private final List<class_117> functions = new ArrayList<class_117>();
        private class_176 parameters = class_173.field_1177;

        protected LootTableBuilder(class_2960 identifier) {
            this.identifier = identifier;
        }

        public LootTableBuilder parameters(class_176 parameters) {
            if (class_173.method_762((class_176)parameters) == null) {
                throw new IllegalArgumentException("Cannot use unregistered parameter set '" + parameters + "'!");
            }
            this.parameters = parameters;
            return this;
        }

        public LootTableBuilder blockParameters() {
            return this.parameters(class_173.field_1172);
        }

        public LootTableBuilder chestParameters() {
            return this.parameters(class_173.field_1179);
        }

        public LootTableBuilder pool(Consumer<LootPoolBuilder> poolBuilderConsumer) {
            LootPoolBuilder poolBuilder = new LootPoolBuilder();
            poolBuilderConsumer.accept(poolBuilder);
            this.pools.add(poolBuilder);
            return this;
        }

        public LootTableBuilder function(class_117 function) {
            if (class_7923.field_41134.method_10221((Object)function.method_29321()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered item function '" + function + "'!");
            }
            this.functions.add(function);
            return this;
        }
    }

    public static class LootPoolBuilder {
        private final List<class_5341> conditions = new ArrayList<class_5341>();
        private final List<class_117> functions = new ArrayList<class_117>();
        private final List<class_79> entries = new ArrayList<class_79>();
        private class_5658 rolls = class_44.method_32448((float)1.0f);
        private class_5658 bonusRolls = class_44.method_32448((float)0.0f);
        private String name;

        protected LootPoolBuilder() {
        }

        public LootPoolBuilder rolls(class_5658 provider) {
            if (class_7923.field_41136.method_10221((Object)provider.method_365()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered number provider '" + provider + "'!");
            }
            this.rolls = provider;
            return this;
        }

        public LootPoolBuilder constantRolls(int rolls) {
            return this.rolls((class_5658)class_44.method_32448((float)rolls));
        }

        public LootPoolBuilder uniformRolls(int min, int max) {
            return this.rolls((class_5658)class_5662.method_32462((float)min, (float)max));
        }

        public LootPoolBuilder binomialRolls(int n, int p) {
            return this.rolls((class_5658)class_40.method_273((int)n, (float)p));
        }

        public LootPoolBuilder bonusRolls(class_5658 provider) {
            if (class_7923.field_41136.method_10221((Object)provider.method_365()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered number provider '" + provider + "'!");
            }
            this.bonusRolls = provider;
            return this;
        }

        public LootPoolBuilder constantBonusRolls(int rolls) {
            return this.bonusRolls((class_5658)class_44.method_32448((float)rolls));
        }

        public LootPoolBuilder uniformBonusRolls(int min, int max) {
            return this.bonusRolls((class_5658)class_5662.method_32462((float)min, (float)max));
        }

        public LootPoolBuilder binomialBonusRolls(int n, int p) {
            return this.bonusRolls((class_5658)class_40.method_273((int)n, (float)p));
        }

        public LootPoolBuilder name(String name) {
            this.name = name;
            return this;
        }

        public LootPoolBuilder condition(class_5341 condition) {
            if (class_7923.field_41135.method_10221((Object)condition.method_29325()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered loot pool condition '" + condition + "'!");
            }
            this.conditions.add(condition);
            return this;
        }

        public LootPoolBuilder survivesExplosionCondition() {
            return this.condition(class_201.method_871().build());
        }

        public LootPoolBuilder hasEnchantmentCondition(class_1887 enchantment, int minLevel, int maxLevel) {
            return this.condition(class_223.method_945((class_2073.class_2074)class_2073.class_2074.method_8973().method_8978(new class_2035(enchantment, class_2096.class_2100.method_35287((int)minLevel, (int)maxLevel)))).build());
        }

        public LootPoolBuilder hasEnchantmentCondition(class_1887 enchantment, int minLevel) {
            return this.condition(class_223.method_945((class_2073.class_2074)class_2073.class_2074.method_8973().method_8978(new class_2035(enchantment, class_2096.class_2100.method_9053((int)minLevel)))).build());
        }

        public LootPoolBuilder hasEnchantmentCondition(class_1887 enchantment) {
            return this.hasEnchantmentCondition(enchantment, 1);
        }

        public LootPoolBuilder entry(class_79 entry) {
            if (class_7923.field_41133.method_10221((Object)entry.method_29318()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered loot pool entry '" + entry + "'!");
            }
            this.entries.add(entry);
            return this;
        }

        private LootPoolBuilder entry(class_85.class_86<?> entry, int weight) {
            if (weight <= 0) {
                throw new IllegalArgumentException("Loot entry weight must be greater than zero, not '" + weight + "'!");
            }
            return this.entry(entry.method_437(weight).method_419());
        }

        public LootPoolBuilder emptyEntry(int weight) {
            return this.entry(class_73.method_401(), weight);
        }

        public LootPoolBuilder emptyEntry() {
            return this.emptyEntry(1);
        }

        public LootPoolBuilder itemEntry(class_1935 item, int weight) {
            return this.entry(class_77.method_411((class_1935)item), weight);
        }

        public LootPoolBuilder itemEntry(class_1935 item) {
            return this.itemEntry(item, 1);
        }

        public LootPoolBuilder itemEntry(class_1935 item, int count, int weight) {
            return this.entry(class_77.method_411((class_1935)item).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)count))), weight);
        }

        public LootPoolBuilder itemEntry(class_1935 item, int min, int max, int weight) {
            return this.entry(class_77.method_411((class_1935)item).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)min, (float)max))), weight);
        }

        public LootPoolBuilder itemEntry(class_2960 item) {
            if (!Registries.ITEMS.hasIdentifier(item)) {
                throw new IllegalArgumentException("Could not find any item registered under '" + item + "'!");
            }
            return this.itemEntry((class_1935)Registries.ITEMS.getValue(item));
        }

        public LootPoolBuilder itemEntry(String namespace, String identifier) {
            return this.itemEntry(new class_2960(namespace, identifier));
        }

        public LootPoolBuilder enchantedItemEntry(class_1935 item, int levels, boolean allowCurses, int weight) {
            class_106.class_107 builder = class_106.method_481((class_5658)class_44.method_32448((float)levels));
            if (allowCurses) {
                builder.method_484();
            }
            return this.entry(class_77.method_411((class_1935)item).method_438((class_117.class_118)builder), weight);
        }

        public LootPoolBuilder enchantedItemEntry(class_1935 item, int minLevels, int maxLevels, boolean allowCurses, int weight) {
            class_106.class_107 builder = class_106.method_481((class_5658)class_5662.method_32462((float)minLevels, (float)maxLevels));
            if (allowCurses) {
                builder.method_484();
            }
            return this.entry(class_77.method_411((class_1935)item).method_438((class_117.class_118)builder), weight);
        }

        public LootPoolBuilder tagEntry(class_6862<class_1792> tagKey, int weight) {
            return this.entry(class_91.method_35517(tagKey), weight);
        }

        public LootPoolBuilder tagEntry(class_6862<class_1792> tagKey) {
            return this.tagEntry(tagKey, 1);
        }

        public LootPoolBuilder tagEntry(class_2960 tag, int weight) {
            return this.tagEntry((class_6862<class_1792>)class_6862.method_40092((class_5321)Registries.ITEMS.getVanillaRegistry().method_30517(), (class_2960)tag), weight);
        }

        public LootPoolBuilder tagEntry(class_2960 tag) {
            return this.tagEntry((class_6862<class_1792>)class_6862.method_40092((class_5321)Registries.ITEMS.getVanillaRegistry().method_30517(), (class_2960)tag));
        }

        public LootPoolBuilder tagEntry(String namespace, String path, int weight) {
            return this.tagEntry(new class_2960(namespace, path), weight);
        }

        public LootPoolBuilder tagEntry(String namespace, String path) {
            return this.tagEntry(new class_2960(namespace, path));
        }

        public LootPoolBuilder lootTableEntry(class_2960 lootTable, int weight) {
            return this.entry(class_83.method_428((class_2960)lootTable), weight);
        }

        public LootPoolBuilder lootTableEntry(class_2960 lootTable) {
            return this.lootTableEntry(lootTable, 1);
        }

        public LootPoolBuilder lootTableEntry(String namespace, String path, int weight) {
            return this.lootTableEntry(new class_2960(namespace, path), weight);
        }

        public LootPoolBuilder lootTableEntry(String namespace, String path) {
            return this.lootTableEntry(new class_2960(namespace, path));
        }

        public LootPoolBuilder function(class_117 function) {
            if (class_7923.field_41134.method_10221((Object)function.method_29321()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered item function '" + function + "'!");
            }
            this.functions.add(function);
            return this;
        }
    }
}

