/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.hotkey;

import appeng.client.guidebook.GuidebookText;
import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.indices.ItemIndex;
import appeng.client.guidebook.screen.GuideScreen;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.AppEngClient;
import com.google.common.base.Strings;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenGuideHotkey {
    private static final class_304 OPEN_GUIDE_MAPPING = new class_304("key.ae2.guide", 71, "key.ae2.category");
    private static final Logger LOG = LoggerFactory.getLogger(OpenGuideHotkey.class);
    private static final int TICKS_TO_OPEN = 10;
    private static final class_2960 TOOLTIP_PHASE = AppEng.makeId("open_guide_for_item");
    private static boolean newTick = true;
    private static class_1799 lastStack;
    @Nullable
    private static PageAnchor guidebookPage;
    private static int ticksKeyHeld;
    private static boolean holding;

    private OpenGuideHotkey() {
    }

    public static void init() {
        if (AEConfig.instance().isGuideHotkeyEnabled()) {
            KeyBindingHelper.registerKeyBinding((class_304)OPEN_GUIDE_MAPPING);
            ItemTooltipCallback.EVENT.register(TOOLTIP_PHASE, OpenGuideHotkey::handleTooltip);
            ItemTooltipCallback.EVENT.addPhaseOrdering(Event.DEFAULT_PHASE, TOOLTIP_PHASE);
            ClientTickEvents.START_CLIENT_TICK.register(client -> {
                newTick = true;
            });
        } else {
            LOG.info("AE2 guide hotkey is disabled via config.");
        }
    }

    private static void handleTooltip(class_1799 itemStack, class_1836 tooltipFlag, List<class_2561> lines) {
        GuideScreen guideScreen;
        if (!OpenGuideHotkey.isKeyBound()) {
            holding = false;
            ticksKeyHeld = 0;
            return;
        }
        if (newTick) {
            newTick = false;
            OpenGuideHotkey.update(itemStack);
        }
        if (guidebookPage == null) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        class_437 class_4372 = minecraft.field_1755;
        if (class_4372 instanceof GuideScreen && (guideScreen = (GuideScreen)class_4372).getCurrentPageId().equals((Object)guidebookPage.pageId())) {
            return;
        }
        float progress = ticksKeyHeld;
        progress = holding ? (progress += minecraft.method_1488()) : (progress -= minecraft.method_1488());
        class_2561 component = OpenGuideHotkey.makeProgressBar(class_3532.method_15363((float)(progress /= 10.0f), (float)0.0f, (float)1.0f));
        if (lines.isEmpty()) {
            lines.add(component);
        } else {
            lines.add(1, component);
        }
    }

    private static class_2561 makeProgressBar(float progress) {
        class_310 minecraft = class_310.method_1551();
        class_5250 holdW = GuidebookText.HoldToShow.text(OpenGuideHotkey.getHotkey().method_16007().method_27661().method_27692(class_124.field_1080)).method_27692(class_124.field_1063);
        class_327 fontRenderer = minecraft.field_1772;
        int charWidth = fontRenderer.method_1727("|");
        int tipWidth = fontRenderer.method_27525((class_5348)holdW);
        int total = tipWidth / charWidth;
        int current = (int)(progress * (float)total);
        if (progress > 0.0f) {
            class_5250 result = class_2561.method_43470((String)Strings.repeat((String)"|", (int)current)).method_27692(class_124.field_1080);
            if (progress < 1.0f) {
                result = result.method_10852((class_2561)class_2561.method_43470((String)Strings.repeat((String)"|", (int)(total - current))).method_27692(class_124.field_1063));
            }
            return result;
        }
        return holdW;
    }

    private static void update(class_1799 itemStack) {
        if (itemStack != lastStack) {
            lastStack = itemStack;
            guidebookPage = null;
            ticksKeyHeld = 0;
            class_2960 itemId = itemStack.method_41409().method_40230().map(class_5321::method_29177).orElse(null);
            if (itemId == null) {
                return;
            }
            ItemIndex itemIndex = AppEngClient.instance().getGuide().getIndex(ItemIndex.class);
            guidebookPage = (PageAnchor)itemIndex.get(itemId);
        }
        if (holding = OpenGuideHotkey.isKeyHeld()) {
            if (ticksKeyHeld < 10 && ++ticksKeyHeld == 10) {
                if (guidebookPage != null) {
                    class_437 class_4372 = class_310.method_1551().field_1755;
                    if (class_4372 instanceof GuideScreen) {
                        GuideScreen guideScreen = (GuideScreen)class_4372;
                        guideScreen.navigateTo(guidebookPage);
                    } else {
                        AppEngClient.instance().openGuideAtAnchor(guidebookPage);
                    }
                    ticksKeyHeld = 0;
                    holding = false;
                }
            } else if (ticksKeyHeld > 10) {
                ticksKeyHeld = 10;
            }
        } else {
            ticksKeyHeld = Math.max(0, ticksKeyHeld - 2);
        }
    }

    private static boolean isKeyHeld() {
        class_3675.class_306 boundKey = KeyBindingHelper.getBoundKeyOf((class_304)OpenGuideHotkey.getHotkey());
        int keyCode = boundKey.method_1444();
        long window = class_310.method_1551().method_22683().method_4490();
        return class_3675.method_15987((long)window, (int)keyCode);
    }

    private static boolean isKeyBound() {
        return !OPEN_GUIDE_MAPPING.method_1415();
    }

    public static class_304 getHotkey() {
        return OPEN_GUIDE_MAPPING;
    }
}

