/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene.export;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_5253;
import net.minecraft.class_7764;

final class InterpolatedSpriteBuilder {
    private InterpolatedSpriteBuilder() {
    }

    public static InterpolatedResult interpolate(class_1011 frameSheet, int frameWidth, int frameHeight, int frameRowCount, List<class_7764.class_5791> frames) {
        InterpolatedFrame interpFrame;
        ArrayList<InterpolatedFrame> interpFrames = new ArrayList<InterpolatedFrame>();
        IntArrayList interpolated = new IntArrayList();
        for (int i = 0; i < frames.size(); ++i) {
            class_7764.class_5791 frame = frames.get(i);
            class_7764.class_5791 nextFrame = frames.get((i + 1) % frames.size());
            for (int j = 0; j < frame.field_28476; ++j) {
                float f = (float)j / (float)frame.field_28476;
                interpFrame = new InterpolatedFrame(frame.field_28475, nextFrame.field_28475, f);
                int newIndex = interpFrames.indexOf(interpFrame);
                if (newIndex != -1) {
                    interpolated.add(newIndex);
                    continue;
                }
                interpolated.add(interpFrames.size());
                interpFrames.add(interpFrame);
            }
        }
        int height = interpFrames.size() * frameHeight;
        class_1011 nativeImage = new class_1011(frameSheet.method_4318(), frameWidth, height, false);
        for (int i = 0; i < interpFrames.size(); ++i) {
            int destX = 0;
            int destY = i * frameHeight;
            interpFrame = (InterpolatedFrame)interpFrames.get(i);
            int srcIndexA = interpFrame.aIndex;
            int srcIndexB = interpFrame.bIndex;
            int srcX = srcIndexA % frameRowCount * frameWidth;
            int srcY = srcIndexA / frameRowCount * frameHeight;
            frameSheet.method_47594(nativeImage, srcX, srcY, destX, destY, frameWidth, frameHeight, false, false);
            if (srcIndexA == srcIndexB) continue;
            InterpolatedSpriteBuilder.blend(frameSheet, srcIndexB % frameRowCount * frameWidth, srcIndexB / frameRowCount * frameHeight, nativeImage, destX, destY, frameWidth, frameHeight, interpFrame.f);
        }
        return new InterpolatedResult(nativeImage, interpolated.toIntArray(), interpFrames.size(), 1);
    }

    private static void blend(class_1011 source, int srcX, int srcY, class_1011 dest, int destX, int destY, int frameWidth, int frameHeight, float alpha) {
        for (int y = 0; y < frameHeight; ++y) {
            for (int x = 0; x < frameWidth; ++x) {
                int srcColor = source.method_4315(srcX + x, srcY + y);
                int destColor = dest.method_4315(destX + x, destY + y);
                dest.method_4305(destX + x, destY + y, class_5253.class_5254.method_48780((float)alpha, (int)destColor, (int)srcColor));
            }
        }
    }

    record InterpolatedFrame(int aIndex, int bIndex, float f) {
        public InterpolatedFrame(int frame) {
            this(frame, frame, 0.0f);
        }

        InterpolatedFrame(int aIndex, int bIndex, float f) {
            if (Math.abs(f) < 0.01f) {
                f = 0.0f;
                bIndex = aIndex;
            } else if (Math.abs(1.0f - f) < 0.01f) {
                f = 0.0f;
                aIndex = bIndex;
            }
            if (bIndex < aIndex) {
                this.aIndex = bIndex;
                this.bIndex = aIndex;
                this.f = 1.0f - f;
            } else {
                this.aIndex = aIndex;
                this.bIndex = bIndex;
                this.f = f;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InterpolatedFrame that = (InterpolatedFrame)o;
            return this.aIndex == that.aIndex && this.bIndex == that.bIndex && Math.abs(this.f - that.f) < 0.01f;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.aIndex, this.bIndex, Float.valueOf(this.f));
        }
    }

    record InterpolatedResult(class_1011 frames, int[] indices, int frameCount, int frameRowSize) {
    }
}

