/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.implementations.blockentities.IWirelessAccessPoint;
import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.IGrid;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableItem;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.upgrades.Upgrades;
import appeng.api.util.IConfigManager;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.core.localization.Tooltips;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.common.MEStorageMenu;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.function.DoubleSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3917;
import net.minecraft.class_4208;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WirelessTerminalItem
extends AEBasePoweredItem
implements IMenuItem,
IUpgradeableItem {
    private static final Logger LOG = LoggerFactory.getLogger(WirelessTerminalItem.class);
    public static final IGridLinkableHandler LINKABLE_HANDLER = new LinkableHandler();
    private static final String TAG_ACCESS_POINT_POS = "accessPoint";

    public WirelessTerminalItem(DoubleSupplier powerCapacity, class_1792.class_1793 props) {
        super(powerCapacity, props);
    }

    @Override
    public double getChargeRate(class_1799 stack) {
        return 800.0 + 800.0 * (double)Upgrades.getEnergyCardMultiplier(this.getUpgrades(stack));
    }

    public boolean openFromInventory(class_1657 player, int inventorySlot) {
        return this.openFromInventory(player, inventorySlot, false);
    }

    protected boolean openFromInventory(class_1657 player, int inventorySlot, boolean returningFromSubmenu) {
        class_1799 is = player.method_31548().method_5438(inventorySlot);
        if (this.checkPreconditions(is, player)) {
            return MenuOpener.open(this.getMenuType(), player, MenuLocators.forInventorySlot(inventorySlot), returningFromSubmenu);
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 is = player.method_5998(hand);
        if (this.checkPreconditions(is, player) && MenuOpener.open(this.getMenuType(), player, MenuLocators.forHand(player, hand))) {
            return new class_1271(class_1269.method_29236((boolean)level.method_8608()), (Object)is);
        }
        return new class_1271(class_1269.field_5814, (Object)is);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> lines, class_1836 advancedTooltips) {
        super.method_7851(stack, level, lines, advancedTooltips);
        if (this.getLinkedPosition(stack) == null) {
            lines.add((class_2561)Tooltips.of(GuiText.Unlinked, Tooltips.RED, new Object[0]));
        } else {
            lines.add((class_2561)Tooltips.of(GuiText.Linked, Tooltips.GREEN, new Object[0]));
        }
    }

    @Nullable
    public class_4208 getLinkedPosition(class_1799 item) {
        class_2487 tag = item.method_7969();
        if (tag != null && tag.method_10573(TAG_ACCESS_POINT_POS, 10)) {
            return class_4208.field_25066.decode((DynamicOps)class_2509.field_11560, (Object)tag.method_10580(TAG_ACCESS_POINT_POS)).resultOrPartial(class_156.method_29188((String)"Linked position", arg_0 -> ((Logger)LOG).error(arg_0))).map(Pair::getFirst).orElse(null);
        }
        return null;
    }

    @Nullable
    public IGrid getLinkedGrid(class_1799 item, class_1937 level, @Nullable class_1657 sendMessagesTo) {
        if (!(level instanceof class_3218)) {
            return null;
        }
        class_3218 serverLevel = (class_3218)level;
        class_4208 linkedPos = this.getLinkedPosition(item);
        if (linkedPos == null) {
            if (sendMessagesTo != null) {
                sendMessagesTo.method_7353((class_2561)PlayerMessages.DeviceNotLinked.text(), true);
            }
            return null;
        }
        class_3218 linkedLevel = serverLevel.method_8503().method_3847(linkedPos.method_19442());
        if (linkedLevel == null) {
            if (sendMessagesTo != null) {
                sendMessagesTo.method_7353((class_2561)PlayerMessages.LinkedNetworkNotFound.text(), true);
            }
            return null;
        }
        class_2586 be = Platform.getTickingBlockEntity((class_1937)linkedLevel, linkedPos.method_19446());
        if (!(be instanceof IWirelessAccessPoint)) {
            if (sendMessagesTo != null) {
                sendMessagesTo.method_7353((class_2561)PlayerMessages.LinkedNetworkNotFound.text(), true);
            }
            return null;
        }
        IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)be;
        IGrid grid = accessPoint.getGrid();
        if (grid == null && sendMessagesTo != null) {
            sendMessagesTo.method_7353((class_2561)PlayerMessages.LinkedNetworkNotFound.text(), true);
        }
        return grid;
    }

    public class_3917<?> getMenuType() {
        return MEStorageMenu.WIRELESS_TYPE;
    }

    @Override
    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    @Override
    @Nullable
    public ItemMenuHost getMenuHost(class_1657 player, int inventorySlot, class_1799 stack, @Nullable class_2338 pos) {
        return new WirelessTerminalMenuHost(player, inventorySlot, stack, (p, subMenu) -> this.openFromInventory((class_1657)p, inventorySlot, true));
    }

    protected boolean checkPreconditions(class_1799 item, class_1657 player) {
        if (item.method_7960() || item.method_7909() != this) {
            return false;
        }
        class_1937 level = player.method_5770();
        if (this.getLinkedGrid(item, player.method_37908(), player) == null) {
            return false;
        }
        if (!this.hasPower(player, 0.5, item)) {
            player.method_7353((class_2561)PlayerMessages.DeviceNotPowered.text(), true);
            return false;
        }
        return true;
    }

    public boolean usePower(class_1657 player, double amount, class_1799 is) {
        return this.extractAEPower(is, amount, Actionable.MODULATE) >= amount - 0.5;
    }

    public boolean hasPower(class_1657 player, double amt, class_1799 is) {
        return this.getAECurrentPower(is) >= amt;
    }

    public IConfigManager getConfigManager(class_1799 target) {
        ConfigManager out = new ConfigManager((manager, settingName) -> manager.writeToNBT(target.method_7948()));
        out.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        out.registerSetting(Settings.TYPE_FILTER, TypeFilter.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        out.readFromNBT(target.method_7948().method_10553());
        return out;
    }

    @Override
    public IUpgradeInventory getUpgrades(class_1799 stack) {
        return UpgradeInventories.forItem(stack, 2, this::onUpgradesChanged);
    }

    private void onUpgradesChanged(class_1799 stack, IUpgradeInventory upgrades) {
        this.setAEMaxPowerMultiplier(stack, 1 + Upgrades.getEnergyCardMultiplier(upgrades));
    }

    private static class LinkableHandler
    implements IGridLinkableHandler {
        private LinkableHandler() {
        }

        @Override
        public boolean canLink(class_1799 stack) {
            return stack.method_7909() instanceof WirelessTerminalItem;
        }

        @Override
        public void link(class_1799 itemStack, class_4208 pos) {
            class_4208.field_25066.encodeStart((DynamicOps)class_2509.field_11560, (Object)pos).result().ifPresent(tag -> itemStack.method_7948().method_10566(WirelessTerminalItem.TAG_ACCESS_POINT_POS, tag));
        }

        @Override
        public void unlink(class_1799 itemStack) {
            itemStack.method_7983(WirelessTerminalItem.TAG_ACCESS_POINT_POS);
        }
    }
}

