/*
 * Decompiled with CFR 0.152.
 */
package appeng.shaded.methvin.watcher;

import appeng.shaded.methvin.watcher.DirectoryChangeEvent;
import appeng.shaded.methvin.watcher.DirectoryChangeListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public final class OnTimeoutListener
implements DirectoryChangeListener {
    private final int timeoutMillis;
    private final Consumer<Integer> timeoutCallback;
    private final AtomicReference<ScheduledFuture<?>> currentTaskRef = new AtomicReference();
    private final ScheduledExecutorService service;

    public OnTimeoutListener(int n, Consumer<Integer> consumer) {
        if (n < 0) {
            throw new IllegalArgumentException("timeoutMillis must be non-negative");
        }
        if (consumer == null) {
            throw new IllegalArgumentException("timeoutCallback must be non-null");
        }
        this.timeoutMillis = n;
        this.timeoutCallback = consumer;
        this.service = Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    public void onEvent(DirectoryChangeEvent directoryChangeEvent) {
        ScheduledFuture scheduledFuture = this.currentTaskRef.getAndSet(null);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
    }

    @Override
    public void onIdle(int n) {
        this.currentTaskRef.getAndUpdate(scheduledFuture -> {
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            return this.service.schedule(() -> this.timeoutCallback.accept(n), (long)this.timeoutMillis, TimeUnit.MILLISECONDS);
        });
    }
}

