/*
 * Decompiled with CFR 0.152.
 */
package nourl.mythicmetals.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.wispforest.owo.util.ReflectionUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8056;
import nourl.mythicmetals.armor.ArmorSet;
import nourl.mythicmetals.armor.MythicArmor;
import nourl.mythicmetals.command.ArmorSetArgumentType;
import nourl.mythicmetals.command.ToolSetArgumentType;
import nourl.mythicmetals.config.MythicOreConfigs;
import nourl.mythicmetals.config.OreConfig;
import nourl.mythicmetals.item.tools.MythicTools;
import nourl.mythicmetals.item.tools.ToolSet;
import nourl.mythicmetals.misc.RegistryHelper;
import nourl.mythicmetals.misc.StringUtilsAtHome;
import org.apache.commons.lang3.mutable.MutableInt;

public final class MythicCommands {
    private MythicCommands() {
    }

    public static void init() {
        ArgumentTypeRegistry.registerArgumentType((class_2960)RegistryHelper.id("toolset"), ToolSetArgumentType.class, (class_2314)class_2319.method_41999(ToolSetArgumentType::toolSet));
        ArgumentTypeRegistry.registerArgumentType((class_2960)RegistryHelper.id("armorset"), ArmorSetArgumentType.class, (class_2314)class_2319.method_41999(ArmorSetArgumentType::armorSet));
    }

    public static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccessdedicated, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mythicmetals").requires(source -> source.method_9259(1))).then(class_2170.method_9247((String)"range").then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests(MythicCommands::dumpType).executes(MythicCommands::dumpOreConfig)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"wiki").then(class_2170.method_9247((String)"tools").then(class_2170.method_9244((String)"toolset", (ArgumentType)ToolSetArgumentType.toolSet()).executes(MythicCommands::exportTools)))).then(class_2170.method_9247((String)"armor").then(class_2170.method_9244((String)"armorset", (ArgumentType)ArmorSetArgumentType.armorSet()).executes(MythicCommands::exportArmor))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"armor-stand").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"material", (ArgumentType)StringArgumentType.word()).suggests(MythicCommands::armorMaterial).then(class_2170.method_9244((String)"trim_pattern", (ArgumentType)StringArgumentType.word()).suggests(MythicCommands::trimTypes).executes(MythicCommands::armorStandCommand))))));
    }

    private static int exportArmor(CommandContext<class_2168> context) {
        ArmorSet armorSet = ArmorSetArgumentType.getArmorSet(context, "armorset");
        String br = "<br>\n";
        class_2168 source = (class_2168)context.getSource();
        StringBuilder output = new StringBuilder();
        for (class_1738 armor : armorSet.getArmorItems()) {
            String id = class_7923.field_41178.method_10221((Object)armor).method_12832();
            String name = StringUtilsAtHome.toProperCase(id.replace('_', ' '));
            int protection = armor.method_7687();
            output.append("\n");
            output.append("<center class=tooltip>").append("\n");
            output.append("<h4>**").append(name).append("**</h4>").append("\n");
            output.append("![Image of %s](../assets/mythicmetals/armor/%s.png)".formatted(name, id)).append(br);
            for (int i = 1; i < protection; i += 2) {
                output.append("![armor](../assets/minecraft/full_armor_icon.png){ .sized-image style=\"--image-width: 8%;\" }").append("\n");
            }
            if ((protection & 1) == 1) {
                output.append("![armor](../assets/minecraft/half_armor_icon.png){ .sized-image style=\"--image-width: 8%;\" }").append("\n");
            }
            output.append(br);
            output.append("+%s Armor".formatted(protection));
            if (armor.method_26353() > 0.0f) {
                output.append(", +%s Toughness".formatted(Float.valueOf(armor.method_26353())));
            }
            output.append(br);
            if (armor.method_7686().method_24355() > 0.0f) {
                output.append("+%s Knockback Resistance").append(br);
            }
            output.append("%s Durability".formatted(armor.method_7841())).append(br);
        }
        System.out.println(output);
        source.method_9226(() -> class_2561.method_43470((String)"Exported armor to wiki format"), false);
        return 0;
    }

    private static int exportTools(CommandContext<class_2168> context) {
        ToolSet toolset = ToolSetArgumentType.getToolSet(context, "toolset");
        String br = "<br>\n";
        class_2168 source = (class_2168)context.getSource();
        StringBuilder output = new StringBuilder();
        ArrayDeque<Integer> damage = new ArrayDeque<Integer>(Arrays.stream(MythicTools.DEFAULT_DAMAGE).boxed().toList());
        Stack<Float> atkSpd = new Stack<Float>();
        atkSpd.addAll(toolset.getAttackSpeed());
        for (class_1831 tool : toolset.get()) {
            String id = class_7923.field_41178.method_10221((Object)tool).method_12832();
            String name = StringUtilsAtHome.toProperCase(id.replace('_', ' '));
            output.append("\n");
            output.append("<center class=tooltip>").append("\n");
            output.append("<h4>**").append(name).append("**</h4>").append("\n");
            output.append("![Image of %s](../assets/mythicmetals/tools/%s.png)".formatted(name, id)).append(br);
            output.append("+%s Attack Damage, %s Attack Speed".formatted(Float.valueOf(tool.method_8022().method_8028() + (float)((Integer)damage.poll()).intValue() + 1.0f), BigDecimal.valueOf(4.0f + ((Float)atkSpd.pop()).floatValue()).setScale(1, RoundingMode.HALF_UP).toPlainString())).append(br);
            output.append("%s Durability".formatted(tool.method_7841())).append(br);
        }
        System.out.println(output);
        source.method_9226(() -> class_2561.method_43470((String)"Exported tools to wiki format"), false);
        return 0;
    }

    public static void summonArmorStandWithTrim(class_1937 world, @Nullable class_8053 trim, ArmorSet armorSet, int x, int z) {
        if (world.field_9236) {
            return;
        }
        class_1531 armorStand = new class_1531(world, (double)x, (double)(world.method_31600() - 50), (double)z);
        armorSet.getArmorItems().forEach(armorItem -> {
            class_1799 armorStack = new class_1799((class_1935)armorItem);
            if (trim != null) {
                class_8053.method_48429((class_5455)world.method_30349(), (class_1799)armorStack, (class_8053)trim);
            }
            armorStand.method_5673(armorItem.method_7685(), armorStack);
        });
        world.method_8649((class_1297)armorStand);
    }

    public static ArrayList<class_8053> getAllArmorTrims(class_1937 world) {
        if (world.field_9236) {
            return new ArrayList<class_8053>();
        }
        ArrayList<class_8053> list = new ArrayList<class_8053>();
        world.method_30349().method_30530(class_7924.field_42083).method_40270().forEach(armorMaterialEntry -> world.method_30349().method_30530(class_7924.field_42082).method_40270().forEach(armorTrimEntry -> list.add(new class_8053((class_6880)armorMaterialEntry, (class_6880)armorTrimEntry))));
        return list;
    }

    public static ArrayList<String> getAllTrimPatternStrs(class_1937 world) {
        if (world.field_9236) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        world.method_30349().method_30530(class_7924.field_42082).method_40270().forEach(armorTrimEntry -> list.add(((class_8056)armorTrimEntry.comp_349()).comp_1213().method_12832()));
        return list;
    }

    private static CompletableFuture<Suggestions> dumpType(CommandContext<class_2168> ctx, SuggestionsBuilder suggestion) {
        suggestion.suggest("console");
        return suggestion.buildFuture();
    }

    private static CompletableFuture<Suggestions> armorMaterial(CommandContext<class_2168> ctx, SuggestionsBuilder suggestion) {
        MythicArmor.ARMOR_MAP.forEach((s, armorSet) -> suggestion.suggest(s));
        suggestion.suggest("all");
        return suggestion.buildFuture();
    }

    private static CompletableFuture<Suggestions> trimTypes(CommandContext<class_2168> ctx, SuggestionsBuilder suggestion) {
        ArrayList<class_8056> list = new ArrayList<class_8056>();
        ((class_2168)ctx.getSource()).method_30497().method_30530(class_7924.field_42082).method_40270().forEach(armorTrimEntry -> list.add((class_8056)armorTrimEntry.comp_349()));
        list.forEach(trimPattern -> suggestion.suggest(trimPattern.comp_1213().method_12832()));
        suggestion.suggest("all").suggest("none");
        return suggestion.buildFuture();
    }

    private static CompletableFuture<Suggestions> exportables(CommandContext<class_2168> ctx, SuggestionsBuilder suggestion) {
        return suggestion.suggest("armor").suggest("tools").buildFuture();
    }

    private static int dumpOreConfig(CommandContext<class_2168> context) {
        if (StringArgumentType.getString(context, (String)"type").equals("console")) {
            ReflectionUtils.iterateAccessibleStaticFields(MythicOreConfigs.class, OreConfig.class, (feature, name, field) -> {
                if (!feature.offset && !feature.trapezoid) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(name.toUpperCase(Locale.ROOT) + " has the range between " + feature.bottom + " to " + feature.top + ", with a discard chance of " + feature.discardChance * 100.0f + "%")), false);
                }
                if (feature.offset) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(name.toUpperCase(Locale.ROOT) + " has the range between " + feature.bottom + "(offset) to " + feature.top + ", with a discard chance of " + feature.discardChance * 100.0f + "%")), false);
                }
                if (feature.trapezoid) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(name.toUpperCase(Locale.ROOT) + " has a triangle range between " + feature.bottom + " to " + feature.top + ", where the sweet spot is at Y = " + (feature.bottom + feature.top) / 2 + " with a discard chance of " + feature.discardChance * 100.0f + "%")), false);
                }
            });
            return 1;
        }
        return 1;
    }

    private static int armorStandCommand(CommandContext<class_2168> context) {
        String material = StringArgumentType.getString(context, (String)"material");
        String trimQuery = StringArgumentType.getString(context, (String)"trim_pattern");
        ArrayList<Object> armorTrims = new ArrayList();
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_243 pos = ((class_2168)context.getSource()).method_9222();
        if (trimQuery.equals("none")) {
            if (material.equals("all")) {
                MutableInt mutX = new MutableInt((Number)pos.field_1352);
                MutableInt count = new MutableInt(0);
                MythicArmor.ARMOR_MAP.forEach((s, armorSet) -> {
                    MythicCommands.summonArmorStandWithTrim((class_1937)world, null, armorSet, mutX.getAndIncrement(), 0);
                    count.increment();
                });
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Summoned %d armorstands".formatted(count.getValue())), true);
            } else {
                MythicCommands.summonArmorStandWithTrim((class_1937)world, null, MythicArmor.ARMOR_MAP.get(material), 0, 0);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Summoned armorstands"), true);
            }
            return 1;
        }
        if (material.equals("all")) {
            if (MythicArmor.ARMOR_MAP.isEmpty()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Unable to summon. Somehow the armor map is empty..."), false);
                return 1;
            }
            if (trimQuery.equals("all")) {
                armorTrims.addAll(MythicCommands.getAllArmorTrims((class_1937)world).stream().toList());
            } else if (MythicCommands.getAllTrimPatternStrs((class_1937)world).contains(trimQuery)) {
                armorTrims.addAll(MythicCommands.getAllArmorTrims((class_1937)world).stream().filter(trim -> ((class_8056)trim.method_48424().comp_349()).comp_1213().method_12832().equals(trimQuery)).toList());
            }
            MutableInt mutX = new MutableInt((Number)pos.field_1352);
            MutableInt mutZ = new MutableInt((Number)pos.field_1350);
            MutableInt count = new MutableInt(0);
            ArrayList<Object> finalArmorTrims = armorTrims;
            MythicArmor.ARMOR_MAP.forEach((s, armorSet) -> {
                finalArmorTrims.forEach(armorTrim -> {
                    MythicCommands.summonArmorStandWithTrim((class_1937)world, armorTrim, armorSet, mutX.getAndIncrement(), mutZ.getValue());
                    count.increment();
                });
                mutZ.increment();
                mutX.setValue(0);
            });
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Summoned %d armorstands with trims".formatted(count.getValue())), true);
            return 1;
        }
        if (MythicArmor.ARMOR_MAP.get(material) != null) {
            if (trimQuery.equals("all")) {
                armorTrims = MythicCommands.getAllArmorTrims((class_1937)world);
            } else {
                List<class_8053> trims = MythicCommands.getAllArmorTrims((class_1937)world).stream().filter(trim -> ((class_8056)trim.method_48424().comp_349()).comp_1213().method_12832().equals(trimQuery)).toList();
                armorTrims.addAll(trims);
            }
            int splitPoint = armorTrims.size() / world.method_30349().method_30530(class_7924.field_42083).method_10204();
            int xOffset = 0;
            int zOffset = 0;
            int count = 0;
            for (int i = 0; i < armorTrims.size(); ++i) {
                if (i % splitPoint == 0) {
                    xOffset += 2;
                    zOffset = 0;
                }
                ArmorSet armorSet2 = MythicArmor.ARMOR_MAP.get(material);
                MythicCommands.summonArmorStandWithTrim((class_1937)world, (class_8053)armorTrims.get(i), armorSet2, (int)pos.field_1352 + xOffset, (int)pos.field_1350 + zOffset);
                ++count;
                zOffset += 2;
            }
            String feedback = "Summoned %d armorstands".formatted(count);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)feedback), true);
        }
        return 1;
    }
}

