/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.api.background.example.with_input_string;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.api.Nonnull;
import de.keksuccino.fancymenu.api.background.MenuBackground;
import de.keksuccino.fancymenu.api.background.MenuBackgroundType;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import java.io.File;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class ExampleMenuBackgroundForInputString
extends MenuBackground {
    private ExternalTextureResourceLocation imageLocation = null;

    public ExampleMenuBackgroundForInputString(@Nonnull MenuBackgroundType type, String imagePath) {
        super("unused_identifier", type);
        File imageFile = new File(imagePath);
        if (imageFile.exists() && (imageFile.getPath().toLowerCase().endsWith(".jpg") || imageFile.getPath().toLowerCase().endsWith(".jpeg") || imageFile.getPath().toLowerCase().endsWith(".png"))) {
            this.imageLocation = TextureHandler.getResource((String)imageFile.getPath());
            if (this.imageLocation != null) {
                this.imageLocation.loadTexture();
            }
        }
    }

    @Override
    public void onOpenMenu() {
    }

    @Override
    public void render(class_332 graphics, class_437 screen, boolean keepAspectRatio) {
        try {
            if (this.imageLocation != null && this.imageLocation.isReady()) {
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (!keepAspectRatio) {
                    graphics.method_25290(this.imageLocation.getResourceLocation(), 0, 0, 1.0f, 1.0f, screen.field_22789, screen.field_22790, screen.field_22789, screen.field_22790);
                } else {
                    int w = this.imageLocation.getWidth();
                    int h = this.imageLocation.getHeight();
                    double ratio = (double)w / (double)h;
                    int wfinal = (int)((double)screen.field_22790 * ratio);
                    int screenCenterX = screen.field_22789 / 2;
                    if (wfinal < screen.field_22789) {
                        graphics.method_25290(this.imageLocation.getResourceLocation(), 0, 0, 1.0f, 1.0f, screen.field_22789, screen.field_22790, screen.field_22789, screen.field_22790);
                    } else {
                        graphics.method_25290(this.imageLocation.getResourceLocation(), screenCenterX - wfinal / 2, 0, 1.0f, 1.0f, wfinal, screen.field_22790, wfinal, screen.field_22790);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

