/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollbar;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollbar.ScrollBar;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.events.SubscribeEvent;
import de.keksuccino.konkrete.events.client.ClientTickEvent;
import de.keksuccino.konkrete.events.client.GuiScreenEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrollBarHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean initialized = false;
    private static final List<ScrollBar> scrollBars = Collections.synchronizedList(new ArrayList());

    protected static void init() {
        if (!initialized) {
            Konkrete.getEventHandler().registerEventsFrom((Object)new ScrollBarHandler());
            initialized = true;
        }
    }

    public static void handleScrollBar(ScrollBar scrollBar) {
        ScrollBarHandler.init();
        if (scrollBar.active) {
            scrollBar.lastTick = System.currentTimeMillis();
            if (!scrollBars.contains(scrollBar)) {
                scrollBars.add(scrollBar);
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Post e) {
        ArrayList<ScrollBar> old = new ArrayList<ScrollBar>(scrollBars);
        for (ScrollBar b : old) {
            long now = System.currentTimeMillis();
            if (b.lastTick + 3000L >= now) continue;
            scrollBars.remove(b);
        }
    }

    @SubscribeEvent
    public void onMouseScrollPre(GuiScreenEvent.MouseScrollEvent.Pre e) {
        ArrayList<ScrollBar> bars = new ArrayList<ScrollBar>(scrollBars);
        for (ScrollBar b : bars) {
            b.handleWheelScrolling(e);
        }
    }
}

