/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.menuhandler;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.RenderUtils;
import de.keksuccino.fancymenu.api.background.MenuBackground;
import de.keksuccino.fancymenu.api.background.MenuBackgroundType;
import de.keksuccino.fancymenu.api.background.MenuBackgroundTypeRegistry;
import de.keksuccino.fancymenu.api.item.CustomizationItem;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import de.keksuccino.fancymenu.api.item.CustomizationItemRegistry;
import de.keksuccino.fancymenu.events.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.PlayWidgetClickSoundEvent;
import de.keksuccino.fancymenu.events.RenderListBackgroundEvent;
import de.keksuccino.fancymenu.events.RenderScreenEvent;
import de.keksuccino.fancymenu.events.RenderWidgetBackgroundEvent;
import de.keksuccino.fancymenu.events.ScreenBackgroundRenderedEvent;
import de.keksuccino.fancymenu.events.SoftMenuReloadEvent;
import de.keksuccino.fancymenu.mainwindow.WindowHandler;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.button.ButtonCache;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.button.ButtonData;
import de.keksuccino.fancymenu.menu.button.VanillaButtonDescriptionHandler;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomizationProperties;
import de.keksuccino.fancymenu.menu.fancy.gameintro.GameIntroHandler;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiBase;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiLoader;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.item.AnimationCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.ButtonCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.fancy.item.ShapeCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.SlideshowCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.SplashTextCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.StringCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.TextureCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.VanillaButtonCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.WebStringCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.WebTextureCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerRegistry;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.menu.panorama.ExternalTexturePanoramaRenderer;
import de.keksuccino.fancymenu.menu.panorama.PanoramaHandler;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderParser;
import de.keksuccino.fancymenu.menu.slideshow.ExternalTextureSlideshowRenderer;
import de.keksuccino.fancymenu.menu.slideshow.SlideshowHandler;
import de.keksuccino.fancymenu.screen.ScreenTitleHandler;
import de.keksuccino.konkrete.events.EventPriority;
import de.keksuccino.konkrete.events.SubscribeEvent;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.animation.ExternalGifAnimationRenderer;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.sound.SoundHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MenuHandlerBase {
    public List<CustomizationItemBase> frontRenderItems = new ArrayList<CustomizationItemBase>();
    public List<CustomizationItemBase> backgroundRenderItems = new ArrayList<CustomizationItemBase>();
    protected Map<String, Boolean> audio = new HashMap<String, Boolean>();
    protected IAnimationRenderer backgroundAnimation = null;
    protected IAnimationRenderer lastBackgroundAnimation = null;
    protected List<IAnimationRenderer> backgroundAnimations = new ArrayList<IAnimationRenderer>();
    protected int backgroundAnimationId = 0;
    protected ExternalTextureResourceLocation backgroundTexture = null;
    protected String identifier;
    protected boolean backgroundDrawable;
    protected boolean panoramaback = false;
    protected int panoTick = 0;
    protected double panoPos = 0.0;
    protected boolean panoMoveBack = false;
    protected boolean panoStop = false;
    protected boolean keepBackgroundAspectRatio = false;
    protected String customMenuTitle = null;
    protected boolean forceDisableCustomMenuTitle = false;
    protected ExternalTexturePanoramaRenderer panoramacube;
    protected ExternalTextureSlideshowRenderer slideshow;
    protected MenuBackground customMenuBackground = null;
    public float backgroundOpacity = 1.0f;
    protected List<ButtonData> hidden = new ArrayList<ButtonData>();
    protected Map<class_339, ButtonCustomizationContainer> vanillaButtonCustomizations = new HashMap<class_339, ButtonCustomizationContainer>();
    protected Map<class_339, LoadingRequirementContainer> vanillaButtonLoadingRequirementContainers = new HashMap<class_339, LoadingRequirementContainer>();
    protected Map<ButtonData, Float> delayAppearanceVanilla = new HashMap<ButtonData, Float>();
    protected Map<ButtonData, Float> fadeInVanilla = new HashMap<ButtonData, Float>();
    protected List<String> delayAppearanceFirstTime = new ArrayList<String>();
    protected List<Long> delayAppearanceFirstTimeVanilla = new ArrayList<Long>();
    protected List<ThreadCaller> delayThreads = new ArrayList<ThreadCaller>();
    protected boolean preinit = false;
    protected Map<String, RandomLayoutContainer> randomLayoutGroups = new HashMap<String, RandomLayoutContainer>();
    protected List<PropertiesSet> normalLayouts = new ArrayList<PropertiesSet>();
    protected SharedLayoutProperties sharedLayoutProps = new SharedLayoutProperties();
    protected String closeAudio;
    protected String openAudio;
    protected Map<LoadingRequirementContainer, Boolean> cachedLayoutWideLoadingRequirements = new HashMap<LoadingRequirementContainer, Boolean>();
    protected static class_437 scaleChangedIn = null;
    public static Map<Class, class_2561> cachedOriginalMenuTitles = new HashMap<Class, class_2561>();

    public MenuHandlerBase(@NotNull String identifier) {
        this.identifier = identifier;
    }

    public String getMenuIdentifier() {
        return this.identifier;
    }

    @SubscribeEvent
    public void onSoftReload(SoftMenuReloadEvent e) {
        if (this.shouldCustomize(e.screen)) {
            this.delayAppearanceFirstTimeVanilla.clear();
            this.delayAppearanceFirstTime.clear();
            this.delayAppearanceVanilla.clear();
            this.fadeInVanilla.clear();
            for (RandomLayoutContainer c : this.randomLayoutGroups.values()) {
                c.lastLayoutPath = null;
            }
            if (this.lastBackgroundAnimation != null) {
                this.lastBackgroundAnimation.resetAnimation();
            }
        }
    }

    @SubscribeEvent
    public void onMenuReloaded(MenuReloadedEvent e) {
        this.delayAppearanceFirstTimeVanilla.clear();
        this.delayAppearanceFirstTime.clear();
        this.delayAppearanceVanilla.clear();
        this.fadeInVanilla.clear();
        for (RandomLayoutContainer c : this.randomLayoutGroups.values()) {
            c.lastLayoutPath = null;
        }
        if (this.lastBackgroundAnimation != null) {
            this.lastBackgroundAnimation.resetAnimation();
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public void onInitPre(InitOrResizeScreenEvent.Pre e) {
        for (ThreadCaller t : this.delayThreads) {
            t.running.set(false);
        }
        this.delayThreads.clear();
        int mcscale = class_310.method_1551().method_22683().method_4476(((Integer)class_310.method_1551().field_1690.method_42474().method_41753()).intValue(), class_310.method_1551().method_1573());
        if (e.getScreen() != class_310.method_1551().field_1755) {
            return;
        }
        if (scaleChangedIn != null && scaleChangedIn != e.getScreen()) {
            scaleChangedIn = null;
            class_1041 m2 = class_310.method_1551().method_22683();
            m2.method_15997((double)mcscale);
            e.getScreen().field_22789 = m2.method_4486();
            e.getScreen().field_22790 = m2.method_4502();
        }
        if (!MenuCustomization.isValidScreen(e.getScreen())) {
            return;
        }
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        if (!AnimationHandler.isReady()) {
            return;
        }
        if (!GameIntroHandler.introDisplayed) {
            return;
        }
        if (LayoutEditorScreen.isActive) {
            return;
        }
        if (ButtonCache.isCaching()) {
            return;
        }
        if (!MenuCustomization.isMenuCustomizable(e.getScreen())) {
            return;
        }
        this.preinit = true;
        List<PropertiesSet> rawLayouts = MenuCustomizationProperties.getPropertiesWithIdentifier(this.getMenuIdentifier());
        String defaultGroup = "-100397";
        this.normalLayouts.clear();
        for (RandomLayoutContainer randomLayoutContainer : this.randomLayoutGroups.values()) {
            randomLayoutContainer.onlyFirstTime = false;
            randomLayoutContainer.clearLayouts();
        }
        this.sharedLayoutProps = new SharedLayoutProperties();
        this.customMenuTitle = null;
        this.cachedLayoutWideLoadingRequirements.clear();
        for (PropertiesSet propertiesSet : rawLayouts) {
            String randomMode;
            String smallerthanheight;
            String smallerthanwidth;
            String biggerthanheight;
            String biggerthanwidth;
            String cusMenuTitle;
            void var7_17;
            List list = propertiesSet.getPropertiesOfType("customization-meta");
            if (list.isEmpty()) {
                List list2 = propertiesSet.getPropertiesOfType("type-meta");
            }
            if (var7_17.isEmpty()) continue;
            LoadingRequirementContainer layoutWideRequirementContainer = LoadingRequirementContainer.deserializeRequirementContainer((PropertiesSection)var7_17.get(0));
            this.cachedLayoutWideLoadingRequirements.put(layoutWideRequirementContainer, layoutWideRequirementContainer.requirementsMet());
            if (!layoutWideRequirementContainer.requirementsMet()) continue;
            if (!this.forceDisableCustomMenuTitle && (cusMenuTitle = ((PropertiesSection)var7_17.get(0)).getEntryValue("custom_menu_title")) != null) {
                this.customMenuTitle = cusMenuTitle;
                ScreenTitleHandler.setScreenTitle(e.getScreen(), (class_2561)class_2561.method_43470((String)PlaceholderParser.replacePlaceholders(cusMenuTitle)));
            }
            if ((biggerthanwidth = ((PropertiesSection)var7_17.get(0)).getEntryValue("biggerthanwidth")) != null && MathUtils.isInteger((String)(biggerthanwidth = biggerthanwidth.replace(" ", "")))) {
                int i = Integer.parseInt(biggerthanwidth);
                if (WindowHandler.getWindowGuiWidth() < i) continue;
            }
            if ((biggerthanheight = ((PropertiesSection)var7_17.get(0)).getEntryValue("biggerthanheight")) != null && MathUtils.isInteger((String)(biggerthanheight = biggerthanheight.replace(" ", "")))) {
                int i = Integer.parseInt(biggerthanheight);
                if (WindowHandler.getWindowGuiHeight() < i) continue;
            }
            if ((smallerthanwidth = ((PropertiesSection)var7_17.get(0)).getEntryValue("smallerthanwidth")) != null && MathUtils.isInteger((String)(smallerthanwidth = smallerthanwidth.replace(" ", "")))) {
                int i = Integer.parseInt(smallerthanwidth);
                if (WindowHandler.getWindowGuiWidth() > i) continue;
            }
            if ((smallerthanheight = ((PropertiesSection)var7_17.get(0)).getEntryValue("smallerthanheight")) != null && MathUtils.isInteger((String)(smallerthanheight = smallerthanheight.replace(" ", "")))) {
                int i = Integer.parseInt(smallerthanheight);
                if (WindowHandler.getWindowGuiHeight() > i) continue;
            }
            if ((randomMode = ((PropertiesSection)var7_17.get(0)).getEntryValue("randommode")) != null && randomMode.equalsIgnoreCase("true")) {
                RandomLayoutContainer c;
                String group = ((PropertiesSection)var7_17.get(0)).getEntryValue("randomgroup");
                if (group == null) {
                    group = defaultGroup;
                }
                if (!this.randomLayoutGroups.containsKey(group)) {
                    this.randomLayoutGroups.put(group, new RandomLayoutContainer(group, this));
                }
                if ((c = this.randomLayoutGroups.get(group)) == null) continue;
                String randomOnlyFirstTime = ((PropertiesSection)var7_17.get(0)).getEntryValue("randomonlyfirsttime");
                if (randomOnlyFirstTime != null && randomOnlyFirstTime.equalsIgnoreCase("true")) {
                    c.setOnlyFirstTime(true);
                }
                c.addLayout(propertiesSet);
                continue;
            }
            this.normalLayouts.add(propertiesSet);
        }
        ArrayList<String> trashLayoutGroups = new ArrayList<String>();
        for (Map.Entry<String, RandomLayoutContainer> entry : this.randomLayoutGroups.entrySet()) {
            if (!entry.getValue().getLayouts().isEmpty()) continue;
            trashLayoutGroups.add(entry.getKey());
        }
        for (String string : trashLayoutGroups) {
            this.randomLayoutGroups.remove(string);
        }
        for (PropertiesSet propertiesSet : this.normalLayouts) {
            for (Object sec : propertiesSet.getPropertiesOfType("customization")) {
                this.applyLayoutPre((PropertiesSection)sec, e);
            }
        }
        for (RandomLayoutContainer randomLayoutContainer : this.randomLayoutGroups.values()) {
            PropertiesSet s = randomLayoutContainer.getRandomLayout();
            if (s == null) continue;
            for (PropertiesSection sec : s.getPropertiesOfType("customization")) {
                this.applyLayoutPre(sec, e);
            }
        }
        if (!this.sharedLayoutProps.scaled && scaleChangedIn != null) {
            scaleChangedIn = null;
            class_1041 class_10412 = class_310.method_1551().method_22683();
            class_10412.method_15997((double)mcscale);
            e.getScreen().field_22789 = class_10412.method_4486();
            e.getScreen().field_22790 = class_10412.method_4502();
        }
        if (this.sharedLayoutProps.autoScaleBaseWidth != 0 && this.sharedLayoutProps.autoScaleBaseHeight != 0) {
            class_1041 class_10413 = class_310.method_1551().method_22683();
            double d = (double)e.getScreen().field_22789 * class_10413.method_4495();
            double guiHeight = (double)e.getScreen().field_22790 * class_10413.method_4495();
            double percentX = d / (double)this.sharedLayoutProps.autoScaleBaseWidth * 100.0;
            double percentY = guiHeight / (double)this.sharedLayoutProps.autoScaleBaseHeight * 100.0;
            double newScaleX = percentX / 100.0 * class_10413.method_4495();
            double newScaleY = percentY / 100.0 * class_10413.method_4495();
            double newScale = Math.min(newScaleX, newScaleY);
            class_10413.method_15997(newScale);
            e.getScreen().field_22789 = class_10413.method_4486();
            e.getScreen().field_22790 = class_10413.method_4502();
            this.sharedLayoutProps.scaled = true;
            scaleChangedIn = e.getScreen();
        }
    }

    protected void applyLayoutPre(PropertiesSection sec, InitOrResizeScreenEvent.Pre e) {
        String action = sec.getEntryValue("action");
        if (action != null) {
            String scale;
            String identifier = sec.getEntryValue("identifier");
            if (action.equalsIgnoreCase("overridemenu") && identifier != null && CustomGuiLoader.guiExists(identifier)) {
                CustomGuiBase cus = CustomGuiLoader.getGui(identifier, null, e.getScreen(), onClose -> e.getScreen().method_25432());
                class_310.method_1551().method_1507((class_437)cus);
            }
            if (action.contentEquals("setscale") && (scale = sec.getEntryValue("scale")) != null && (MathUtils.isInteger((String)scale.replace(" ", "")) || MathUtils.isDouble((String)scale.replace(" ", "")))) {
                scaleChangedIn = e.getScreen();
                int newscale = (int)Double.parseDouble(scale.replace(" ", ""));
                if (newscale <= 0) {
                    newscale = 1;
                }
                class_1041 m = class_310.method_1551().method_22683();
                m.method_15997((double)newscale);
                e.getScreen().field_22789 = m.method_4486();
                e.getScreen().field_22790 = m.method_4502();
                this.sharedLayoutProps.scaled = true;
            }
            if (action.equalsIgnoreCase("autoscale")) {
                String baseHeight;
                String baseWidth = sec.getEntryValue("basewidth");
                if (MathUtils.isInteger((String)baseWidth)) {
                    this.sharedLayoutProps.autoScaleBaseWidth = Integer.parseInt(baseWidth);
                }
                if (MathUtils.isInteger((String)(baseHeight = sec.getEntryValue("baseheight")))) {
                    this.sharedLayoutProps.autoScaleBaseHeight = Integer.parseInt(baseHeight);
                }
            }
        }
    }

    @SubscribeEvent
    public void onButtonsCached(ButtonCachedEvent e) {
        if (e.getGui() != class_310.method_1551().field_1755) {
            return;
        }
        if (!MenuCustomization.isValidScreen(e.getGui())) {
            return;
        }
        if (!this.shouldCustomize(e.getGui())) {
            return;
        }
        if (!AnimationHandler.isReady()) {
            return;
        }
        if (!GameIntroHandler.introDisplayed) {
            return;
        }
        if (LayoutEditorScreen.isActive) {
            return;
        }
        if (ButtonCache.isCaching()) {
            return;
        }
        if (!MenuCustomization.isMenuCustomizable(e.getGui())) {
            return;
        }
        this.hidden.clear();
        this.delayAppearanceVanilla.clear();
        this.fadeInVanilla.clear();
        this.vanillaButtonCustomizations.clear();
        this.vanillaButtonLoadingRequirementContainers.clear();
        this.audio.clear();
        this.frontRenderItems.clear();
        this.backgroundRenderItems.clear();
        this.panoramacube = null;
        this.slideshow = null;
        this.customMenuBackground = null;
        this.backgroundOpacity = 1.0f;
        this.backgroundAnimation = null;
        this.backgroundAnimations.clear();
        if (this.backgroundAnimation != null && this.backgroundAnimation instanceof AdvancedAnimation) {
            ((AdvancedAnimation)this.backgroundAnimation).stopAudio();
        }
        this.backgroundDrawable = false;
        for (PropertiesSet propertiesSet : this.normalLayouts) {
            List metas = propertiesSet.getPropertiesOfType("customization-meta");
            if (metas.isEmpty()) {
                metas = propertiesSet.getPropertiesOfType("type-meta");
            }
            String renderOrder = ((PropertiesSection)metas.get(0)).getEntryValue("renderorder");
            for (Object sec : propertiesSet.getPropertiesOfType("customization")) {
                this.applyLayout((PropertiesSection)sec, renderOrder, e);
            }
        }
        for (RandomLayoutContainer randomLayoutContainer : this.randomLayoutGroups.values()) {
            PropertiesSet s = randomLayoutContainer.getRandomLayout();
            if (s == null) continue;
            Object metas = s.getPropertiesOfType("customization-meta");
            if (metas.isEmpty()) {
                metas = s.getPropertiesOfType("type-meta");
            }
            String renderOrder = ((PropertiesSection)metas.get(0)).getEntryValue("renderorder");
            for (PropertiesSection sec : s.getPropertiesOfType("customization")) {
                this.applyLayout(sec, renderOrder, e);
            }
        }
        MenuHandlerRegistry.setActiveHandler(this.getMenuIdentifier());
        for (Map.Entry entry : this.sharedLayoutProps.descriptions.entrySet()) {
            class_339 w = ((ButtonData)entry.getKey()).getButton();
            if (w == null) continue;
            VanillaButtonDescriptionHandler.setDescriptionFor(w, (String)entry.getValue());
        }
        for (String string : MenuCustomization.getSounds()) {
            if (this.audio.containsKey(string) || string.equals(this.openAudio) || string.equals(this.closeAudio)) continue;
            SoundHandler.stopSound((String)string);
            SoundHandler.resetSound((String)string);
        }
        if (!this.sharedLayoutProps.closeAudioSet && this.closeAudio != null) {
            MenuCustomization.unregisterSound(this.closeAudio);
            this.closeAudio = null;
        }
        if (!this.sharedLayoutProps.openAudioSet && this.openAudio != null) {
            MenuCustomization.unregisterSound(this.openAudio);
            this.openAudio = null;
        }
        for (Map.Entry entry : this.audio.entrySet()) {
            SoundHandler.playSound((String)((String)entry.getKey()));
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            SoundHandler.setLooped((String)((String)entry.getKey()), (boolean)true);
        }
        if (!this.sharedLayoutProps.backgroundTextureSet) {
            this.backgroundTexture = null;
        }
        for (ButtonData buttonData : this.hidden) {
            buttonData.getButton().field_22764 = false;
        }
        for (CustomizationItemBase customizationItemBase : this.frontRenderItems) {
            if (MenuCustomization.isNewMenu()) {
                this.handleAppearanceDelayFor(customizationItemBase);
            }
            if (!customizationItemBase.orientation.equals("element") || customizationItemBase.orientationElementIdentifier == null) continue;
            customizationItemBase.orientationElement = this.getItemByActionId(customizationItemBase.orientationElementIdentifier);
        }
        for (CustomizationItemBase customizationItemBase : this.backgroundRenderItems) {
            if (MenuCustomization.isNewMenu()) {
                this.handleAppearanceDelayFor(customizationItemBase);
            }
            if (!customizationItemBase.orientation.equals("element") || customizationItemBase.orientationElementIdentifier == null) continue;
            customizationItemBase.orientationElement = this.getItemByActionId(customizationItemBase.orientationElementIdentifier);
        }
        for (Map.Entry entry : this.vanillaButtonLoadingRequirementContainers.entrySet()) {
            boolean isBtnHidden = false;
            for (ButtonData d : this.hidden) {
                if (d.getButton() != entry.getKey()) continue;
                isBtnHidden = true;
                break;
            }
            if (isBtnHidden) continue;
            PropertiesSection dummySec = new PropertiesSection("customization");
            dummySec.addEntry("action", "vanilla_button_visibility_requirements");
            ButtonData btn = null;
            for (ButtonData d : ButtonCache.getButtons()) {
                if (d.getButton() != entry.getKey()) continue;
                btn = d;
                break;
            }
            if (btn == null) continue;
            VanillaButtonCustomizationItem i = new VanillaButtonCustomizationItem(dummySec, btn, this);
            i.loadingRequirements = (LoadingRequirementContainer)entry.getValue();
            this.backgroundRenderItems.add(i);
        }
        for (Map.Entry entry : this.delayAppearanceVanilla.entrySet()) {
            if (this.hidden.contains(entry.getKey()) || !this.vanillaButtonLoadingRequirementsMet(((ButtonData)entry.getKey()).getButton())) continue;
            this.handleVanillaAppearanceDelayFor((ButtonData)entry.getKey());
        }
        ButtonCache.clearCustomButtonCache();
        for (CustomizationItemBase customizationItemBase : this.backgroundRenderItems) {
            if (!(customizationItemBase instanceof ButtonCustomizationItem)) continue;
            ButtonCache.cacheCustomButton(customizationItemBase.getActionId(), (class_339)((ButtonCustomizationItem)customizationItemBase).button);
        }
        for (CustomizationItemBase customizationItemBase : this.frontRenderItems) {
            if (!(customizationItemBase instanceof ButtonCustomizationItem)) continue;
            ButtonCache.cacheCustomButton(customizationItemBase.getActionId(), (class_339)((ButtonCustomizationItem)customizationItemBase).button);
        }
    }

    protected void applyLayout(PropertiesSection sec, String renderOrder, ButtonCachedEvent e) {
        String action = sec.getEntryValue("action");
        if (action != null) {
            String cusId;
            CustomizationItemContainer cusItem;
            String desc;
            String clicks;
            Object path;
            Object value;
            String name;
            String keepAspect;
            String identifier = sec.getEntryValue("identifier");
            class_339 b = null;
            ButtonData bd = null;
            if (identifier != null && (bd = MenuHandlerBase.getButton(identifier)) != null) {
                b = bd.getButton();
            }
            if (action.equalsIgnoreCase("backgroundoptions") && (keepAspect = sec.getEntryValue("keepaspectratio")) != null && keepAspect.equalsIgnoreCase("true")) {
                this.keepBackgroundAspectRatio = true;
            }
            if (action.equalsIgnoreCase("setbackgroundslideshow") && (name = sec.getEntryValue("name")) != null && SlideshowHandler.slideshowExists(name)) {
                this.slideshow = SlideshowHandler.getSlideshow(name);
            }
            if (action.equalsIgnoreCase("setbackgroundpanorama") && (name = sec.getEntryValue("name")) != null && PanoramaHandler.panoramaExists(name)) {
                this.panoramacube = PanoramaHandler.getPanorama(name);
            }
            if (action.equalsIgnoreCase("texturizebackground")) {
                value = CustomizationItemBase.fixBackslashPath(sec.getEntryValue("path"));
                String pano = sec.getEntryValue("wideformat");
                if (pano == null) {
                    pano = sec.getEntryValue("panorama");
                }
                if (value != null) {
                    File f = new File(((String)value).replace("\\", "/"));
                    if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/"))) {
                        value = class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/") + "/" + ((String)value).replace("\\", "/");
                        f = new File((String)value);
                    }
                    if (f.exists() && f.isFile() && (f.getName().toLowerCase().endsWith(".jpg") || f.getName().toLowerCase().endsWith(".jpeg") || f.getName().toLowerCase().endsWith(".png"))) {
                        if (this.backgroundTexture == null || !this.backgroundTexture.getPath().equals(value)) {
                            this.backgroundTexture = TextureHandler.getResource((String)value);
                        }
                        this.panoramaback = pano != null && pano.equalsIgnoreCase("true");
                        this.sharedLayoutProps.backgroundTextureSet = true;
                    }
                }
            }
            if (action.equalsIgnoreCase("animatebackground")) {
                value = sec.getEntryValue("name");
                String random = sec.getEntryValue("random");
                boolean ran = false;
                if (random != null && random.equalsIgnoreCase("true")) {
                    ran = true;
                }
                boolean restartOnLoad = false;
                String restartOnLoadString = sec.getEntryValue("restart_on_load");
                if (restartOnLoadString != null && restartOnLoadString.equalsIgnoreCase("true")) {
                    restartOnLoad = true;
                }
                if (value != null) {
                    if (((String)value).contains(",")) {
                        for (String s2 : ((String)value).split("[,]")) {
                            int i = 0;
                            for (char c : s2.toCharArray()) {
                                if (c != " ".charAt(0)) break;
                                ++i;
                            }
                            if (i > s2.length()) continue;
                            String temp = new StringBuilder(s2.substring(i)).reverse().toString();
                            int i2 = 0;
                            for (char c : temp.toCharArray()) {
                                if (c != " ".charAt(0)) break;
                                ++i2;
                            }
                            String name2 = new StringBuilder(temp.substring(i2)).reverse().toString();
                            if (!AnimationHandler.animationExists(name2)) continue;
                            this.backgroundAnimations.add(AnimationHandler.getAnimation(name2));
                        }
                    } else if (AnimationHandler.animationExists((String)value)) {
                        this.backgroundAnimations.add(AnimationHandler.getAnimation((String)value));
                    }
                    if (!this.backgroundAnimations.isEmpty()) {
                        if (restartOnLoad && MenuCustomization.isNewMenu()) {
                            for (IAnimationRenderer r : this.backgroundAnimations) {
                                r.resetAnimation();
                            }
                        }
                        if (ran) {
                            if (MenuCustomization.isNewMenu()) {
                                this.backgroundAnimationId = MathUtils.getRandomNumberInRange((int)0, (int)(this.backgroundAnimations.size() - 1));
                            }
                            this.backgroundAnimation = this.backgroundAnimations.get(this.backgroundAnimationId);
                        } else {
                            if (this.lastBackgroundAnimation != null && this.backgroundAnimations.contains(this.lastBackgroundAnimation)) {
                                this.backgroundAnimation = this.lastBackgroundAnimation;
                            } else {
                                this.backgroundAnimationId = 0;
                                this.backgroundAnimation = this.backgroundAnimations.get(0);
                            }
                            this.lastBackgroundAnimation = this.backgroundAnimation;
                        }
                    }
                }
            }
            if (action.equalsIgnoreCase("api:custombackground")) {
                MenuBackgroundType type;
                String typeId = sec.getEntryValue("type_identifier");
                String backId = sec.getEntryValue("background_identifier");
                String inputString = sec.getEntryValue("input_string");
                if (typeId != null && (type = MenuBackgroundTypeRegistry.getBackgroundTypeByIdentifier(typeId)) != null) {
                    if (type.needsInputString() && inputString != null) {
                        try {
                            this.customMenuBackground = type.createInstanceFromInputString(inputString);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (this.customMenuBackground != null && MenuCustomization.isNewMenu()) {
                            this.customMenuBackground.onOpenMenu();
                        }
                    } else if (backId != null) {
                        this.customMenuBackground = type.getBackgroundByIdentifier(backId);
                        if (this.customMenuBackground != null && MenuCustomization.isNewMenu()) {
                            this.customMenuBackground.onOpenMenu();
                        }
                    }
                }
            }
            if (action.equalsIgnoreCase("hidebuttonfor")) {
                String time = sec.getEntryValue("seconds");
                String onlyfirsttime = sec.getEntryValue("onlyfirsttime");
                String fadein = sec.getEntryValue("fadein");
                String fadeinspeed = sec.getEntryValue("fadeinspeed");
                if (b != null && MenuCustomization.isNewMenu()) {
                    boolean ft = false;
                    if (onlyfirsttime != null && onlyfirsttime.equalsIgnoreCase("true")) {
                        ft = true;
                    }
                    if (!(time == null || !MathUtils.isFloat((String)time) || ft && this.delayAppearanceFirstTimeVanilla.contains(bd.getId()))) {
                        this.delayAppearanceVanilla.put(bd, Float.valueOf(Float.parseFloat(time)));
                    }
                    if (ft && !this.delayAppearanceFirstTimeVanilla.contains(bd.getId())) {
                        this.delayAppearanceFirstTimeVanilla.add(bd.getId());
                    }
                    if (fadein != null && fadein.equalsIgnoreCase("true")) {
                        float speed = 1.0f;
                        if (fadeinspeed != null && MathUtils.isFloat((String)fadeinspeed)) {
                            speed = Float.parseFloat(fadeinspeed);
                        }
                        this.fadeInVanilla.put(bd, Float.valueOf(speed));
                    }
                }
            }
            if (action.equalsIgnoreCase("hidebutton") && b != null) {
                this.hidden.add(bd);
            }
            if ((action.equalsIgnoreCase("renamebutton") || action.equalsIgnoreCase("setbuttonlabel")) && b != null) {
                this.backgroundRenderItems.add(new VanillaButtonCustomizationItem(sec, bd, this));
            }
            if (action.equalsIgnoreCase("resizebutton") && b != null) {
                this.backgroundRenderItems.add(new VanillaButtonCustomizationItem(sec, bd, this));
            }
            if (action.equalsIgnoreCase("movebutton") && b != null) {
                this.backgroundRenderItems.add(new VanillaButtonCustomizationItem(sec, bd, this));
            }
            if (action.equalsIgnoreCase("setbuttontexture") && b != null) {
                String restartBackAnimationsOnHover;
                String loopBackAnimations = sec.getEntryValue("loopbackgroundanimations");
                if (loopBackAnimations != null && loopBackAnimations.equalsIgnoreCase("false")) {
                    this.getContainerForVanillaButton((class_339)b).loopAnimation = false;
                }
                if ((restartBackAnimationsOnHover = sec.getEntryValue("restartbackgroundanimations")) != null && restartBackAnimationsOnHover.equalsIgnoreCase("false")) {
                    this.getContainerForVanillaButton((class_339)b).restartAnimationOnHover = false;
                }
                String backNormal = CustomizationItemBase.fixBackslashPath(sec.getEntryValue("backgroundnormal"));
                String backHover = CustomizationItemBase.fixBackslashPath(sec.getEntryValue("backgroundhovered"));
                if (backNormal != null) {
                    this.getContainerForVanillaButton((class_339)b).normalBackground = backNormal;
                } else {
                    String backAniNormal = sec.getEntryValue("backgroundanimationnormal");
                    if (backAniNormal != null) {
                        this.getContainerForVanillaButton((class_339)b).normalBackground = "animation:" + backAniNormal;
                    }
                }
                if (backHover != null) {
                    this.getContainerForVanillaButton((class_339)b).hoverBackground = backHover;
                } else {
                    String backAniHover = sec.getEntryValue("backgroundanimationhovered");
                    if (backAniHover != null) {
                        this.getContainerForVanillaButton((class_339)b).hoverBackground = "animation:" + backAniHover;
                    }
                }
            }
            if (action.equalsIgnoreCase("setbuttonclicksound") && b != null && (path = CustomizationItemBase.fixBackslashPath(sec.getEntryValue("path"))) != null) {
                this.getContainerForVanillaButton((class_339)b).clickSound = path;
            }
            if (action.equalsIgnoreCase("vanilla_button_visibility_requirements") && b != null) {
                this.vanillaButtonLoadingRequirementContainers.put(b, LoadingRequirementContainer.deserializeRequirementContainer(sec));
            }
            if (action.equalsIgnoreCase("addhoversound") && b != null) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new VanillaButtonCustomizationItem(sec, bd, this));
                } else {
                    this.frontRenderItems.add(new VanillaButtonCustomizationItem(sec, bd, this));
                }
            }
            if (action.equalsIgnoreCase("sethoverlabel") && b != null) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new VanillaButtonCustomizationItem(sec, bd, this));
                } else {
                    this.frontRenderItems.add(new VanillaButtonCustomizationItem(sec, bd, this));
                }
            }
            if (action.equalsIgnoreCase("clickbutton") && b != null && (clicks = sec.getEntryValue("clicks")) != null && MathUtils.isInteger((String)clicks)) {
                for (int i = 0; i < Integer.parseInt(clicks); ++i) {
                    b.method_25348((double)MouseInput.getMouseX(), (double)MouseInput.getMouseY());
                }
            }
            if (action.equalsIgnoreCase("addtext")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new StringCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new StringCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addwebtext")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new WebStringCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new WebStringCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addtexture")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new TextureCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new TextureCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addwebtexture")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new WebTextureCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new WebTextureCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addanimation")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new AnimationCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new AnimationCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addshape")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new ShapeCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new ShapeCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addslideshow")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new SlideshowCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new SlideshowCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addbutton")) {
                ButtonCustomizationItem i = new ButtonCustomizationItem(sec);
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(i);
                } else {
                    this.frontRenderItems.add(i);
                }
            }
            if (action.equalsIgnoreCase("addaudio") && ((Boolean)FancyMenu.config.getOrDefault("playbackgroundsounds", (Object)true)).booleanValue() && (class_310.method_1551().field_1687 == null || ((Boolean)FancyMenu.config.getOrDefault("playbackgroundsoundsinworld", (Object)false)).booleanValue())) {
                path = CustomizationItemBase.fixBackslashPath(sec.getEntryValue("path"));
                String loopString = sec.getEntryValue("loop");
                boolean loop = false;
                if (loopString != null && loopString.equalsIgnoreCase("true")) {
                    loop = true;
                }
                if (path != null) {
                    File f = new File((String)path);
                    if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/"))) {
                        path = class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/") + "/" + (String)path;
                        f = new File((String)path);
                    }
                    if (f.isFile() && f.exists() && f.getName().endsWith(".wav")) {
                        try {
                            String name3 = (String)path + Files.size(f.toPath());
                            MenuCustomization.registerSound(name3, (String)path);
                            this.audio.put(name3, loop);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            if (action.equalsIgnoreCase("setcloseaudio") && (path = CustomizationItemBase.fixBackslashPath(sec.getEntryValue("path"))) != null) {
                File f = new File((String)path);
                if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/"))) {
                    path = class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/") + "/" + (String)path;
                    f = new File((String)path);
                }
                if (f.isFile() && f.exists() && f.getName().endsWith(".wav")) {
                    try {
                        String name4 = "closesound_" + (String)path + Files.size(f.toPath());
                        MenuCustomization.registerSound(name4, (String)path);
                        this.closeAudio = name4;
                        this.sharedLayoutProps.closeAudioSet = true;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (action.equalsIgnoreCase("setopenaudio") && MenuCustomization.isNewMenu() && (path = CustomizationItemBase.fixBackslashPath(sec.getEntryValue("path"))) != null) {
                File f = new File((String)path);
                if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/"))) {
                    path = class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/") + "/" + (String)path;
                    f = new File((String)path);
                }
                if (f.isFile() && f.exists() && f.getName().endsWith(".wav")) {
                    try {
                        String name5 = "opensound_" + (String)path + Files.size(f.toPath());
                        MenuCustomization.registerSound(name5, (String)path);
                        SoundHandler.resetSound((String)name5);
                        SoundHandler.playSound((String)name5);
                        this.openAudio = name5;
                        this.sharedLayoutProps.openAudioSet = true;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (action.equalsIgnoreCase("setbuttondescription") && b != null && (desc = sec.getEntryValue("description")) != null) {
                this.sharedLayoutProps.descriptions.put(bd, PlaceholderParser.replacePlaceholders(desc));
            }
            if (action.equalsIgnoreCase("addsplash")) {
                String file = CustomizationItemBase.fixBackslashPath(sec.getEntryValue("splashfilepath"));
                String text = sec.getEntryValue("text");
                if (file != null || text != null) {
                    SplashTextCustomizationItem i = new SplashTextCustomizationItem(sec);
                    if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                        this.backgroundRenderItems.add(i);
                    } else {
                        this.frontRenderItems.add(i);
                    }
                }
            }
            if (action.startsWith("custom_layout_element:") && (cusItem = CustomizationItemRegistry.getItem(cusId = action.split("[:]", 2)[1])) != null) {
                CustomizationItem cusItemInstance = cusItem.constructCustomizedItemInstance(sec);
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(cusItemInstance);
                } else {
                    this.frontRenderItems.add(cusItemInstance);
                }
            }
        }
    }

    protected void handleAppearanceDelayFor(final CustomizationItemBase i) {
        if (!(i instanceof VanillaButtonCustomizationItem) && i.delayAppearance) {
            if (i.getActionId() == null) {
                return;
            }
            if (!i.delayAppearanceEverytime && this.delayAppearanceFirstTime.contains(i.getActionId())) {
                return;
            }
            if (!i.delayAppearanceEverytime && !this.delayAppearanceFirstTime.contains(i.getActionId())) {
                this.delayAppearanceFirstTime.add(i.getActionId());
            }
            i.visible = false;
            if (i.fadeIn) {
                i.opacity = 0.1f;
            }
            final ThreadCaller c = new ThreadCaller();
            this.delayThreads.add(c);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    long start = System.currentTimeMillis();
                    float delay = (float)(1000.0 * (double)i.delayAppearanceSec);
                    boolean fade = false;
                    while (c.running.get()) {
                        try {
                            long now = System.currentTimeMillis();
                            if (!fade) {
                                if (now >= start + (long)((int)delay)) {
                                    i.visible = true;
                                    if (!i.fadeIn) {
                                        return;
                                    }
                                    fade = true;
                                }
                            } else {
                                float o = i.opacity + 0.03f * i.fadeInSpeed;
                                if (o > 1.0f) {
                                    o = 1.0f;
                                }
                                if (i.opacity < 1.0f) {
                                    i.opacity = o;
                                } else {
                                    return;
                                }
                            }
                            Thread.sleep(50L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            t.start();
        }
    }

    protected void handleVanillaAppearanceDelayFor(final ButtonData d) {
        if (this.delayAppearanceVanilla.containsKey(d)) {
            final boolean fadein = this.fadeInVanilla.containsKey(d);
            final float delaysec = this.delayAppearanceVanilla.get(d).floatValue();
            final LoadingRequirementContainer reqs = this.vanillaButtonLoadingRequirementContainers.get(d.getButton());
            d.getButton().field_22764 = false;
            if (reqs != null) {
                reqs.forceRequirementsNotMet = true;
            }
            if (fadein) {
                d.getButton().method_25350(0.1f);
            }
            final ThreadCaller c = new ThreadCaller();
            this.delayThreads.add(c);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    float fadespeed = 1.0f;
                    if (fadein && MenuHandlerBase.this.fadeInVanilla.containsKey(d)) {
                        fadespeed = MenuHandlerBase.this.fadeInVanilla.get(d).floatValue();
                    }
                    float opacity = 0.1f;
                    long start = System.currentTimeMillis();
                    float delay = (float)(1000.0 * (double)delaysec);
                    boolean fade = false;
                    while (c.running.get()) {
                        try {
                            long now = System.currentTimeMillis();
                            if (!fade) {
                                if (now >= start + (long)((int)delay)) {
                                    d.getButton().field_22764 = true;
                                    if (reqs != null) {
                                        reqs.forceRequirementsNotMet = false;
                                    }
                                    if (!fadein) {
                                        return;
                                    }
                                    fade = true;
                                }
                            } else {
                                float o = opacity + 0.03f * fadespeed;
                                if (o > 1.0f) {
                                    o = 1.0f;
                                }
                                if (opacity < 1.0f) {
                                    opacity = o;
                                    d.getButton().method_25350(opacity);
                                } else {
                                    return;
                                }
                            }
                            Thread.sleep(50L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            t.start();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderPre(RenderScreenEvent.Pre e) {
        if (PopupHandler.isPopupActive()) {
            return;
        }
        if (!this.shouldCustomize(e.getGui())) {
            return;
        }
        if (!MenuCustomization.isMenuCustomizable(e.getGui())) {
            return;
        }
        for (Map.Entry<LoadingRequirementContainer, Boolean> m : this.cachedLayoutWideLoadingRequirements.entrySet()) {
            if (m.getKey().requirementsMet() == m.getValue().booleanValue()) continue;
            MenuCustomization.reInitCurrentScreen();
            break;
        }
    }

    @SubscribeEvent
    public void onRenderPost(RenderScreenEvent.Post e) {
        if (PopupHandler.isPopupActive()) {
            return;
        }
        if (!this.shouldCustomize(e.getGui())) {
            return;
        }
        if (!MenuCustomization.isMenuCustomizable(e.getGui())) {
            return;
        }
        if (this.customMenuTitle != null && !this.forceDisableCustomMenuTitle) {
            ScreenTitleHandler.setScreenTitle(e.getGui(), (class_2561)class_2561.method_43470((String)PlaceholderParser.replacePlaceholders(this.customMenuTitle)));
        }
        if (!this.backgroundDrawable) {
            ArrayList<CustomizationItemBase> backItems = new ArrayList<CustomizationItemBase>();
            backItems.addAll(this.backgroundRenderItems);
            for (CustomizationItemBase i : backItems) {
                try {
                    i.render(e.getGuiGraphics(), e.getGui());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        ArrayList<CustomizationItemBase> frontItems = new ArrayList<CustomizationItemBase>();
        frontItems.addAll(this.frontRenderItems);
        for (CustomizationItemBase i : frontItems) {
            try {
                i.render(e.getGuiGraphics(), e.getGui());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void drawToBackground(ScreenBackgroundRenderedEvent e) {
        if (!MenuCustomization.isCurrentMenuScrollable()) {
            this.renderBackground(e.getGuiGraphics(), e.getScreen());
        }
    }

    protected void renderBackground(class_332 graphics, class_437 s) {
        if (this.shouldCustomize(s)) {
            if (!MenuCustomization.isMenuCustomizable(s)) {
                return;
            }
            if (this.canRenderBackground()) {
                if (this.backgroundAnimation != null && this.backgroundAnimation.isReady()) {
                    boolean b = this.backgroundAnimation.isStretchedToStreensize();
                    int wOri = this.backgroundAnimation.getWidth();
                    int hOri = this.backgroundAnimation.getHeight();
                    int xOri = this.backgroundAnimation.getPosX();
                    int yOri = this.backgroundAnimation.getPosY();
                    if (!this.keepBackgroundAspectRatio) {
                        this.backgroundAnimation.setStretchImageToScreensize(true);
                    } else {
                        ratio = (double)wOri / (double)hOri;
                        wfinal = (int)((double)s.field_22790 * ratio);
                        screenCenterX = s.field_22789 / 2;
                        if (wfinal < s.field_22789) {
                            this.backgroundAnimation.setStretchImageToScreensize(true);
                        } else {
                            this.backgroundAnimation.setWidth(wfinal + 1);
                            this.backgroundAnimation.setHeight(s.field_22790 + 1);
                            this.backgroundAnimation.setPosX(screenCenterX - wfinal / 2);
                            this.backgroundAnimation.setPosY(0);
                        }
                    }
                    this.backgroundAnimation.setOpacity(this.backgroundOpacity);
                    this.backgroundAnimation.render(graphics);
                    this.backgroundAnimation.setWidth(wOri);
                    this.backgroundAnimation.setHeight(hOri);
                    this.backgroundAnimation.setPosX(xOri);
                    this.backgroundAnimation.setPosY(yOri);
                    this.backgroundAnimation.setStretchImageToScreensize(b);
                    this.backgroundAnimation.setOpacity(1.0f);
                } else if (this.backgroundTexture != null) {
                    RenderSystem.enableBlend();
                    graphics.method_51422(1.0f, 1.0f, 1.0f, this.backgroundOpacity);
                    if (!this.panoramaback) {
                        if (!this.keepBackgroundAspectRatio) {
                            graphics.method_25290(this.backgroundTexture.getResourceLocation(), 0, 0, 1.0f, 1.0f, s.field_22789 + 1, s.field_22790 + 1, s.field_22789 + 1, s.field_22790 + 1);
                        } else {
                            w = this.backgroundTexture.getWidth();
                            h = this.backgroundTexture.getHeight();
                            ratio = (double)w / (double)h;
                            wfinal = (int)((double)s.field_22790 * ratio);
                            int screenCenterX = s.field_22789 / 2;
                            if (wfinal < s.field_22789) {
                                graphics.method_25290(this.backgroundTexture.getResourceLocation(), 0, 0, 1.0f, 1.0f, s.field_22789 + 1, s.field_22790 + 1, s.field_22789 + 1, s.field_22790 + 1);
                            } else {
                                graphics.method_25290(this.backgroundTexture.getResourceLocation(), screenCenterX - wfinal / 2, 0, 1.0f, 1.0f, wfinal + 1, s.field_22790 + 1, wfinal + 1, s.field_22790 + 1);
                            }
                        }
                    } else {
                        w = this.backgroundTexture.getWidth();
                        ratio = (double)w / (double)(h = this.backgroundTexture.getHeight());
                        wfinal = (int)((double)s.field_22790 * ratio);
                        if (this.panoPos + (double)(wfinal - s.field_22789) <= 0.0) {
                            this.panoMoveBack = true;
                        }
                        if (this.panoPos >= 0.0) {
                            this.panoMoveBack = false;
                        }
                        if (this.panoPos + (double)(wfinal - s.field_22789) < 0.0) {
                            this.panoPos = 0 - (wfinal - s.field_22789);
                        }
                        if (this.panoPos > 0.0) {
                            this.panoPos = 0.0;
                        }
                        if (!this.panoStop) {
                            if (this.panoTick >= 1) {
                                this.panoTick = 0;
                                this.panoPos = this.panoMoveBack ? (this.panoPos += 0.5) : (this.panoPos -= 0.5);
                                if (this.panoPos + (double)(wfinal - s.field_22789) == 0.0) {
                                    this.panoStop = true;
                                }
                                if (this.panoPos == 0.0) {
                                    this.panoStop = true;
                                }
                            } else {
                                ++this.panoTick;
                            }
                        } else if (this.panoTick >= 300) {
                            this.panoStop = false;
                            this.panoTick = 0;
                        } else {
                            ++this.panoTick;
                        }
                        if (wfinal <= s.field_22789) {
                            graphics.method_25290(this.backgroundTexture.getResourceLocation(), 0, 0, 1.0f, 1.0f, s.field_22789 + 1, s.field_22790 + 1, s.field_22789 + 1, s.field_22790 + 1);
                        } else {
                            RenderSystem.enableBlend();
                            graphics.method_51422(1.0f, 1.0f, 1.0f, this.backgroundOpacity);
                            RenderUtils.doubleBlit(graphics, this.backgroundTexture.getResourceLocation(), this.panoPos, 0.0, 1.0f, 1.0f, wfinal, s.field_22790 + 1);
                        }
                    }
                    RenderSystem.disableBlend();
                    graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                } else if (this.panoramacube != null) {
                    float opacity = this.panoramacube.opacity;
                    this.panoramacube.opacity = this.backgroundOpacity;
                    this.panoramacube.render(graphics);
                    this.panoramacube.opacity = opacity;
                } else if (this.slideshow != null) {
                    int sw = this.slideshow.width;
                    int sh = this.slideshow.height;
                    int sx = this.slideshow.x;
                    int sy = this.slideshow.y;
                    float opacity = this.slideshow.slideshowOpacity;
                    if (!this.keepBackgroundAspectRatio) {
                        this.slideshow.width = s.field_22789 + 1;
                        this.slideshow.height = s.field_22790 + 1;
                        this.slideshow.x = 0;
                    } else {
                        ratio = (double)sw / (double)sh;
                        wfinal = (int)((double)s.field_22790 * ratio);
                        screenCenterX = s.field_22789 / 2;
                        if (wfinal < s.field_22789) {
                            this.slideshow.width = s.field_22789 + 1;
                            this.slideshow.height = s.field_22790 + 1;
                            this.slideshow.x = 0;
                        } else {
                            this.slideshow.width = wfinal + 1;
                            this.slideshow.height = s.field_22790 + 1;
                            this.slideshow.x = screenCenterX - wfinal / 2;
                        }
                    }
                    this.slideshow.y = 0;
                    this.slideshow.slideshowOpacity = this.backgroundOpacity;
                    this.slideshow.render(graphics);
                    this.slideshow.width = sw;
                    this.slideshow.height = sh;
                    this.slideshow.x = sx;
                    this.slideshow.y = sy;
                    this.slideshow.slideshowOpacity = opacity;
                } else if (this.customMenuBackground != null) {
                    this.customMenuBackground.opacity = this.backgroundOpacity;
                    this.customMenuBackground.render(graphics, s, this.keepBackgroundAspectRatio);
                    this.customMenuBackground.opacity = 1.0f;
                }
            }
            if (PopupHandler.isPopupActive()) {
                return;
            }
            ArrayList<CustomizationItemBase> backItems = new ArrayList<CustomizationItemBase>();
            backItems.addAll(this.backgroundRenderItems);
            for (CustomizationItemBase i : backItems) {
                try {
                    i.render(graphics, s);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            this.backgroundDrawable = true;
        }
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @SubscribeEvent
    public void onButtonClickSound(PlayWidgetClickSoundEvent.Pre e) {
        ButtonCustomizationContainer c;
        if (this.shouldCustomize(class_310.method_1551().field_1755) && MenuCustomization.isMenuCustomizable(class_310.method_1551().field_1755) && (c = this.vanillaButtonCustomizations.get(e.getWidget())) != null && c.clickSound != null) {
            File f = new File(c.clickSound);
            if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/"))) {
                c.clickSound = class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/") + "/" + c.clickSound;
                f = new File(c.clickSound);
            }
            if (f.exists() && f.isFile() && f.getPath().toLowerCase().endsWith(".wav")) {
                SoundHandler.registerSound((String)f.getPath(), (String)f.getPath());
                SoundHandler.resetSound((String)f.getPath());
                SoundHandler.playSound((String)f.getPath());
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onButtonRenderBackground(RenderWidgetBackgroundEvent.Pre e) {
        class_339 w;
        ButtonCustomizationContainer c;
        if (this.shouldCustomize(class_310.method_1551().field_1755) && MenuCustomization.isMenuCustomizable(class_310.method_1551().field_1755) && (c = this.vanillaButtonCustomizations.get(w = e.getWidget())) != null) {
            String normalBack = c.normalBackground;
            String hoverBack = c.hoverBackground;
            boolean hasCustomBackground = false;
            boolean restart = false;
            if (c.lastHoverState != w.method_25367() && w.method_25367() && c.restartAnimationOnHover) {
                restart = true;
            }
            c.lastHoverState = w.method_25367();
            if (!w.method_25367() && normalBack != null && this.renderCustomButtomBackground(e, normalBack, restart)) {
                hasCustomBackground = true;
            }
            if (w.method_25367()) {
                if (w.field_22763) {
                    if (hoverBack != null && this.renderCustomButtomBackground(e, hoverBack, restart)) {
                        hasCustomBackground = true;
                    }
                } else if (normalBack != null && this.renderCustomButtomBackground(e, normalBack, restart)) {
                    hasCustomBackground = true;
                }
            }
            if (hasCustomBackground) {
                class_2561 msg;
                if (w instanceof class_344 && (msg = w.method_25369()) != null) {
                    int j = w.field_22763 ? 0xFFFFFF : 0xA0A0A0;
                    e.getGuiGraphics().method_27534(class_310.method_1551().field_1772, msg, w.field_22760 + w.method_25368() / 2, w.field_22761 + (w.method_25364() - 8) / 2, j | class_3532.method_15386((float)(e.getAlpha() * 255.0f)) << 24);
                }
                e.setCanceled(true);
            }
        }
    }

    protected boolean renderCustomButtomBackground(RenderWidgetBackgroundEvent e, String background, boolean restartAnimationBackground) {
        class_339 w = e.getWidget();
        class_332 graphics = e.getGuiGraphics();
        ButtonCustomizationContainer c = this.vanillaButtonCustomizations.get(w);
        if (c != null && w != null && background != null) {
            if (((String)background).startsWith("animation:")) {
                String aniName = ((String)background).split("[:]", 2)[1];
                if (AnimationHandler.animationExists(aniName)) {
                    IAnimationRenderer a = AnimationHandler.getAnimation(aniName);
                    if (restartAnimationBackground) {
                        a.resetAnimation();
                    }
                    this.renderBackgroundAnimation(e, a);
                    if (!c.cachedAnimations.contains(a)) {
                        c.cachedAnimations.add(a);
                    }
                    return true;
                }
            } else {
                File f = new File((String)background);
                if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/"))) {
                    background = class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/") + "/" + (String)background;
                    f = new File((String)background);
                }
                if (f.isFile()) {
                    ExternalTextureResourceLocation back;
                    if (f.getPath().toLowerCase().endsWith(".gif")) {
                        ExternalGifAnimationRenderer a = TextureHandler.getGifResource((String)f.getPath());
                        if (restartAnimationBackground) {
                            a.resetAnimation();
                        }
                        this.renderBackgroundAnimation(e, (IAnimationRenderer)a);
                        if (!c.cachedAnimations.contains(a)) {
                            c.cachedAnimations.add((IAnimationRenderer)a);
                        }
                        return true;
                    }
                    if ((f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png")) && (back = TextureHandler.getResource((String)f.getPath())) != null) {
                        RenderSystem.enableBlend();
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)e.getAlpha());
                        e.getGuiGraphics().method_25290(back.getResourceLocation(), w.field_22760, w.field_22761, 0.0f, 0.0f, w.method_25368(), w.method_25364(), w.method_25368(), w.method_25364());
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected void renderBackgroundAnimation(RenderWidgetBackgroundEvent e, IAnimationRenderer ani) {
        class_339 w = e.getWidget();
        ButtonCustomizationContainer c = this.vanillaButtonCustomizations.get(w);
        if (c != null && ani != null) {
            if (!ani.isReady()) {
                ani.prepareAnimation();
            }
            int aniX = ani.getPosX();
            int aniY = ani.getPosY();
            int aniWidth = ani.getWidth();
            int aniHeight = ani.getHeight();
            boolean aniLoop = ani.isGettingLooped();
            ani.setPosX(w.field_22760);
            ani.setPosY(w.field_22761);
            ani.setWidth(w.method_25368());
            ani.setHeight(w.method_25364());
            ani.setLooped(c.loopAnimation);
            ani.setOpacity(e.getAlpha());
            if (ani instanceof AdvancedAnimation) {
                ((AdvancedAnimation)ani).setMuteAudio(true);
            }
            ani.render(e.getGuiGraphics());
            ani.setPosX(aniX);
            ani.setPosY(aniY);
            ani.setWidth(aniWidth);
            ani.setHeight(aniHeight);
            ani.setLooped(aniLoop);
            ani.setOpacity(1.0f);
            if (ani instanceof AdvancedAnimation) {
                ((AdvancedAnimation)ani).setMuteAudio(false);
            }
        }
    }

    protected ButtonCustomizationContainer getContainerForVanillaButton(class_339 w) {
        if (!this.vanillaButtonCustomizations.containsKey(w)) {
            ButtonCustomizationContainer c = new ButtonCustomizationContainer();
            this.vanillaButtonCustomizations.put(w, c);
            return c;
        }
        return this.vanillaButtonCustomizations.get(w);
    }

    public CustomizationItemBase getItemByActionId(String actionId) {
        String idRaw;
        ButtonData d;
        String id;
        for (CustomizationItemBase c : this.backgroundRenderItems) {
            if (!(c instanceof VanillaButtonCustomizationItem ? (id = "vanillabtn:" + ((VanillaButtonCustomizationItem)c).getButtonId()).equals(actionId) : c.getActionId().equals(actionId))) continue;
            return c;
        }
        for (CustomizationItemBase c : this.frontRenderItems) {
            if (!(c instanceof VanillaButtonCustomizationItem ? (id = "vanillabtn:" + ((VanillaButtonCustomizationItem)c).getButtonId()).equals(actionId) : c.getActionId().equals(actionId))) continue;
            return c;
        }
        if (actionId.startsWith("vanillabtn:") && (d = MathUtils.isLong((String)(idRaw = actionId.split("[:]", 2)[1])) ? ButtonCache.getButtonForId(Long.parseLong(idRaw)) : ButtonCache.getButtonForCompatibilityId(idRaw)) != null && d.getButton() != null) {
            VanillaButtonCustomizationItem vb = new VanillaButtonCustomizationItem(new PropertiesSection("customization"), d, this);
            vb.orientation = "top-left";
            vb.posX = d.getButton().field_22760;
            vb.posY = d.getButton().field_22761;
            vb.width = d.getButton().method_25368();
            vb.height = d.getButton().method_25364();
            return vb;
        }
        return null;
    }

    protected boolean vanillaButtonLoadingRequirementsMet(class_339 b) {
        LoadingRequirementContainer c = this.vanillaButtonLoadingRequirementContainers.get(b);
        if (c != null) {
            return c.requirementsMet();
        }
        return true;
    }

    @SubscribeEvent
    public void onRenderListBackground(RenderListBackgroundEvent.Post e) {
        class_437 current = class_310.method_1551().field_1755;
        if (current != null && this.shouldCustomize(current) && MenuCustomization.isMenuCustomizable(current)) {
            this.renderBackground(e.getGuiGraphics(), current);
        }
    }

    private static ButtonData getButton(String identifier) {
        if (identifier.startsWith("%id=")) {
            String p = identifier.split("[=]")[1].replace("%", "");
            if (MathUtils.isLong((String)p)) {
                return ButtonCache.getButtonForId(Long.parseLong(p));
            }
            if (p.startsWith("button_compatibility_id:")) {
                return ButtonCache.getButtonForCompatibilityId(p);
            }
        } else {
            ButtonData b = class_1074.method_4663((String)identifier) ? ButtonCache.getButtonForKey(identifier) : ButtonCache.getButtonForName(identifier);
            return b;
        }
        return null;
    }

    protected boolean shouldCustomize(class_437 menu) {
        if (menu == null) {
            return false;
        }
        return this.getMenuIdentifier() == null || this.getMenuIdentifier().equals(menu.getClass().getName());
    }

    public boolean canRenderBackground() {
        return this.backgroundAnimation != null || this.backgroundTexture != null || this.panoramacube != null || this.slideshow != null || this.customMenuBackground != null;
    }

    public boolean setBackgroundAnimation(int id) {
        if (id < this.backgroundAnimations.size()) {
            this.backgroundAnimationId = id;
            this.lastBackgroundAnimation = this.backgroundAnimation = this.backgroundAnimations.get(id);
            return true;
        }
        return false;
    }

    public int getCurrentBackgroundAnimationId() {
        return this.backgroundAnimationId;
    }

    public List<IAnimationRenderer> backgroundAnimations() {
        return this.backgroundAnimations;
    }

    public boolean isVanillaButtonHidden(class_339 w) {
        for (ButtonData d : this.hidden) {
            if (d.getButton() != w) continue;
            return true;
        }
        return false;
    }

    public static class SharedLayoutProperties {
        public boolean scaled = false;
        public int autoScaleBaseWidth = 0;
        public int autoScaleBaseHeight = 0;
        public boolean backgroundTextureSet = false;
        public boolean openAudioSet = false;
        public boolean closeAudioSet = false;
        public Map<ButtonData, String> descriptions = new HashMap<ButtonData, String>();
    }

    public static class RandomLayoutContainer {
        public final String id;
        protected List<PropertiesSet> layouts = new ArrayList<PropertiesSet>();
        protected boolean onlyFirstTime = false;
        protected String lastLayoutPath = null;
        public MenuHandlerBase parent;

        public RandomLayoutContainer(String id, MenuHandlerBase parent) {
            this.id = id;
            this.parent = parent;
        }

        public List<PropertiesSet> getLayouts() {
            return this.layouts;
        }

        public void addLayout(PropertiesSet layout) {
            this.layouts.add(layout);
        }

        public void addLayouts(List<PropertiesSet> layouts) {
            this.layouts.addAll(layouts);
        }

        public void clearLayouts() {
            this.layouts.clear();
        }

        public void setOnlyFirstTime(boolean b) {
            this.onlyFirstTime = b;
        }

        public boolean isOnlyFirstTime() {
            return this.onlyFirstTime;
        }

        public void resetLastLayout() {
            this.lastLayoutPath = null;
        }

        @Nullable
        public PropertiesSet getRandomLayout() {
            if (!this.layouts.isEmpty()) {
                String path;
                int i;
                PropertiesSet s;
                List metas;
                if ((this.onlyFirstTime || !MenuCustomization.isNewMenu()) && this.lastLayoutPath != null) {
                    File f = new File(this.lastLayoutPath);
                    if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/"))) {
                        this.lastLayoutPath = class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/") + "/" + this.lastLayoutPath;
                        f = new File(this.lastLayoutPath);
                    }
                    if (f.exists()) {
                        for (PropertiesSet s2 : this.layouts) {
                            String path2;
                            List metas2 = s2.getPropertiesOfType("customization-meta");
                            if (metas2.isEmpty()) {
                                metas2 = s2.getPropertiesOfType("type-meta");
                            }
                            if (metas2.isEmpty() || (path2 = ((PropertiesSection)metas2.get(0)).getEntryValue("path")) == null || !path2.equals(this.lastLayoutPath)) continue;
                            return s2;
                        }
                    } else {
                        MenuCustomization.stopSounds();
                        MenuCustomization.resetSounds();
                        AnimationHandler.resetAnimations();
                        AnimationHandler.resetAnimationSounds();
                        AnimationHandler.stopAnimationSounds();
                    }
                }
                if ((metas = (s = this.layouts.get(i = MathUtils.getRandomNumberInRange((int)0, (int)(this.layouts.size() - 1)))).getPropertiesOfType("customization-meta")).isEmpty()) {
                    metas = s.getPropertiesOfType("type-meta");
                }
                if (!metas.isEmpty() && (path = ((PropertiesSection)metas.get(0)).getEntryValue("path")) != null) {
                    this.lastLayoutPath = path;
                    return s;
                }
            }
            return null;
        }
    }

    private static class ThreadCaller {
        AtomicBoolean running = new AtomicBoolean(true);

        private ThreadCaller() {
        }
    }

    public static class ButtonCustomizationContainer {
        public String normalBackground = null;
        public String hoverBackground = null;
        public boolean loopAnimation = true;
        public boolean restartAnimationOnHover = true;
        public String clickSound = null;
        public String hoverSound = null;
        public String hoverLabel = null;
        public int autoButtonClicks = 0;
        public String customButtonLabel = null;
        public String buttonDescription = null;
        public boolean isButtonHidden = false;
        public LoadingRequirementContainer loadingRequirementContainer = null;
        public List<IAnimationRenderer> cachedAnimations = new ArrayList<IAnimationRenderer>();
        public boolean lastHoverState = false;
    }
}

