/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.loadingrequirement.v2.requirements;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.LoadingRequirement;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;

public class IsModLoadedRequirement
extends LoadingRequirement {
    public IsModLoadedRequirement() {
        super("fancymenu_loading_requirement_is_mod_loaded");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        List<String> l;
        if (value != null && !(l = this.parseStrings(value)).isEmpty()) {
            for (String s : l) {
                if (!(s.equalsIgnoreCase("optifine") ? !Konkrete.isOptifineLoaded : !FabricLoader.getInstance().isModLoaded(s))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<String> parseStrings(String value) {
        ArrayList<String> l = new ArrayList<String>();
        if (value != null) {
            if (value.contains(",")) {
                for (String s : value.replace(" ", "").split("[,]")) {
                    l.add(s);
                }
            } else {
                l.add(value.replace(" ", ""));
            }
        }
        return l;
    }

    @Override
    public String getDisplayName() {
        return Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.modloaded", (String[])new String[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.modloaded.desc", (String[])new String[0]), (String)"%n%"));
    }

    @Override
    public String getCategory() {
        return null;
    }

    @Override
    public String getValueDisplayName() {
        return Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.modloaded.valuename", (String[])new String[0]);
    }

    @Override
    public String getValuePreset() {
        return "optifine";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }
}

