/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.v3.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1041;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class RenderingUtils {
    public static float getPartialTick() {
        return class_310.method_1551().method_1488();
    }

    public static boolean isXYInArea(int targetX, int targetY, int x, int y, int width, int height) {
        return RenderingUtils.isXYInArea((double)targetX, (double)targetY, (double)x, (double)y, (double)width, (double)height);
    }

    public static boolean isXYInArea(double targetX, double targetY, double x, double y, double width, double height) {
        return targetX >= x && targetX < x + width && targetY >= y && targetY < y + height;
    }

    public static void resetGuiScale() {
        class_1041 m = class_310.method_1551().method_22683();
        m.method_15997((double)m.method_4476(((Integer)class_310.method_1551().field_1690.method_42474().method_41753()).intValue(), ((Boolean)class_310.method_1551().field_1690.method_42437().method_41753()).booleanValue()));
    }

    public static void resetShaderColor() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void bindTexture(@NotNull class_2960 texture, boolean depthTest) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.enableBlend();
        if (depthTest) {
            RenderSystem.enableDepthTest();
        }
    }

    public static void bindTexture(@NotNull class_2960 texture) {
        RenderingUtils.bindTexture(texture, false);
    }

    public static int replaceAlphaInColor(int color, int newAlpha) {
        newAlpha = Math.min(newAlpha, 255);
        return color & 0xFFFFFF | newAlpha << 24;
    }

    public static int replaceAlphaInColor(int color, float newAlpha) {
        return RenderingUtils.replaceAlphaInColor(color, (int)(newAlpha * 255.0f));
    }

    public static void fillF(@NotNull class_4587 pose, float minX, float minY, float maxX, float maxY, int color) {
        RenderingUtils.fillF(pose, minX, minY, maxX, maxY, 0.0f, color);
    }

    public static void fillF(@NotNull class_4587 pose, float minX, float minY, float maxX, float maxY, float z, int color) {
        Matrix4f matrix4f = pose.method_23760().method_23761();
        if (minX < maxX) {
            float $$8 = minX;
            minX = maxX;
            maxX = $$8;
        }
        if (minY < maxY) {
            float $$9 = minY;
            minY = maxY;
            maxY = $$9;
        }
        float red = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float green = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float blue = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        float alpha = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix4f, minX, minY, z).method_22915(red, green, blue, alpha).method_1344();
        bufferBuilder.method_22918(matrix4f, minX, maxY, z).method_22915(red, green, blue, alpha).method_1344();
        bufferBuilder.method_22918(matrix4f, maxX, maxY, z).method_22915(red, green, blue, alpha).method_1344();
        bufferBuilder.method_22918(matrix4f, maxX, minY, z).method_22915(red, green, blue, alpha).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.disableBlend();
    }

    public static void blitF(@NotNull class_4587 pose, float x, float y, float f3, float f4, float width, float height, float width2, float height2) {
        RenderingUtils.blit(pose, x, y, width, height, f3, f4, width, height, width2, height2);
    }

    private static void blit(class_4587 $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10) {
        RenderingUtils.blit($$0, $$1, $$1 + $$3, $$2, $$2 + $$4, 0.0f, $$7, $$8, $$5, $$6, $$9, $$10);
    }

    private static void blit(class_4587 $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
        RenderingUtils.innerBlit($$0.method_23760().method_23761(), $$1, $$2, $$3, $$4, $$5, ($$8 + 0.0f) / $$10, ($$8 + $$6) / $$10, ($$9 + 0.0f) / $$11, ($$9 + $$7) / $$11);
    }

    private static void innerBlit(Matrix4f $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9) {
        RenderSystem.setShader(class_757::method_34542);
        class_287 $$10 = class_289.method_1348().method_1349();
        $$10.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        $$10.method_22918($$0, $$1, $$3, $$5).method_22913($$6, $$8).method_1344();
        $$10.method_22918($$0, $$1, $$4, $$5).method_22913($$6, $$9).method_1344();
        $$10.method_22918($$0, $$2, $$4, $$5).method_22913($$7, $$9).method_1344();
        $$10.method_22918($$0, $$2, $$3, $$5).method_22913($$7, $$8).method_1344();
        class_286.method_43433((class_287.class_7433)$$10.method_1326());
    }
}

