/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.chess;

import dev.emi.emi.chess.ChessBoard;
import dev.emi.emi.chess.ChessPiece;
import dev.emi.emi.chess.PieceColor;
import dev.emi.emi.chess.PieceType;

class ChessEvaluation {
    public static final int[][] PREFERENCES = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 50, 50, 50, 50, 50, 50, 50, 50, 10, 10, 20, 30, 30, 20, 10, 10, 5, 5, 10, 25, 25, 10, 5, 5, 0, 0, 0, 20, 20, 0, 0, 0, 5, -5, -10, 0, 0, -10, -5, 5, 5, 10, 10, -20, -20, 10, 10, 5, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 5, 10, 10, 10, 10, 10, 10, 5, -5, 0, 0, 0, 0, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -5, 0, 0, 0, 5, 5, 0, 0, 0}, {-50, -40, -30, -30, -30, -30, -40, -50, -40, -20, 0, 0, 0, 0, -20, -40, -30, 0, 10, 15, 15, 10, 0, -30, -30, 5, 15, 20, 20, 15, 5, -30, -30, 0, 15, 20, 20, 15, 0, -30, -30, 5, 10, 15, 15, 10, 5, -30, -40, -20, 0, 5, 5, 0, -20, -40, -50, -40, -30, -30, -30, -30, -40, -50}, {-20, -10, -10, -10, -10, -10, -10, -20, -10, 0, 0, 0, 0, 0, 0, -10, -10, 0, 5, 10, 10, 5, 0, -10, -10, 5, 5, 10, 10, 5, 5, -10, -10, 0, 10, 10, 10, 10, 0, -10, -10, 10, 10, 10, 10, 10, 10, -10, -10, 5, 0, 0, 0, 0, 5, -10, -20, -10, -10, -10, -10, -10, -10, -20}, {-20, -10, -10, -5, -5, -10, -10, -20, -10, 0, 0, 0, 0, 0, 0, -10, -10, 0, 5, 5, 5, 5, 0, -10, -5, 0, 5, 5, 5, 5, 0, -5, 0, 0, 5, 5, 5, 5, 0, -5, -10, 5, 5, 5, 5, 5, 0, -10, -10, 0, 5, 0, 0, 0, 0, -10, -20, -10, -10, -5, -5, -10, -10, -20}, {-30, -40, -40, -50, -50, -40, -40, -30, -30, -40, -40, -50, -50, -40, -40, -30, -30, -40, -40, -50, -50, -40, -40, -30, -30, -40, -40, -50, -50, -40, -40, -30, -20, -30, -30, -40, -40, -30, -30, -20, -10, -20, -20, -20, -20, -20, -20, -10, 20, 20, 0, 0, 0, 0, 20, 20, 20, 30, 10, 0, 0, 10, 30, 20}};

    ChessEvaluation() {
    }

    public int evaluate(ChessBoard board) {
        int score = 0;
        for (int i = 0; i < 64; ++i) {
            ChessPiece piece = board.get(i);
            if (piece == null) continue;
            int mod = piece.color() == PieceColor.WHITE ? 1 : -1;
            score += mod * 15;
            score += mod * (switch (piece.type()) {
                default -> throw new IncompatibleClassChangeError();
                case PieceType.PAWN -> 100;
                case PieceType.ROOK -> 500;
                case PieceType.KNIGHT -> 300;
                case PieceType.BISHOP -> 300;
                case PieceType.QUEEN -> 900;
                case PieceType.KING -> 69000;
            });
            int loc = i;
            if (piece.color() == PieceColor.BLACK) {
                loc = 63 - loc & 0x38 | loc & 7;
            }
            score += mod * PREFERENCES[piece.type().ordinal()][loc];
        }
        return score;
    }
}

