/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.jemi;

import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.RecipeFillButtonWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.jemi.JemiRecipe;
import dev.emi.emi.jemi.JemiUtil;
import dev.emi.emi.jemi.impl.JemiRecipeLayoutBuilder;
import dev.emi.emi.jemi.impl.JemiRecipeSlot;
import dev.emi.emi.jemi.impl.JemiRecipeSlotsView;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;

public class JemiRecipeHandler<T extends class_1703, R>
implements EmiRecipeHandler<T> {
    private final RecipeType<R> type;
    public IRecipeTransferHandler<T, R> handler;

    public JemiRecipeHandler(IRecipeTransferHandler<T, R> handler) {
        this.handler = handler;
        this.type = handler.getRecipeType();
    }

    @Override
    public boolean alwaysDisplaySupport(EmiRecipe recipe) {
        return this.type != null;
    }

    @Override
    public EmiPlayerInventory getInventory(class_465<T> screen) {
        return new EmiPlayerInventory(List.of());
    }

    @Override
    public boolean supportsRecipe(EmiRecipe recipe) {
        return (this.type == null || this.getRawRecipe(recipe) != null) && recipe.supportsRecipeTree();
    }

    @Override
    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<T> context) {
        IRecipeTransferError err = this.jeiCraft(recipe, context, false);
        return err == null || err.getType().allowsTransfer;
    }

    @Override
    public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        IRecipeTransferError err = this.jeiCraft(recipe, context, true);
        if (err == null || err.getType().allowsTransfer) {
            class_310.method_1551().method_1507(context.getScreen());
        }
        return err == null || err.getType().allowsTransfer;
    }

    @Override
    public void render(EmiRecipe recipe, EmiCraftContext<T> context, List<Widget> widgets, class_332 raw) {
        EmiDrawContext draw = EmiDrawContext.wrap(raw);
        IRecipeTransferError err = this.jeiCraft(recipe, context, false);
        if (err != null && err.getType() == IRecipeTransferError.Type.COSMETIC) {
            for (Widget widget : widgets) {
                if (!(widget instanceof RecipeFillButtonWidget)) continue;
                Bounds b = widget.getBounds();
                draw.fill(b.left(), b.top(), b.width(), b.height(), err.getButtonHighlightColor());
            }
        }
    }

    private IRecipeTransferError jeiCraft(EmiRecipe recipe, EmiCraftContext<T> context, boolean craft) {
        try {
            class_310 client = class_310.method_1551();
            R rawRecipe = this.getRawRecipe(recipe);
            JemiRecipeSlotsView view = this.createSlotsView(recipe, rawRecipe);
            if (view == null) {
                return () -> IRecipeTransferError.Type.INTERNAL;
            }
            return this.handler.transferRecipe(context.getScreenHandler(), rawRecipe != null ? rawRecipe : recipe, (IRecipeSlotsView)view, (class_1657)client.field_1724, context.getAmount() > 1, craft);
        }
        catch (Exception e) {
            e.printStackTrace();
            return () -> IRecipeTransferError.Type.INTERNAL;
        }
    }

    private JemiRecipeSlotsView createSlotsView(EmiRecipe recipe, R rawRecipe) {
        JemiRecipeLayoutBuilder builder = null;
        if (rawRecipe == null && this.type != null) {
            return null;
        }
        if (builder == null) {
            builder = new JemiRecipeLayoutBuilder();
            this.addIngredients(builder, recipe.getOutputs(), RecipeIngredientRole.OUTPUT);
            this.addIngredients(builder, recipe.getInputs(), RecipeIngredientRole.INPUT);
            if (recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING) {
                for (int i = recipe.getInputs().size(); i < 9; ++i) {
                    this.addIngredients(builder, List.of(EmiStack.EMPTY), RecipeIngredientRole.INPUT);
                }
            }
            this.addIngredients(builder, recipe.getCatalysts(), RecipeIngredientRole.CATALYST);
        }
        return new JemiRecipeSlotsView(builder.slots.stream().map(JemiRecipeSlot::new).toList());
    }

    private R getRawRecipe(EmiRecipe recipe) {
        try {
            Optional opt;
            class_310 client = class_310.method_1551();
            class_1863 manager = client.field_1687.method_8433();
            if (this.type != null && this.type.getRecipeClass() != null) {
                if (recipe instanceof JemiRecipe) {
                    JemiRecipe jr = (JemiRecipe)recipe;
                    if (jr.recipe != null && this.type.getRecipeClass().isAssignableFrom(jr.recipe.getClass())) {
                        return (R)this.type.getRecipeClass().cast(jr.recipe);
                    }
                }
                if (manager != null && (opt = manager.method_8130(recipe.getId())).isPresent()) {
                    class_1860 r = (class_1860)opt.get();
                    if (this.type.getRecipeClass().isAssignableFrom(r.getClass())) {
                        return (R)this.type.getRecipeClass().cast(r);
                    }
                }
            }
            if (manager != null && (opt = manager.method_8130(recipe.getId())).isPresent()) {
                return (R)opt.get();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void addIngredients(JemiRecipeLayoutBuilder builder, List<? extends EmiIngredient> stacks, RecipeIngredientRole role) {
        for (EmiIngredient emiIngredient : stacks) {
            IRecipeSlotBuilder acceptor = builder.addSlot(role, 0, 0);
            for (EmiStack stack : emiIngredient.getEmiStacks()) {
                Optional<ITypedIngredient<?>> opt = JemiUtil.getTyped(stack);
                if (!opt.isPresent()) continue;
                ITypedIngredient<?> typed = opt.get();
                acceptor.addIngredient(typed.getType(), typed.getIngredient());
            }
        }
    }
}

