/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.jemi;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.class_124;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5481;
import net.minecraft.class_5684;

public class JemiStack<T>
extends EmiStack {
    private final IIngredientType<T> type;
    private final IIngredientHelper<T> helper;
    public final Object base;
    public final T ingredient;
    public IIngredientRenderer<T> renderer;

    public JemiStack(IIngredientType<T> type, IIngredientHelper<T> helper, IIngredientRenderer<T> renderer, T ingredient) {
        this.type = type;
        this.helper = helper;
        this.renderer = renderer;
        this.ingredient = ingredient;
        if (type instanceof IIngredientTypeWithSubtypes) {
            IIngredientTypeWithSubtypes iitws = (IIngredientTypeWithSubtypes)type;
            this.base = iitws.getBase(ingredient);
        } else {
            this.base = helper.getUniqueId(ingredient, UidContext.Recipe);
        }
    }

    public String getJeiUid() {
        return this.helper.getUniqueId(this.ingredient, UidContext.Ingredient);
    }

    @Override
    public void render(class_332 raw, int x, int y, float delta, int flags) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        int xOff = (16 - this.renderer.getWidth()) / 2;
        int yOff = (16 - this.renderer.getHeight()) / 2;
        context.push();
        context.matrices().method_46416((float)(x + xOff), (float)(y + yOff), 0.0f);
        this.renderer.render(context.raw(), this.ingredient);
        context.pop();
    }

    @Override
    public JemiStack<T> copy() {
        return new JemiStack<Object>(this.type, this.helper, this.renderer, this.helper.copyIngredient(this.ingredient));
    }

    @Override
    public boolean isEmpty() {
        return !this.helper.isValidIngredient(this.ingredient);
    }

    @Override
    public class_2487 getNbt() {
        return null;
    }

    @Override
    public Object getKey() {
        return this.base;
    }

    @Override
    public class_2960 getId() {
        return this.helper.getResourceLocation(this.ingredient);
    }

    @Override
    public List<class_2561> getTooltipText() {
        return this.renderer.getTooltip(this.ingredient, (class_1836)class_1836.field_41070);
    }

    @Override
    public List<class_5684> getTooltip() {
        ArrayList list = Lists.newArrayList();
        class_310 client = class_310.method_1551();
        list.addAll(this.renderer.getTooltip(this.ingredient, (class_1836)(client.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070)).stream().map(EmiPort::ordered).map(class_5684::method_32662).toList());
        class_2960 id = this.getId();
        if (EmiConfig.appendModId && id != null) {
            String mod = EmiUtil.getModName(id.method_12836());
            list.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.literal(mod, class_124.field_1078, class_124.field_1056))));
        }
        list.addAll(super.getTooltip());
        return list;
    }

    @Override
    public class_2561 getName() {
        return EmiPort.literal(this.helper.getDisplayName(this.ingredient));
    }
}

