/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.runtime;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.HelpLevel;
import dev.emi.emi.registry.EmiRecipeFiller;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.StackBatcher;
import dev.emi.emi.screen.tooltip.RecipeTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;

public class EmiFavorite
implements EmiIngredient,
StackBatcher.Batchable {
    protected final EmiIngredient stack;
    @Nullable
    protected final EmiRecipe recipe;

    public EmiFavorite(EmiIngredient stack, @Nullable EmiRecipe recipe) {
        this.stack = stack;
        this.recipe = recipe;
    }

    public EmiIngredient getStack() {
        return this.stack;
    }

    @Override
    public EmiIngredient copy() {
        return new EmiFavorite(this.stack, this.recipe);
    }

    @Override
    public long getAmount() {
        return this.stack.getAmount();
    }

    @Override
    public EmiIngredient setAmount(long amount) {
        return this;
    }

    @Override
    public float getChance() {
        return 1.0f;
    }

    @Override
    public EmiIngredient setChance(float chance) {
        return this;
    }

    public EmiRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public List<EmiStack> getEmiStacks() {
        return this.stack.getEmiStacks();
    }

    @Override
    public void render(class_332 raw, int x, int y, float delta, int flags) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        if (this.recipe != null) {
            flags |= 2;
        }
        this.stack.render(context.raw(), x, y, delta, flags);
        if ((flags & 4) > 0 && this.recipe != null) {
            EmiRenderHelper.renderRecipeFavorite(this.stack, context, x, y);
        }
    }

    @Override
    public List<class_5684> getTooltip() {
        ArrayList list = Lists.newArrayList();
        list.addAll(this.stack.getTooltip());
        if (this.recipe != null) {
            list.add(new RecipeTooltipComponent(this.recipe, true));
        }
        return list;
    }

    public boolean strictEquals(EmiIngredient other) {
        List<EmiStack> as = this.getEmiStacks();
        List<EmiStack> bs = other.getEmiStacks();
        if (as.size() != bs.size()) {
            return false;
        }
        for (int i = 0; i < as.size(); ++i) {
            if (as.get(i).isEqual(bs.get(i), Comparison.compareNbt())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        EmiIngredient ingredient;
        return obj instanceof EmiIngredient && EmiIngredient.areEqual(this, ingredient = (EmiIngredient)obj);
    }

    @Override
    public boolean isSideLit() {
        StackBatcher.Batchable b;
        EmiIngredient emiIngredient = this.stack;
        return emiIngredient instanceof StackBatcher.Batchable && (b = (StackBatcher.Batchable)((Object)emiIngredient)).isSideLit();
    }

    @Override
    public boolean isUnbatchable() {
        StackBatcher.Batchable b;
        EmiIngredient emiIngredient = this.stack;
        return !(emiIngredient instanceof StackBatcher.Batchable) || (b = (StackBatcher.Batchable)((Object)emiIngredient)).isUnbatchable();
    }

    @Override
    public void setUnbatchable() {
        EmiIngredient emiIngredient = this.stack;
        if (emiIngredient instanceof StackBatcher.Batchable) {
            StackBatcher.Batchable b = (StackBatcher.Batchable)((Object)emiIngredient);
            b.setUnbatchable();
        }
    }

    @Override
    public void renderForBatch(class_4597 vcp, class_332 raw, int x, int y, int z, float delta) {
        EmiIngredient emiIngredient = this.stack;
        if (emiIngredient instanceof StackBatcher.Batchable) {
            StackBatcher.Batchable b = (StackBatcher.Batchable)((Object)emiIngredient);
            b.renderForBatch(vcp, raw, x, y, z, delta);
        }
    }

    public static class Synthetic
    extends EmiFavorite {
        public final long batches;
        public final long amount;
        public final int state;
        public long total;

        public Synthetic(EmiRecipe recipe, long batches, long amount, int state) {
            super(recipe.getOutputs().get(0), recipe);
            this.batches = batches;
            this.amount = amount;
            this.state = state;
        }

        public Synthetic(EmiIngredient ingredient, long needed, long total) {
            super(ingredient, null);
            this.batches = needed;
            this.amount = needed;
            this.total = total;
            this.state = -1;
        }

        @Override
        public void render(class_332 raw, int x, int y, float delta, int flags) {
            EmiDrawContext context = EmiDrawContext.wrap(raw);
            int color = 0xFF2200;
            if (this.state == 1) {
                color = 0xAA00FF;
            } else if (this.state == 2) {
                color = 56797;
            } else if (this.state == -1) {
                color = 15369258;
            }
            context.fill(x - 1, y - 1, 18, 18, 0x44000000 | color);
            this.stack.render(context.raw(), x, y, delta, flags & 0xFFFFFFFD);
            if (this.recipe != null) {
                EmiRenderHelper.renderAmount(context, x, y, (class_2561)EmiPort.literal("" + this.amount));
            } else {
                EmiRenderHelper.renderAmount(context, x, y, EmiRenderHelper.getAmountText(this.stack, this.amount));
            }
        }

        @Override
        public List<class_5684> getTooltip() {
            ArrayList list = Lists.newArrayList();
            list.addAll(super.getTooltip());
            if (this.state == -1) {
                return list;
            }
            class_2561 craftKey = null;
            if (EmiConfig.helpLevel.has(HelpLevel.NORMAL) && EmiRecipeFiller.getFirstValidHandler(this.recipe, EmiApi.getHandledScreen()) != null) {
                if (EmiConfig.craftAllToInventory.isBound()) {
                    craftKey = EmiConfig.craftAllToInventory.getBindText();
                } else if (EmiConfig.craftAll.isBound()) {
                    craftKey = EmiConfig.craftAll.getBindText();
                }
            }
            if (this.state == 0) {
                list.add(class_5684.method_32662((class_5481)EmiPort.translatable("tooltip.emi.synfav.uncraftable").method_30937()));
            } else if (this.state == 1) {
                list.add(class_5684.method_32662((class_5481)EmiPort.translatable("tooltip.emi.synfav.partially_craftable").method_30937()));
                if (craftKey != null) {
                    list.add(class_5684.method_32662((class_5481)EmiPort.translatable("tooltip.emi.synfav.craft_some", craftKey).method_30937()));
                }
            } else if (this.state == 2) {
                list.add(class_5684.method_32662((class_5481)EmiPort.translatable("tooltip.emi.synfav.fully_craftable", this.batches).method_30937()));
                if (craftKey != null) {
                    list.add(class_5684.method_32662((class_5481)EmiPort.translatable("tooltip.emi.synfav.craft_all", craftKey, this.batches).method_30937()));
                }
            }
            return list;
        }

        @Override
        public boolean isUnbatchable() {
            return true;
        }
    }

    public static class Craftable
    extends EmiFavorite {
        public Craftable(EmiRecipe recipe) {
            super(recipe.getOutputs().isEmpty() ? EmiStack.EMPTY : (EmiIngredient)recipe.getOutputs().get(0), recipe);
        }

        @Override
        public void render(class_332 raw, int x, int y, float delta, int flags) {
            super.render(raw, x, y, delta, flags & 0xFFFFFFFB);
        }
    }
}

