/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.fabric.event;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.config.enums.BreakMode;
import fr.rakambda.fallingtree.common.tree.BreakTreeResult;
import fr.rakambda.fallingtree.common.tree.exception.NoTreeFoundException;
import fr.rakambda.fallingtree.common.tree.exception.NotServerException;
import fr.rakambda.fallingtree.common.tree.exception.PlayerNotInRightState;
import fr.rakambda.fallingtree.common.tree.exception.ToolUseForcedException;
import fr.rakambda.fallingtree.common.tree.exception.TreeBreakingException;
import fr.rakambda.fallingtree.common.tree.exception.TreeBreakingNotEnabledException;
import fr.rakambda.fallingtree.fabric.common.wrapper.BlockPosWrapper;
import fr.rakambda.fallingtree.fabric.common.wrapper.LevelWrapper;
import fr.rakambda.fallingtree.fabric.common.wrapper.PlayerWrapper;
import fr.rakambda.fallingtree.fabric.common.wrapper.ServerLevelWrapper;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class BlockBreakListener
implements PlayerBlockBreakEvents.Before {
    @NotNull
    private final FallingTreeCommon<?> mod;

    public boolean beforeBlockBreak(class_1937 level, class_1657 player, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
        LevelWrapper levelWrapper;
        PlayerWrapper wrappedPlayer = new PlayerWrapper(player);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            levelWrapper = new ServerLevelWrapper(serverLevel);
        } else {
            levelWrapper = new LevelWrapper(level);
        }
        LevelWrapper wrappedLevel = levelWrapper;
        BlockPosWrapper wrappedPos = new BlockPosWrapper(blockPos);
        try {
            BreakTreeResult result = this.mod.getTreeHandler().breakTree(wrappedLevel, wrappedPlayer, wrappedPos);
            return switch (result.breakMode()) {
                default -> throw new IncompatibleClassChangeError();
                case BreakMode.INSTANTANEOUS, BreakMode.FALL_ITEM, BreakMode.FALL_BLOCK, BreakMode.FALL_ALL_BLOCK -> {
                    if (!result.shouldCancel()) {
                        yield true;
                    }
                    yield false;
                }
                case BreakMode.SHIFT_DOWN -> false;
            };
        }
        catch (NoTreeFoundException | NotServerException | PlayerNotInRightState | TreeBreakingException | TreeBreakingNotEnabledException e) {
            return true;
        }
        catch (ToolUseForcedException e) {
            return false;
        }
    }

    public BlockBreakListener(@NotNull FallingTreeCommon<?> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

