/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.forge.event;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.tree.BreakTreeResult;
import fr.rakambda.fallingtree.common.tree.exception.NoTreeFoundException;
import fr.rakambda.fallingtree.common.tree.exception.NotServerException;
import fr.rakambda.fallingtree.common.tree.exception.PlayerNotInRightState;
import fr.rakambda.fallingtree.common.tree.exception.ToolUseForcedException;
import fr.rakambda.fallingtree.common.tree.exception.TreeBreakingException;
import fr.rakambda.fallingtree.common.tree.exception.TreeBreakingNotEnabledException;
import fr.rakambda.fallingtree.forge.common.wrapper.BlockPosWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.LevelWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.PlayerWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.ServerLevelWrapper;
import fr.rakambda.fallingtree.forge.event.FallingTreeBlockBreakEvent;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class BlockBreakListener {
    @NotNull
    private final FallingTreeCommon<?> mod;

    @SubscribeEvent
    public void onBreakSpeed(@Nonnull PlayerEvent.BreakSpeed event) {
        if (event.isCanceled()) {
            return;
        }
        Optional optionalPos = event.getPosition();
        if (optionalPos.isEmpty()) {
            return;
        }
        PlayerWrapper wrappedPlayer = new PlayerWrapper(event.getEntity());
        BlockPosWrapper wrappedPos = new BlockPosWrapper((BlockPos)optionalPos.get());
        Optional<Float> result = this.mod.getTreeHandler().getBreakSpeed(wrappedPlayer, wrappedPos, event.getNewSpeed());
        if (result.isEmpty()) {
            return;
        }
        event.setNewSpeed(result.get().floatValue());
    }

    @SubscribeEvent
    public void onBlockBreakEvent(@Nonnull BlockEvent.BreakEvent event) {
        block12: {
            LevelWrapper levelWrapper;
            if (event.isCanceled()) {
                return;
            }
            if (event instanceof FallingTreeBlockBreakEvent) {
                return;
            }
            PlayerWrapper wrappedPlayer = new PlayerWrapper(event.getPlayer());
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelAccessor;
                levelWrapper = new ServerLevelWrapper(serverLevel);
            } else {
                levelWrapper = new LevelWrapper(event.getLevel());
            }
            LevelWrapper wrappedLevel = levelWrapper;
            BlockPosWrapper wrappedPos = new BlockPosWrapper(event.getPos());
            try {
                BreakTreeResult result = this.mod.getTreeHandler().breakTree(wrappedLevel, wrappedPlayer, wrappedPos);
                if (event.isCancelable()) {
                    switch (result.breakMode()) {
                        case INSTANTANEOUS: 
                        case FALL_ITEM: 
                        case FALL_BLOCK: 
                        case FALL_ALL_BLOCK: {
                            event.setCanceled(result.shouldCancel());
                            break;
                        }
                        case SHIFT_DOWN: {
                            event.setCanceled(true);
                        }
                    }
                }
            }
            catch (NoTreeFoundException | NotServerException | PlayerNotInRightState | TreeBreakingException | TreeBreakingNotEnabledException result) {
            }
            catch (ToolUseForcedException e) {
                if (!event.isCancelable()) break block12;
                event.setCanceled(true);
            }
        }
    }

    public BlockBreakListener(@NotNull FallingTreeCommon<?> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

