/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.rei.category;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.rei.category.CreateRecipeCategory;
import com.simibubi.create.compat.rei.display.CreateDisplay;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.apache.commons.lang3.mutable.MutableInt;

public class BasinCategory
extends CreateRecipeCategory<BasinRecipe> {
    private boolean needsHeating;

    public BasinCategory(CreateRecipeCategory.Info<BasinRecipe> info, boolean needsHeating) {
        super(info);
        this.needsHeating = needsHeating;
    }

    @Override
    public void addWidgets(CreateDisplay<BasinRecipe> display, List<Widget> widgets, Point origin) {
        int j;
        int i;
        BasinRecipe recipe = display.getRecipe();
        class_2371<FluidIngredient> fluidIngredients = recipe.getFluidIngredients();
        List<Pair<class_1856, MutableInt>> ingredients = ItemHelper.condenseIngredients(recipe.method_8117());
        List<class_1799> itemOutputs = recipe.getRollableResultsAsItemStacks();
        class_2371<io.github.fabricators_of_create.porting_lib.util.FluidStack> fluidOutputs = recipe.getFluidResults();
        int size = ingredients.size() + fluidIngredients.size();
        int xOffset = size < 3 ? (3 - size) * 19 / 2 : 0;
        int yOffset = 0;
        for (i = 0; i < ingredients.size(); ++i) {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            Pair<class_1856, MutableInt> pair = ingredients.get(i);
            class_1856 ingredient = pair.getFirst();
            MutableInt amount = pair.getSecond();
            for (class_1799 itemStack : ingredient.method_8105()) {
                class_1799 stack = itemStack.method_7972();
                stack.method_7939(amount.getValue().intValue());
                stacks.add(stack);
            }
            widgets.add((Widget)BasinCategory.basicSlot(origin.x + 17 + xOffset + i % 3 * 19, origin.y + 51 - i / 3 * 19 + yOffset).markInput().entries((Collection)EntryIngredients.ofItemStacks(stacks)));
        }
        for (j = 0; j < fluidIngredients.size(); ++j) {
            int i2 = i + j;
            List<io.github.fabricators_of_create.porting_lib.util.FluidStack> stacks = ((FluidIngredient)fluidIngredients.get(j)).getMatchingFluidStacks();
            Slot fluidSlot = BasinCategory.basicSlot(origin.x + 17 + xOffset + i2 % 3 * 19, origin.y + 51 - i2 / 3 * 19 + yOffset).markInput().entries((Collection)EntryIngredients.of((FluidStack)CreateRecipeCategory.convertToREIFluid(stacks.get(0))));
            CreateRecipeCategory.setFluidRenderRatio(fluidSlot);
            widgets.add((Widget)fluidSlot);
        }
        int outSize = fluidOutputs.size() + recipe.getRollableResults().size();
        int outputIndex = 0;
        if (!itemOutputs.isEmpty()) {
            BasinCategory.addStochasticTooltip(widgets, recipe.getRollableResults(), i);
        }
        while (outputIndex < outSize) {
            int xPosition = 141 - (outSize % 2 != 0 && outputIndex == outSize - 1 ? 0 : (outputIndex % 2 == 0 ? 10 : -9));
            int yPosition = -19 * (outputIndex / 2) + 50 + yOffset;
            if (itemOutputs.size() > outputIndex) {
                widgets.add((Widget)BasinCategory.basicSlot(origin.x + xPosition + 1, origin.y + yPosition + yOffset + 1).markOutput().entries((Collection)EntryIngredients.of((class_1799)itemOutputs.get(outputIndex))));
                ++i;
            } else {
                Slot fluidSlot = BasinCategory.basicSlot(origin.x + xPosition + 1, origin.y + yPosition + 1 + yOffset).markOutput().entries((Collection)EntryIngredients.of((FluidStack)CreateRecipeCategory.convertToREIFluid((io.github.fabricators_of_create.porting_lib.util.FluidStack)fluidOutputs.get(outputIndex - itemOutputs.size()))));
                CreateRecipeCategory.setFluidRenderRatio(fluidSlot);
                widgets.add((Widget)fluidSlot);
                ++j;
            }
            ++outputIndex;
        }
        BasinCategory.addFluidTooltip(widgets, fluidIngredients, fluidOutputs);
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            widgets.add((Widget)BasinCategory.basicSlot(origin.x + 134, origin.y + 81).markInput().entries((Collection)EntryIngredients.of((class_1799)AllBlocks.BLAZE_BURNER.asStack())));
            ++i;
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            widgets.add((Widget)BasinCategory.basicSlot(origin.x + 153, origin.y + 81).markOutput().entries((Collection)EntryIngredients.of((class_1799)AllItems.BLAZE_CAKE.asStack())));
            ++i;
        }
    }

    @Override
    public void draw(BasinRecipe recipe, class_332 graphics, double mouseX, double mouseY) {
        List<Pair<class_1856, MutableInt>> actualIngredients = ItemHelper.condenseIngredients(recipe.method_8117());
        int size = actualIngredients.size() + recipe.getFluidIngredients().size();
        int outSize = recipe.getFluidResults().size() + recipe.getRollableResults().size();
        int xOffset = size < 3 ? (3 - size) * 19 / 2 : 0;
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        int yOffset = 0;
        for (int i = 0; i < size; ++i) {
            AllGuiTextures.JEI_SLOT.render(graphics, 16 + xOffset + i % 3 * 19, 50 - i / 3 * 19 + yOffset);
        }
        boolean noHeat = requiredHeat == HeatCondition.NONE;
        int vRows = (1 + outSize) / 2;
        for (int i = 0; i < outSize; ++i) {
            AllGuiTextures.JEI_SLOT.render(graphics, 141 - (outSize % 2 != 0 && i == outSize - 1 ? 0 : (i % 2 == 0 ? 10 : -9)), -19 * (i / 2) + 50 + yOffset);
        }
        if (vRows <= 2) {
            AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 136, -19 * (vRows - 1) + 32 + yOffset);
        }
        AllGuiTextures shadow = noHeat ? AllGuiTextures.JEI_SHADOW : AllGuiTextures.JEI_LIGHT;
        shadow.render(graphics, 81, 58 + (noHeat ? 10 : 30));
        if (!this.needsHeating) {
            return;
        }
        AllGuiTextures heatBar = noHeat ? AllGuiTextures.JEI_NO_HEAT_BAR : AllGuiTextures.JEI_HEAT_BAR;
        heatBar.render(graphics, 4, 80);
        graphics.method_27535(class_310.method_1551().field_1772, (class_2561)Lang.translateDirect(requiredHeat.getTranslationKey(), new Object[0]), 9, 86, requiredHeat.getColor());
    }
}

