/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.chalk;

import com.mojang.logging.LogUtils;
import de.dafuqs.chalk.blocks.ChalkMarkBlock;
import de.dafuqs.chalk.blocks.GlowChalkMarkBlock;
import de.dafuqs.chalk.items.ChalkItem;
import de.dafuqs.chalk.items.GlowChalkItem;
import de.dafuqs.chalk.util.ChalkLoader;
import java.util.HashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class Chalk
implements ModInitializer {
    public static final String MOD_ID = "chalk";
    private static final Logger LOGGER = LogUtils.getLogger();
    public HashMap<class_1767, Integer> dyeColors = new HashMap<class_1767, Integer>(){
        {
            this.put(class_1767.field_7963, 0x171717);
            this.put(class_1767.field_7966, 2895502);
            this.put(class_1767.field_7957, 6372384);
            this.put(class_1767.field_7955, 1406599);
            this.put(class_1767.field_7944, 0x292929);
            this.put(class_1767.field_7942, 4807460);
            this.put(class_1767.field_7951, 2460360);
            this.put(class_1767.field_7967, 0x8B8B8B);
            this.put(class_1767.field_7961, 6269465);
            this.put(class_1767.field_7958, 11154080);
            this.put(class_1767.field_7946, 14770689);
            this.put(class_1767.field_7954, 14050703);
            this.put(class_1767.field_7945, 6561692);
            this.put(class_1767.field_7964, 9380129);
            this.put(class_1767.field_7952, 0xFFFFFF);
            this.put(class_1767.field_7947, 15793941);
        }
    };
    public static HashMap<class_1767, ChalkVariant> chalkVariants = new HashMap();

    private static boolean always(class_2680 blockState, class_1922 blockView, class_2338 blockPos) {
        return true;
    }

    private static boolean never(class_2680 blockState, class_1922 blockView, class_2338 blockPos) {
        return false;
    }

    private static void registerBlock(String name, class_2248 block) {
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960(MOD_ID, name), (Object)block);
    }

    private static void registerItem(String name, class_1792 item) {
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, name), (Object)item);
    }

    public void onInitialize() {
        ChalkLoader.detectLoader();
        boolean colorfulAddonPresent = ChalkLoader.isColorfulAddonLoaded();
        Chalk.log("Registering blocks and items...");
        for (class_1767 dyeColor : class_1767.values()) {
            ChalkVariant chalkVariant;
            int color = this.dyeColors.get(dyeColor);
            if (dyeColor.equals((Object)class_1767.field_7952)) {
                chalkVariant = new ChalkVariant(dyeColor, color, "");
                chalkVariant.register();
                chalkVariants.put(dyeColor, chalkVariant);
                continue;
            }
            if (!colorfulAddonPresent) continue;
            chalkVariant = new ChalkVariant(dyeColor, color, dyeColor + "_");
            chalkVariant.register();
            chalkVariants.put(dyeColor, chalkVariant);
        }
        Chalk.log("Startup finished!");
    }

    public static void log(String message) {
        LOGGER.info("[Chalk] " + message);
    }

    public static class ChalkVariant {
        String colorString;
        int color;
        public class_1792 chalkItem;
        public class_2248 chalkBlock;
        public class_1792 glowChalkItem;
        public class_2248 glowChalkBlock;

        public ChalkVariant(class_1767 dyeColor, int color, String colorString) {
            this.color = color;
            this.colorString = colorString;
            this.chalkItem = new ChalkItem(new class_1792.class_1793().method_7889(1).method_7895(64), dyeColor);
            this.chalkBlock = new ChalkMarkBlock(class_4970.class_2251.method_9637().method_51371().method_9634().method_22488().method_9626(class_2498.field_11529).method_50012(class_3619.field_15971), dyeColor);
            this.glowChalkItem = new GlowChalkItem(new class_1792.class_1793().method_7889(1).method_7895(64), dyeColor);
            this.glowChalkBlock = new GlowChalkMarkBlock(class_4970.class_2251.method_9637().method_51371().method_9634().method_22488().method_9626(class_2498.field_11529).method_9631(state -> ChalkLoader.isContinuityLoaded() ? 0 : 1).method_26247(ChalkLoader.isContinuityLoaded() ? Chalk::never : Chalk::always).method_26249(ChalkLoader.isContinuityLoaded() ? Chalk::never : Chalk::always).method_50012(class_3619.field_15971), dyeColor);
            this.ItemGroups();
        }

        public void ItemGroups() {
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(entries -> entries.method_45421((class_1935)this.chalkItem));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(entries -> entries.method_45421((class_1935)this.chalkItem));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(entries -> entries.method_45421((class_1935)this.glowChalkItem));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(entries -> entries.method_45421((class_1935)this.glowChalkItem));
        }

        public void register() {
            Chalk.registerBlock(this.colorString + "chalk_mark", this.chalkBlock);
            Chalk.registerItem(this.colorString + Chalk.MOD_ID, this.chalkItem);
            Chalk.registerBlock(this.colorString + "glow_chalk_mark", this.glowChalkBlock);
            Chalk.registerItem(this.colorString + "glow_chalk", this.glowChalkItem);
        }

        public void registerClient() {
            BlockRenderLayerMap.INSTANCE.putBlock(this.chalkBlock, class_1921.method_23581());
            BlockRenderLayerMap.INSTANCE.putBlock(this.glowChalkBlock, class_1921.method_23581());
            ColorProviderRegistry.BLOCK.register((state, world, pos, index) -> this.color, (Object[])new class_2248[]{this.chalkBlock});
            ColorProviderRegistry.BLOCK.register((state, world, pos, index) -> this.color, (Object[])new class_2248[]{this.glowChalkBlock});
        }
    }
}

