/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.fabric.network;

import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.fabric.network.ServerNetwork;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.jetbrains.annotations.Nullable;

public class ClientNetworkInstance
extends AbstractNetworkInstance
implements C2SPlayChannelEvents.Register,
ClientPlayConnectionEvents.Disconnect {
    public static ClientNetworkInstance networkInstance = new ClientNetworkInstance();
    private final AtomicInteger connectState = new AtomicInteger(0);

    public void init() {
        ClientPlayConnectionEvents.JOIN.register(this::playerJoin);
        C2SPlayChannelEvents.REGISTER.register((Object)this);
        ClientPlayConnectionEvents.DISCONNECT.register((Object)this);
    }

    public void onChannelRegister(class_634 handler, PacketSender sender, class_310 client, List<class_2960> channels) {
        if (channels.contains(ServerNetwork.channelID) && this.connectState.incrementAndGet() == 2) {
            this.connectState.set(0);
            this.sendConfigCallback();
        }
    }

    private void playerJoin(class_634 clientPacketListener, PacketSender packetSender, class_310 minecraft) {
        ClientPlayNetworking.registerReceiver((class_2960)ServerNetwork.channelID, this::receiveMessage);
        if (this.connectState.incrementAndGet() == 2) {
            this.connectState.set(0);
            this.sendConfigCallback();
        }
    }

    public void onPlayDisconnect(class_634 handler, class_310 client) {
        this.connectState.set(0);
        this.disconnect();
    }

    void receiveMessage(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        if (buf.isDirect() || buf.isReadOnly()) {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.getBytes(buf.readerIndex(), bytes);
            this.receiveMessage(bytes);
        } else {
            this.receiveMessage(buf.array());
        }
    }

    @Override
    public boolean sendPlayerID() {
        return false;
    }

    @Override
    public boolean isActive() {
        return ClientPlayNetworking.canSend((class_2960)ServerNetwork.channelID);
    }

    @Override
    public void sendMessage(EmotePacket.Builder builder, @Nullable UUID target) throws IOException {
        if (target != null) {
            builder.configureTarget(target);
        }
        EmotePacket writer = builder.build();
        ClientPlayNetworking.send((class_2960)ServerNetwork.channelID, (class_2540)new class_2540(Unpooled.wrappedBuffer((byte[])writer.write().array())));
        if (writer.data.emoteData != null && writer.data.emoteData.extraData.containsKey("song") && !writer.data.writeSong) {
            EmoteInstance.instance.getClientMethods().sendChatMessage(EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.song_too_big_to_send"));
        }
    }
}

