/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.resourcepack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import earth.terrarium.ad_astra.AdAstra;
import earth.terrarium.ad_astra.client.AdAstraClient;
import earth.terrarium.ad_astra.client.dimension.ClientModSkies;
import earth.terrarium.ad_astra.client.resourcepack.Galaxy;
import earth.terrarium.ad_astra.client.resourcepack.PlanetRing;
import earth.terrarium.ad_astra.client.resourcepack.PlanetSkyRenderer;
import earth.terrarium.ad_astra.client.resourcepack.SolarSystem;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4013;
import org.slf4j.Logger;

public class PlanetResources
implements class_4013 {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public void method_14491(class_3300 manager) {
        JsonObject jsonObject;
        InputStreamReader reader;
        ArrayList<PlanetSkyRenderer> skyRenderers = new ArrayList<PlanetSkyRenderer>();
        ArrayList<SolarSystem> solarSystems = new ArrayList<SolarSystem>();
        ArrayList<PlanetRing> planetRings = new ArrayList<PlanetRing>();
        ArrayList<Galaxy> galaxies = new ArrayList<Galaxy>();
        for (class_2960 id : manager.method_14488("planet_resources/sky_renderers", path -> path.method_12832().endsWith(".json")).keySet()) {
            try {
                for (class_3298 resource : manager.method_14489(id)) {
                    reader = new InputStreamReader(resource.method_14482());
                    jsonObject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    skyRenderers.add((PlanetSkyRenderer)PlanetSkyRenderer.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)AdAstra.LOGGER).error(arg_0)));
                }
            }
            catch (Exception e) {
                AdAstra.LOGGER.error("Failed to load Ad Astra sky rendering assets from: \"" + id.toString() + "\"", (Throwable)e);
                e.printStackTrace();
            }
        }
        for (class_2960 id : manager.method_14488("planet_resources/solar_systems", path -> path.method_12832().endsWith(".json")).keySet()) {
            try {
                for (class_3298 resource : manager.method_14489(id)) {
                    reader = new InputStreamReader(resource.method_14482());
                    jsonObject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    solarSystems.add((SolarSystem)SolarSystem.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)AdAstra.LOGGER).error(arg_0)));
                }
            }
            catch (Exception e) {
                AdAstra.LOGGER.error("Failed to load Ad Astra solar system assets from: \"" + id.toString() + "\"", (Throwable)e);
                e.printStackTrace();
            }
        }
        for (class_2960 id : manager.method_14488("planet_resources/planet_rings", path -> path.method_12832().endsWith(".json")).keySet()) {
            try {
                for (class_3298 resource : manager.method_14489(id)) {
                    reader = new InputStreamReader(resource.method_14482());
                    jsonObject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    planetRings.add((PlanetRing)PlanetRing.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)AdAstra.LOGGER).error(arg_0)));
                }
            }
            catch (Exception e) {
                AdAstra.LOGGER.error("Failed to load Ad Astra planet ring assets from: \"" + id.toString() + "\"", (Throwable)e);
                e.printStackTrace();
            }
        }
        for (class_2960 id : manager.method_14488("planet_resources/galaxy", path -> path.method_12832().endsWith(".json")).keySet()) {
            try {
                for (class_3298 resource : manager.method_14489(id)) {
                    reader = new InputStreamReader(resource.method_14482());
                    jsonObject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    galaxies.add((Galaxy)Galaxy.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)AdAstra.LOGGER).error(arg_0)));
                }
            }
            catch (Exception e) {
                AdAstra.LOGGER.error("Failed to load Ad Astra galaxy assets from: \"" + id.toString() + "\"", (Throwable)e);
                e.printStackTrace();
            }
        }
        solarSystems.sort(Comparator.comparing(SolarSystem::solarSystem));
        galaxies.sort(Comparator.comparing(Galaxy::galaxy));
        AdAstraClient.skyRenderers = skyRenderers;
        AdAstraClient.solarSystems = solarSystems;
        AdAstraClient.planetRings = planetRings;
        AdAstraClient.galaxies = galaxies;
        ClientModSkies.register();
    }
}

