/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.screen.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teamresourceful.resourcefullib.client.utils.ScreenUtils;
import com.teamresourceful.resourcefullib.common.color.Color;
import earth.terrarium.ad_astra.client.screen.util.ButtonType;
import earth.terrarium.ad_astra.client.screen.util.PlanetSelectionScreen;
import earth.terrarium.ad_astra.common.data.ButtonColor;
import earth.terrarium.ad_astra.common.data.Planet;
import earth.terrarium.ad_astra.common.util.ColourUtils;
import java.util.LinkedList;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_757;

public class CustomButton
extends class_4185 {
    public static final class_2960 LARGE_BUTTON_TEXTURE = new class_2960("ad_astra", "textures/gui/buttons/large_button.png");
    public static final class_2960 BUTTON_TEXTURE = new class_2960("ad_astra", "textures/gui/buttons/button.png");
    public static final class_2960 SMALL_BUTTON_TEXTURE = new class_2960("ad_astra", "textures/gui/buttons/small_button.png");
    public static final class_2960 STEEL_BUTTON_TEXTURE = new class_2960("ad_astra", "textures/gui/buttons/steel_button.png");
    private final int startY;
    private final class_2561 label;
    private final ButtonType buttonSize;
    private final Color buttonColourLightened;
    private final Color buttonColour;
    private final Planet planetInfo;
    private final PlanetSelectionScreen.TooltipType tooltip;
    public boolean doScissor = true;

    public CustomButton(int x, int y, class_2561 label, ButtonType size, ButtonColor buttonColor, PlanetSelectionScreen.TooltipType tooltip, Planet planetInfo, class_4185.class_4241 onPress) {
        super(x, y, size.getWidth(), size.getHeight(), CustomButton.adjustText(label), onPress, class_4185.field_40754);
        this.startY = y;
        this.label = label;
        this.buttonSize = size;
        Color colour = buttonColor.getColour();
        this.buttonColourLightened = ColourUtils.lighten(colour, 0.1f);
        this.buttonColour = colour;
        this.tooltip = tooltip;
        this.planetInfo = planetInfo;
    }

    public static class_2561 adjustText(class_2561 label) {
        int length = label.getString().length();
        if (length > 12 && length != 13) {
            return class_2561.method_30163((String)(label.method_10858(12) + "."));
        }
        return label;
    }

    public void method_25348(double mouseX, double mouseY) {
        super.method_25348(mouseX, mouseY);
        this.method_46419(this.startY);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.field_22764) {
            class_310 minecraft = class_310.method_1551();
            double scale = minecraft.method_22683().method_4495();
            int screenHeight = minecraft.method_22683().method_4502();
            int scissorY = (int)((double)(screenHeight / 2 - 83) * scale);
            boolean over = this.method_25405(mouseX, mouseY);
            Color color = over ? this.buttonColourLightened : this.buttonColour;
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(5.0f, 0.0f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.enableDepthTest();
            if (this.doScissor) {
                RenderSystem.enableScissor((int)0, (int)scissorY, (int)((int)(215.0 * scale)), (int)((int)(127.0 * scale)));
            }
            RenderSystem.setShaderColor((float)color.getFloatRed(), (float)color.getFloatGreen(), (float)color.getFloatBlue(), (float)this.buttonColour.getFloatAlpha());
            class_2960 texture = switch (this.buttonSize) {
                default -> throw new IncompatibleClassChangeError();
                case ButtonType.LARGE -> LARGE_BUTTON_TEXTURE;
                case ButtonType.NORMAL -> BUTTON_TEXTURE;
                case ButtonType.SMALL -> SMALL_BUTTON_TEXTURE;
                case ButtonType.STEEL -> STEEL_BUTTON_TEXTURE;
            };
            graphics.method_25290(texture, this.buttonSize.equals((Object)ButtonType.LARGE) ? this.method_46426() - 2 : this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.field_22758, this.field_22759, this.buttonSize.getWidth(), this.buttonSize.getHeight());
            this.drawText(graphics, minecraft);
            if (this.doScissor) {
                RenderSystem.disableScissor();
            }
            if (this.method_25405(mouseX, mouseY)) {
                this.renderTooltips(minecraft);
            }
            graphics.method_51448().method_22909();
            RenderSystem.disableDepthTest();
        }
    }

    public void drawText(class_332 graphics, class_310 minecraft) {
        int colour = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
        graphics.method_51448().method_22903();
        float scale = 0.9f;
        graphics.method_51448().method_22905(scale, scale, scale);
        int x = this.buttonSize.equals((Object)ButtonType.LARGE) ? this.method_46426() - 2 : this.method_46426();
        graphics.method_51448().method_46416(4.0f + (float)x / 9.5f, (float)this.method_46427() / 8.5f, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_27534(minecraft.field_1772, this.method_25369(), x + this.field_22758 / 2, this.method_46427() + (this.field_22759 - 8) / 2, colour | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
        graphics.method_51448().method_22909();
    }

    public int getStartY() {
        return this.startY;
    }

    private void renderTooltips(class_310 minecraft) {
        LinkedList<class_2561> textEntries = new LinkedList<class_2561>();
        switch (this.tooltip) {
            case GALAXY: {
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.CATEGORY_TEXT.getString() + ": \u00a7b" + this.label.getString())));
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.TYPE_TEXT.getString() + ": \u00a75" + PlanetSelectionScreen.GALAXY_TEXT.getString())));
                break;
            }
            case SOLAR_SYSTEM: {
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.CATEGORY_TEXT.getString() + ": \u00a7b" + this.label.getString())));
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.TYPE_TEXT.getString() + ": \u00a73" + PlanetSelectionScreen.SOLAR_SYSTEM_TEXT.getString())));
                break;
            }
            case CATEGORY: {
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.CATEGORY_TEXT.getString() + ": \u00a7a" + this.label.getString())));
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.PROVIDED_TEXT.getString() + ": \u00a7b" + class_2561.method_43471((String)("item.ad_astra.tier_" + this.planetInfo.rocketTier() + "_rocket")).getString())));
                break;
            }
            case PLANET: {
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.TYPE_TEXT.getString() + ": \u00a73" + (this.planetInfo.parentWorld() == null ? PlanetSelectionScreen.PLANET_TEXT.getString() : PlanetSelectionScreen.MOON_TEXT.getString()))));
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.GRAVITY_TEXT.getString() + ": \u00a73" + this.planetInfo.gravity() + " m/s")));
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.OXYGEN_TEXT.getString() + ": \u00a7" + (this.planetInfo.hasOxygen() ? "a" + PlanetSelectionScreen.OXYGEN_TRUE_TEXT.getString() : "c" + PlanetSelectionScreen.OXYGEN_FALSE_TEXT.getString()))));
                String temperatureColour = "\u00a7a";
                if (this.planetInfo.temperature() > 50.0f) {
                    temperatureColour = "\u00a76";
                } else if (this.planetInfo.temperature() < -20.0f) {
                    temperatureColour = "\u00a71";
                }
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.TEMPERATURE_TEXT.getString() + ": " + temperatureColour + " " + this.planetInfo.temperature() + " \u00b0C")));
                break;
            }
            case SPACE_STATION: {
                PlanetSelectionScreen currentScreen = (PlanetSelectionScreen)minecraft.field_1755;
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.ITEM_REQUIREMENT_TEXT.getString())));
                if (currentScreen == null) {
                    return;
                }
                currentScreen.ingredients.forEach(ingredient -> {
                    boolean isEnough = ((class_1799)ingredient.getFirst()).method_7947() >= (Integer)ingredient.getSecond();
                    textEntries.add(class_2561.method_30163((String)("\u00a7" + (isEnough ? "a" : "c") + ((class_1799)ingredient.getFirst()).method_7947() + "/" + ingredient.getSecond() + " \u00a73" + ((class_1799)ingredient.getFirst()).method_7964().getString())));
                });
                textEntries.add(class_2561.method_30163((String)"\u00a7c----------------"));
                break;
            }
        }
        if (this.tooltip.equals((Object)PlanetSelectionScreen.TooltipType.ORBIT) || this.tooltip.equals((Object)PlanetSelectionScreen.TooltipType.SPACE_STATION)) {
            textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.TYPE_TEXT.getString() + ": \u00a73" + PlanetSelectionScreen.ORBIT_TEXT.getString())));
            textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.GRAVITY_TEXT.getString() + ": \u00a73" + PlanetSelectionScreen.NO_GRAVITY_TEXT.getString())));
            textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.OXYGEN_TEXT.getString() + ": \u00a7c " + PlanetSelectionScreen.OXYGEN_FALSE_TEXT.getString())));
            textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.TEMPERATURE_TEXT.getString() + ": \u00a71 -270.0 \u00b0C")));
        }
        ScreenUtils.setTooltip(textEntries);
    }
}

