/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.entity.vehicle;

import earth.terrarium.ad_astra.common.block.door.LocationState;
import earth.terrarium.ad_astra.common.block.launchpad.LaunchPad;
import earth.terrarium.ad_astra.common.config.VehiclesConfig;
import earth.terrarium.ad_astra.common.entity.vehicle.Vehicle;
import earth.terrarium.ad_astra.common.item.armor.NetheriteSpaceSuit;
import earth.terrarium.ad_astra.common.registry.ModCriteria;
import earth.terrarium.ad_astra.common.registry.ModDamageSources;
import earth.terrarium.ad_astra.common.registry.ModParticleTypes;
import earth.terrarium.ad_astra.common.registry.ModSoundEvents;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.ad_astra.common.screen.PlanetSelectionMenuProvider;
import earth.terrarium.ad_astra.common.screen.menu.PlanetSelectionMenu;
import earth.terrarium.ad_astra.common.util.ModKeyBindings;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import earth.terrarium.botarium.common.menu.ExtraDataMenuProvider;
import earth.terrarium.botarium.common.menu.MenuHooks;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2770;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3611;

public class Rocket
extends Vehicle {
    protected static final class_2940<Boolean> HAS_LAUNCH_PAD = class_2945.method_12791(Rocket.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> FLYING = class_2945.method_12791(Rocket.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Integer> COUNTDOWN_TICKS = class_2945.method_12791(Rocket.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> TIER = class_2945.method_12791(Rocket.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> PHASE = class_2945.method_12791(Rocket.class, (class_2941)class_2943.field_13327);
    private class_1657 lastRider;

    public Rocket(class_1299<?> type, class_1937 level, int tier) {
        super(type, level);
        this.setTier(tier);
    }

    public static void stopRocketSoundForRider(class_3222 rider) {
        class_2770 stopSoundS2CPacket = new class_2770(new class_2960("ad_astra", "rocket_fly"), class_3419.field_15256);
        rider.field_13987.method_14364((class_2596)stopSoundS2CPacket);
    }

    public static long getRequiredAmountForLaunch(class_3611 fluid) {
        if (fluid.method_15791(ModTags.EFFICIENT_FUELS)) {
            return VehiclesConfig.RocketConfig.efficientFuelLaunchCost;
        }
        return VehiclesConfig.RocketConfig.fuelLaunchCost;
    }

    @Override
    public int getInventorySize() {
        return 10;
    }

    @Override
    public long getTankSize() {
        return VehiclesConfig.RocketConfig.tankSize;
    }

    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        super.method_5688(player, hand);
        this.openInventory(player);
        return class_1269.field_5812;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HAS_LAUNCH_PAD, (Object)false);
        this.field_6011.method_12784(FLYING, (Object)false);
        this.field_6011.method_12784(COUNTDOWN_TICKS, (Object)0);
        this.field_6011.method_12784(TIER, (Object)0);
        this.field_6011.method_12784(PHASE, (Object)0);
    }

    public class_243 method_24829(class_1309 passenger) {
        super.method_24829(passenger);
        int exitDirection = Math.round(passenger.method_36454() / 90.0f) * 90;
        class_243 pos = passenger.method_19538();
        class_243 exitPos = switch (exitDirection) {
            case 0, 360 -> new class_243(pos.method_10216(), pos.method_10214(), pos.method_10215() + 1.5);
            case -270, 90 -> new class_243(pos.method_10216() - 1.5, pos.method_10214(), pos.method_10215());
            case -90, 270 -> new class_243(pos.method_10216() + 1.5, pos.method_10214(), pos.method_10215());
            case -180, 180 -> new class_243(pos.method_10216(), pos.method_10214(), pos.method_10215() - 1.5);
            default -> super.method_24829(passenger);
        };
        class_2338 exitBlockPos = class_2338.method_49638((class_2374)exitPos);
        for (int checks = 3; !this.method_37908().method_8320(exitBlockPos).method_26212((class_1922)this.method_37908(), exitBlockPos) && checks > 0; --checks) {
            exitBlockPos = exitBlockPos.method_10074();
        }
        class_2680 exitBlockState = this.method_37908().method_8320(exitBlockPos.method_10084());
        class_265 collisionShape = exitBlockState.method_26220((class_1922)this.method_37908(), exitBlockPos);
        double yOffset = 0.0;
        if (!collisionShape.method_1110()) {
            yOffset = exitBlockState.method_26220((class_1922)this.method_37908(), exitBlockPos).method_1107().method_17940();
        }
        return new class_243((double)exitBlockPos.method_10263(), (double)exitBlockPos.method_10084().method_10264() + yOffset, (double)exitBlockPos.method_10260());
    }

    public void assignLaunchPad(boolean value) {
        this.setLaunchPad(value);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_1657) {
            class_1657 player;
            this.lastRider = player = (class_1657)class_12972;
            if (ModKeyBindings.leftKeyDown(player)) {
                this.rotateRocketAndPassengers(-1.0f);
            }
            if (ModKeyBindings.rightKeyDown(player)) {
                this.rotateRocketAndPassengers(1.0f);
            }
        }
        if (this.method_23318() >= (double)VehiclesConfig.RocketConfig.atmosphereLeave || this.method_32312() > 1000) {
            this.setFlying(true);
        }
        if (!this.isFlying()) {
            if (this.hasLaunchPad()) {
                class_2680 below = this.method_37908().method_8320(this.method_24515());
                if (!(below.method_26204() instanceof LaunchPad)) {
                    this.drop();
                } else if (below.method_26204() instanceof LaunchPad && below.method_11654(LaunchPad.LOCATION) != LocationState.CENTER) {
                    this.drop();
                }
            }
        } else {
            this.setCountdownTicks(this.getCountdownTicks() - 1);
            if (this.getCountdownTicks() > 0) {
                this.spawnSmokeParticles();
                this.setPhase(1);
            } else if (this.method_23318() < (double)VehiclesConfig.RocketConfig.atmosphereLeave) {
                this.spawnAfterburnerParticles();
                this.burnEntitiesUnderRocket();
                this.travel();
                if (this.getCountdownTicks() < -30) {
                    this.explodeIfStopped();
                }
                this.setPhase(2);
            } else if (this.method_23318() >= (double)VehiclesConfig.RocketConfig.atmosphereLeave) {
                this.openPlanetSelectionGui();
                this.setPhase(3);
            }
        }
        if (this.method_5777(class_3486.field_15518)) {
            this.explode(0.45f);
        }
    }

    @Override
    public void drop() {
        if (!this.isFlying()) {
            super.drop();
        }
    }

    public void openPlanetSelectionGui() {
        if (!this.method_5782()) {
            if (!this.method_37908().field_9236 && this.lastRider != null) {
                ModCriteria.ROCKET_DESTROYED.trigger((class_3222)this.lastRider);
            }
            this.explode();
            return;
        }
        this.method_5685().forEach(passenger -> {
            if (passenger instanceof class_3222) {
                class_3222 player = (class_3222)passenger;
                if (!(player.field_7512 instanceof PlanetSelectionMenu)) {
                    player.method_7346();
                    if (!this.method_37908().field_9236) {
                        MenuHooks.openMenu((class_3222)player, (ExtraDataMenuProvider)new PlanetSelectionMenuProvider(this.getTier()));
                        Rocket.stopRocketSoundForRider(player);
                    }
                }
            }
        });
    }

    public void spawnSmokeParticles() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 pos = this.method_19538();
            ModUtils.spawnForcedParticles(serverWorld, class_2398.field_17430, pos.method_10216(), pos.method_10214(), pos.method_10215(), 6, 0.1, 0.1, 0.1, 0.023);
        }
    }

    public void spawnAfterburnerParticles() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 pos = this.method_19538();
            ModUtils.spawnForcedParticles(serverWorld, (class_2400)ModParticleTypes.LARGE_FLAME.get(), pos.method_10216(), pos.method_10214(), pos.method_10215(), 20, 0.1, 0.1, 0.1, 0.001);
            ModUtils.spawnForcedParticles(serverWorld, (class_2400)ModParticleTypes.LARGE_SMOKE.get(), pos.method_10216(), pos.method_10214(), pos.method_10215(), 10, 0.1, 0.1, 0.1, 0.001);
        }
    }

    private void burnEntitiesUnderRocket() {
        List entities = this.method_37908().method_8390(class_1309.class, this.method_5829().method_1009(2.0, 30.0, 2.0).method_989(0.0, -37.0, 0.0), entity -> true);
        for (class_1309 entity2 : entities) {
            if (NetheriteSpaceSuit.hasFullSet(entity2) || entity2.method_5854() != null && entity2.method_5854().equals((Object)this) || !VehiclesConfig.RocketConfig.entitiesBurnUnderRocket || entity2.method_5753()) continue;
            entity2.method_5639(10);
            entity2.method_5643(ModDamageSources.of(this.method_37908(), ModDamageSources.ROCKET_FLAMES), 10.0f);
            class_2680 belowBlock = this.method_37908().method_8320(entity2.method_24515().method_10074());
            if (!belowBlock.method_26234((class_1922)this.method_37908(), entity2.method_24515().method_10074()) || !belowBlock.method_26215()) continue;
            this.method_37908().method_8501(entity2.method_24515(), class_2246.field_10036.method_9564());
        }
    }

    private void travel() {
        double multiplier;
        double d = multiplier = this.getTankHolder().getFluid().method_15791(ModTags.EFFICIENT_FUELS) ? 2.5 : 1.0;
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, VehiclesConfig.RocketConfig.acceleration * multiplier, 0.0));
        }
        if (this.method_18798().method_10214() > VehiclesConfig.RocketConfig.maxSpeed * multiplier) {
            this.method_18800(0.0, VehiclesConfig.RocketConfig.maxSpeed, 0.0);
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    public void initiateLaunchSequenceFromServer() {
        this.initiateLaunchSequence();
        this.method_37908().method_8396(null, this.method_24515(), (class_3414)ModSoundEvents.ROCKET_LAUNCH_SOUND_EVENT.get(), class_3419.field_15256, 1.0f, 1.0f);
    }

    public void initiateLaunchSequence() {
        this.setFlying(true);
        this.setCountdownTicks(VehiclesConfig.RocketConfig.countDownTicks);
        this.method_32317(Integer.MAX_VALUE);
        this.getTank().extractFluid(FluidHooks.newFluidHolder((class_3611)this.getTankHolder().getFluid(), (long)Rocket.getRequiredAmountForLaunch(this.getTankHolder().getFluid()), (class_2487)this.getTankHolder().getCompound()), false);
    }

    public boolean hasLaunchPad() {
        return (Boolean)this.field_6011.method_12789(HAS_LAUNCH_PAD);
    }

    public void setLaunchPad(boolean value) {
        this.field_6011.method_12778(HAS_LAUNCH_PAD, (Object)value);
    }

    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(FLYING);
    }

    public void setFlying(boolean value) {
        this.field_6011.method_12778(FLYING, (Object)value);
    }

    public int getCountdownTicks() {
        return (Integer)this.field_6011.method_12789(COUNTDOWN_TICKS);
    }

    public void setCountdownTicks(int value) {
        this.field_6011.method_12778(COUNTDOWN_TICKS, (Object)value);
    }

    public int getPhase() {
        return (Integer)this.field_6011.method_12789(PHASE);
    }

    public void setPhase(int value) {
        this.field_6011.method_12778(PHASE, (Object)value);
    }

    public int getTier() {
        return (Integer)this.field_6011.method_12789(TIER);
    }

    public void setTier(int value) {
        this.field_6011.method_12778(TIER, (Object)value);
    }

    public int getCountdownSeconds() {
        return (this.getCountdownTicks() + 20) / 20;
    }

    @Override
    public boolean doHighFov() {
        return true;
    }

    @Override
    public boolean fullyConcealsRider() {
        return true;
    }

    @Override
    public boolean canRiderTakeFallDamage() {
        return false;
    }

    @Override
    public boolean renderPlanetBar() {
        return true;
    }

    @Override
    public void doGravity() {
        class_2680 belowBlock = this.method_37908().method_8320(this.method_24515());
        if (belowBlock.method_26204() instanceof LaunchPad && ((LocationState)((Object)belowBlock.method_11654(LaunchPad.LOCATION))).equals((Object)LocationState.CENTER)) {
            return;
        }
        if (this.getPhase() == 0 || this.getPhase() == 1) {
            super.doGravity();
        }
    }

    private void explodeIfStopped() {
        if (this.method_18798().method_10214() < 0.05 && this.method_18798().method_10214() > -1.0E-6) {
            this.explode();
        }
    }

    public void explode() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            float tierMultiplier = 1.0f + (float)this.getTier() * 0.25f;
            if (this.method_18798().method_10214() > 4.0) {
                tierMultiplier *= 1.25f;
            }
            if (this.method_23318() <= (double)VehiclesConfig.RocketConfig.atmosphereLeave) {
                serverWorld.method_18456().forEach(Rocket::stopRocketSoundForRider);
            }
            this.explode(tierMultiplier);
        }
    }

    public void rotateRocketAndPassengers(float rotation) {
        ModUtils.rotateVehicleYaw(this, this.method_36454() + rotation);
        for (class_1297 passenger : this.method_5685()) {
            passenger.method_36456(passenger.method_36454() + rotation);
        }
    }
}

