/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.things.items.generic;

import com.glisco.things.Things;
import com.glisco.things.items.ItemWithExtendableTooltip;
import com.glisco.things.mixin.access.ContainerLockAccessor;
import com.glisco.things.mixin.access.LockableContainerBlockEntityAccessor;
import io.wispforest.owo.itemgroup.OwoItemSettings;
import io.wispforest.owo.nbt.NbtKey;
import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1273;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class ContainerKeyItem
extends ItemWithExtendableTooltip {
    private static final NbtKey<Integer> LOCK_KEY = new NbtKey("Lock", NbtKey.Type.INT);

    public ContainerKeyItem() {
        super((class_1792.class_1793)new OwoItemSettings().group(Things.THINGS_GROUP).maxCount(1));
    }

    public class_1269 method_7884(class_1838 context) {
        if (!context.method_8036().method_5715()) {
            return class_1269.field_5811;
        }
        ContainerKeyItem.createKey(context.method_8041(), context.method_8045().field_9229);
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1799 stack = context.method_8041();
        if (!(world.method_8321(pos) instanceof class_2624)) {
            return class_1269.field_5811;
        }
        String existingLock = ContainerKeyItem.getExistingLock(world, pos);
        if (existingLock.isEmpty()) {
            ContainerKeyItem.setLock((class_2624)world.method_8321(pos), String.valueOf(stack.get(LOCK_KEY)));
            if (world.field_9236) {
                ContainerKeyItem.sendLockedState(context, true);
            }
            return class_1269.field_5812;
        }
        if (existingLock.equals(String.valueOf(stack.get(LOCK_KEY)))) {
            ContainerKeyItem.setLock((class_2624)world.method_8321(pos), "");
            if (world.field_9236) {
                ContainerKeyItem.sendLockedState(context, false);
            }
            return class_1269.field_5812;
        }
        if (world.field_9236) {
            context.method_8036().method_5783(class_3417.field_14731, 1.0f, 1.0f);
            class_5250 containerName = (class_5250)((class_2624)context.method_8045().method_8321(context.method_8037())).method_5476();
            context.method_8036().method_7353((class_2561)containerName.method_10852((class_2561)class_2561.method_43470((String)" is locked with another key!")), true);
        }
        return class_1269.field_5812;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        ContainerKeyItem.createKey(stack, world.field_9229);
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (stack.has(LOCK_KEY)) {
            tooltip.add((class_2561)class_2561.method_43470((String)("\u00a79Key: \u00a77#" + Integer.toHexString((Integer)stack.get(LOCK_KEY)))));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    private static void createKey(class_1799 stack, class_5819 random) {
        if (stack.has(LOCK_KEY)) {
            return;
        }
        stack.put(LOCK_KEY, (Object)random.method_43048(200000));
    }

    private static String getExistingLock(class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        String existingLock = ContainerKeyItem.getKey(blockEntity);
        class_2595 chestNeighbor = ContainerKeyItem.maybeGetOtherChest(blockEntity);
        if (existingLock.isEmpty() && chestNeighbor != null) {
            if (ContainerKeyItem.getKey((class_2586)chestNeighbor).isEmpty()) {
                return existingLock;
            }
            return ContainerKeyItem.getKey((class_2586)chestNeighbor);
        }
        return existingLock;
    }

    private static void sendLockedState(class_1838 ctx, boolean locked) {
        ctx.method_8036().method_5783(class_3417.field_14731, 1.0f, 1.0f);
        class_5250 containerName = (class_5250)((class_2624)ctx.method_8045().method_8321(ctx.method_8037())).method_5476();
        ctx.method_8036().method_7353((class_2561)containerName.method_10852((class_2561)class_2561.method_43470((String)(locked ? " locked!" : " unlocked!"))), true);
    }

    private static void setLock(class_2624 entity, String lock) {
        class_2487 lockNbt = new class_2487();
        lockNbt.method_10582("Lock", lock);
        class_1273 containerLock = lock.isEmpty() ? class_1273.field_5817 : class_1273.method_5473((class_2487)lockNbt);
        ((LockableContainerBlockEntityAccessor)entity).things$setLock(containerLock);
        class_2595 doubleChestNeighbor = ContainerKeyItem.maybeGetOtherChest((class_2586)entity);
        if (doubleChestNeighbor == null) {
            return;
        }
        ((LockableContainerBlockEntityAccessor)doubleChestNeighbor).things$setLock(containerLock);
    }

    private static String getKey(class_2586 be) {
        return ((ContainerLockAccessor)((LockableContainerBlockEntityAccessor)be).things$getLock()).things$getKey();
    }

    @Nullable
    private static class_2595 maybeGetOtherChest(class_2586 potentialChest) {
        if (!(potentialChest instanceof class_2595)) {
            return null;
        }
        if (potentialChest.method_11010().method_11654((class_2769)class_2741.field_12506) == class_2745.field_12569) {
            return null;
        }
        return (class_2595)potentialChest.method_10997().method_8321(potentialChest.method_11016().method_10093(class_2281.method_9758((class_2680)potentialChest.method_11010())));
    }
}

