/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.things.mixin;

import com.glisco.things.Things;
import com.glisco.things.items.ThingsItems;
import com.glisco.things.misc.ExtendedStatusEffectInstance;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2499;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"takeShieldHit"}, at={@At(value="HEAD")})
    public void onShieldHit(class_1309 attacker, CallbackInfo ci) {
        class_1309 user = (class_1309)this;
        if (!Things.isShield(user.method_6030().method_7909())) {
            return;
        }
        if (!class_1890.method_22445((class_2499)user.method_6030().method_7921()).containsKey(Things.RETRIBUTION)) {
            return;
        }
        user.method_6092(new class_1293(class_1294.field_5910, 40, 0));
    }

    @Inject(method={"blockedByShield"}, at={@At(value="RETURN")})
    public void onShieldBlock(class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        class_1309 user = (class_1309)this;
        if (!Things.isShield(user.method_6030().method_7909())) {
            return;
        }
        if (!class_1890.method_22445((class_2499)user.method_6030().method_7921()).containsKey(Things.RETRIBUTION)) {
            return;
        }
        user.method_6092(new class_1293(class_1294.field_5910, 40, 0));
    }

    @ModifyVariable(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;hasStatusEffect(Lnet/minecraft/entity/effect/StatusEffect;)Z", ordinal=1), ordinal=1)
    public float waxGlandWater(float j) {
        class_1309 entity = (class_1309)this;
        if (!(entity instanceof class_1657)) {
            return j;
        }
        class_1657 player = (class_1657)entity;
        if (!((TrinketComponent)TrinketsApi.getTrinketComponent((class_1309)player).get()).isEquipped(ThingsItems.ENCHANTED_WAX_GLAND)) {
            return j;
        }
        return j * Things.CONFIG.waxGlandMultiplier();
    }

    @ModifyArg(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;updateVelocity(FLnet/minecraft/util/math/Vec3d;)V"))
    public float waxGlandLava(float speed) {
        class_1309 entity = (class_1309)this;
        if (!(entity instanceof class_1657)) {
            return speed;
        }
        class_1657 player = (class_1657)entity;
        if (((TrinketComponent)TrinketsApi.getTrinketComponent((class_1309)player).get()).isEquipped(ThingsItems.ENCHANTED_WAX_GLAND) && ((TrinketComponent)TrinketsApi.getTrinketComponent((class_1309)player).get()).isEquipped(ThingsItems.HADES_CRYSTAL)) {
            int depthStrider = class_1890.method_8232((class_1309)player);
            return 0.0175f * Things.CONFIG.waxGlandMultiplier() + 0.1f * (float)depthStrider;
        }
        return speed;
    }

    @ModifyVariable(method={"handleFallDamage"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/LivingEntity;computeFallDamage(FF)I"))
    private int decreaseFallDamage(int originalFallDamage) {
        if (Things.getTrinkets((class_1309)this).isEquipped(ThingsItems.SHOCK_ABSORBER)) {
            return originalFallDamage / 4;
        }
        return originalFallDamage;
    }

    @ModifyArg(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"))
    private float decreaseKineticDamage(class_1282 source, float damage) {
        if (source.method_48792() != this.method_37908().method_48963().method_48828().method_48792()) {
            return damage;
        }
        if (Things.getTrinkets((class_1309)this).isEquipped(ThingsItems.SHOCK_ABSORBER)) {
            return damage / 4.0f;
        }
        return damage;
    }

    @ModifyArg(method={"readCustomDataFromNbt"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"), index=1)
    private Object attachPlayerToEffect(Object effect) {
        ((ExtendedStatusEffectInstance)effect).things$setAttachedEntity((class_1309)this);
        return effect;
    }

    @Inject(method={"onStatusEffectApplied"}, at={@At(value="HEAD")})
    private void attachPlayerToEffect(class_1293 effect, class_1297 source, CallbackInfo ci) {
        ((ExtendedStatusEffectInstance)effect).things$setAttachedEntity((class_1309)this);
    }

    @Inject(method={"onStatusEffectUpgraded"}, at={@At(value="HEAD")})
    private void attachPlayerToEffect(class_1293 effect, boolean reapplyEffect, class_1297 source, CallbackInfo ci) {
        ((ExtendedStatusEffectInstance)effect).things$setAttachedEntity((class_1309)this);
    }
}

