/*
 * Decompiled with CFR 0.152.
 */
package ml.pkom.easyapi.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import ml.pkom.easyapi.FileControl;
import ml.pkom.easyapi.config.Config;

public class JsonConfig
extends Config {
    public JsonConfig(File file) {
        super(file);
    }

    public JsonConfig(String file) {
        super(file);
    }

    public JsonConfig() {
    }

    public JsonConfig(Config config) {
        super(config);
    }

    @Override
    public boolean load(File file) {
        try {
            String configData = FileControl.fileReadContents(file);
            Gson gson = new Gson();
            Type jsonMap = new TypeToken<LinkedHashMap<String, Object>>(){}.getType();
            this.configMap = (Map)gson.fromJson(configData, jsonMap);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean save(File file, boolean pretty) {
        try {
            String configData = this.toJson(pretty);
            FileControl.fileWriteContents(file, configData);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toJson(boolean pretty) {
        try {
            Gson gson = new Gson();
            if (pretty) {
                gson = new GsonBuilder().setPrettyPrinting().create();
            }
            String configData = gson.toJson((Object)this.configMap);
            return configData;
        }
        catch (Exception e) {
            return null;
        }
    }
}

