/*
 * Decompiled with CFR 0.152.
 */
package ml.pkom.mcpitanlibarch;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ml.pkom.easyapi.config.Config;
import ml.pkom.easyapi.config.JsonConfig;
import ml.pkom.mcpitanlibarch.api.util.PlatformUtil;

public class MCPitanLibarch {
    public static final String MOD_ID = "mcpitanlibarch";
    private static final File configFile = new File(PlatformUtil.getConfigFolder().toFile(), "mcpitanlibarch/blacklist.json");
    public static Config config = new JsonConfig();
    private static boolean configLoaded = false;
    public static List<String> itemBlackList = new ArrayList<String>();
    public static List<String> blockBlackList = new ArrayList<String>();

    public static void init() {
        MCPitanLibarch.configInit();
    }

    public static void configInit() {
        try {
            if (configLoaded) {
                return;
            }
            configLoaded = true;
            if (!configFile.getParentFile().exists() && !configFile.getParentFile().mkdirs()) {
                return;
            }
            config.setString("item", "examplemod:hogehoge_item,examplemod:fuga_item");
            config.setString("block", "examplemod:hogehoge_block,examplemod:fuga_block");
            if (configFile.exists()) {
                config.load(configFile);
            }
            if (MCPitanLibarch.config.configMap.containsKey("item")) {
                itemBlackList.addAll(Arrays.asList(config.getString("item").split(",")));
            }
            if (MCPitanLibarch.config.configMap.containsKey("block")) {
                blockBlackList.addAll(Arrays.asList(config.getString("block").split(",")));
            }
            config.save(configFile);
        }
        catch (Exception e) {
            System.out.println("MCPitanLib: Cannot save config file");
        }
    }
}

