/*
 * Decompiled with CFR 0.152.
 */
package ml.pkom.mcpitanlibarch.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import ml.pkom.mcpitanlibarch.api.timer.MinecraftServerTimerAccess;
import ml.pkom.mcpitanlibarch.api.timer.TimerItem;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public class MinecraftServerTimer
implements MinecraftServerTimerAccess {
    @Unique
    private final List<TimerItem> timerItems = new ArrayList<TimerItem>();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        if (this.timerItems.isEmpty()) {
            return;
        }
        ArrayList<TimerItem> items = new ArrayList<TimerItem>(this.timerItems);
        for (TimerItem item : items) {
            if (--item.ticksUntilSomething != 0L || !item.executeSupplier.get().booleanValue()) continue;
            this.timerItems.remove(item);
        }
    }

    @Override
    public void addTimer(long ticksUntilSomething, Supplier<Boolean> executeSupplier) {
        this.timerItems.add(new TimerItem(ticksUntilSomething, executeSupplier));
    }
}

