/*
 * Decompiled with CFR 0.152.
 */
package ml.pkom.mcpitanlibarch.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import ml.pkom.mcpitanlibarch.api.timer.ServerWorldTimerAccess;
import ml.pkom.mcpitanlibarch.api.timer.TimerItem;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3218.class})
public class ServerWorldTimer
implements ServerWorldTimerAccess {
    @Unique
    private final List<TimerItem> timerItems = new ArrayList<TimerItem>();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        if (this.timerItems.isEmpty()) {
            return;
        }
        ArrayList<TimerItem> items = new ArrayList<TimerItem>(this.timerItems);
        for (TimerItem item : items) {
            if (--item.ticksUntilSomething != 0L || !item.executeSupplier.get().booleanValue()) continue;
            this.timerItems.remove(item);
        }
    }

    @Override
    public void addTimer(long ticksUntilSomething, Supplier<Boolean> executeSupplier) {
        this.timerItems.add(new TimerItem(ticksUntilSomething, executeSupplier));
    }
}

