/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.joystick;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import dev.isxander.controlify.bindings.ControllerBindings;
import dev.isxander.controlify.controller.AbstractController;
import dev.isxander.controlify.controller.joystick.JoystickConfig;
import dev.isxander.controlify.controller.joystick.JoystickController;
import dev.isxander.controlify.controller.joystick.JoystickState;
import dev.isxander.controlify.controller.joystick.mapping.JoystickMapping;
import dev.isxander.controlify.controller.joystick.mapping.RPJoystickMapping;
import dev.isxander.controlify.controller.joystick.mapping.UnmappedJoystickMapping;
import dev.isxander.controlify.driver.SDL2NativesManager;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.rumble.RumbleManager;
import dev.isxander.controlify.utils.Log;
import io.github.libsdl4j.api.error.SdlError;
import io.github.libsdl4j.api.joystick.SDL_Joystick;
import io.github.libsdl4j.api.joystick.SdlJoystick;
import java.util.Objects;

public class SingleJoystickController
extends AbstractController<JoystickState, JoystickConfig>
implements JoystickController<JoystickConfig> {
    private JoystickState state = JoystickState.EMPTY;
    private JoystickState prevState = JoystickState.EMPTY;
    private final JoystickMapping mapping = Objects.requireNonNull(RPJoystickMapping.fromType(this));
    private final SDL_Joystick ptrJoystick;
    private RumbleManager rumbleManager;
    private boolean rumbleSupported;

    public SingleJoystickController(int joystickId, ControllerHIDService.ControllerHIDInfo hidInfo) {
        super(joystickId, hidInfo);
        this.config = new JoystickConfig(this);
        this.defaultConfig = new JoystickConfig(this);
        this.ptrJoystick = SDL2NativesManager.isLoaded() ? SdlJoystick.SDL_JoystickOpen((int)joystickId) : new SDL_Joystick();
        this.rumbleSupported = SDL2NativesManager.isLoaded() && SdlJoystick.SDL_JoystickHasRumble((SDL_Joystick)this.ptrJoystick);
        this.rumbleManager = new RumbleManager(this);
        this.bindings = new ControllerBindings<JoystickState>(this);
        ((JoystickConfig)this.config).validateRadialActions(this.bindings);
        ((JoystickConfig)this.defaultConfig).validateRadialActions(this.bindings);
    }

    @Override
    public JoystickState state() {
        return this.state;
    }

    @Override
    public JoystickState prevState() {
        return this.prevState;
    }

    @Override
    public void updateState() {
        this.prevState = this.state;
        this.state = JoystickState.fromJoystick(this, this.joystickId);
    }

    @Override
    public void clearState() {
        this.state = JoystickState.empty(this);
    }

    @Override
    public JoystickMapping mapping() {
        return this.mapping;
    }

    @Override
    public int axisCount() {
        return this.mapping().axes().length;
    }

    @Override
    public int buttonCount() {
        return this.mapping.buttons().length;
    }

    @Override
    public int hatCount() {
        return this.mapping.hats().length;
    }

    @Override
    public int joystickId() {
        return this.joystickId;
    }

    @Override
    public void setConfig(Gson gson, JsonElement json) {
        super.setConfig(gson, json);
        ((JoystickConfig)this.config).setup(this);
        JoystickMapping joystickMapping = this.mapping();
        if (joystickMapping instanceof UnmappedJoystickMapping) {
            UnmappedJoystickMapping unmapped = (UnmappedJoystickMapping)joystickMapping;
            for (int i = 0; i < unmapped.axes().length; ++i) {
                unmapped.axes()[i].setTriggerAxis(((JoystickConfig)this.config).isTriggerAxis(i));
            }
        } else {
            for (int i = 0; i < this.mapping().axes().length; ++i) {
                ((JoystickConfig)this.config).setTriggerAxis(i, false);
            }
        }
    }

    @Override
    public boolean setRumble(float strongMagnitude, float weakMagnitude) {
        if (!this.supportsRumble()) {
            return false;
        }
        if (SdlJoystick.SDL_JoystickRumbleTriggers((SDL_Joystick)this.ptrJoystick, (short)((short)(strongMagnitude * 65535.0f)), (short)((short)(weakMagnitude * 65535.0f)), (int)1) != 0) {
            Log.LOGGER.error("Could not rumble controller " + this.name() + ": " + SdlError.SDL_GetError());
            return false;
        }
        return true;
    }

    @Override
    public boolean supportsRumble() {
        return this.rumbleSupported;
    }

    @Override
    public RumbleManager rumbleManager() {
        return this.rumbleManager;
    }

    @Override
    public void close() {
        if (!this.ptrJoystick.equals((Object)new SDL_Joystick())) {
            SdlJoystick.SDL_JoystickClose((SDL_Joystick)this.ptrJoystick);
        }
        this.rumbleSupported = false;
        this.rumbleManager = null;
    }
}

