/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver;

import dev.isxander.controlify.controller.gamepad.GamepadState;
import dev.isxander.controlify.driver.BasicGamepadInputDriver;
import dev.isxander.controlify.driver.GyroDriver;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.utils.Log;
import java.util.Arrays;

public class SteamDeckDriver
implements GyroDriver,
BasicGamepadInputDriver {
    private static final int cInputRecordLen = 8;
    private static final int cByteposInput = 4;
    private static final byte[] startMarker = new byte[]{1, 0, 9, 64};
    private final HIDDevice hidDevice;
    private int interval = 0;
    private GamepadState.GyroState gyroDelta = new GamepadState.GyroState();
    private BasicGamepadInputDriver.BasicGamepadState basicGamepadState = new BasicGamepadInputDriver.BasicGamepadState(GamepadState.AxesState.EMPTY, GamepadState.ButtonState.EMPTY);

    public SteamDeckDriver(HIDDevice hidDevice) {
        this.hidDevice = hidDevice;
        this.hidDevice.open();
    }

    @Override
    public void update() {
        if (this.interval == 0) {
            this.keepAlive();
        }
        this.interval = (this.interval + 1) % 120;
        byte[] data = new byte[64];
        int readCnt = this.hidDevice.read(data);
        if (readCnt == 0) {
            Log.LOGGER.warn("No data available.");
        }
        if (readCnt == -1) {
            Log.LOGGER.warn("Error reading data.");
        }
        System.out.println(Arrays.toString(data));
        if (!this.checkData(data, readCnt)) {
            return;
        }
        Frame frame = Frame.fromBytes(data);
        System.out.println(frame);
        this.readFrame(frame);
    }

    private void keepAlive() {
    }

    private void readFrame(Frame frame) {
        this.gyroDelta = new GamepadState.GyroState(frame.gyroAxisFrontToBack, frame.gyroAxisTopToBottom, frame.gyroAxisRightToLeft);
        this.basicGamepadState = new BasicGamepadInputDriver.BasicGamepadState(new GamepadState.AxesState(frame.leftStickX, frame.leftStickY, frame.rightStickX, frame.rightStickY, frame.l2Analog, frame.r2Analog), new GamepadState.ButtonState((frame.buttons1BitMap >> 7 & 1) == 1, (frame.buttons1BitMap >> 5 & 1) == 1, (frame.buttons1BitMap >> 6 & 1) == 1, (frame.buttons1BitMap >> 4 & 1) == 1, (frame.buttons1BitMap >> 3 & 1) == 1, (frame.buttons1BitMap >> 2 & 1) == 1, (frame.buttons1BitMap >> 12 & 1) == 1, (frame.buttons1BitMap >> 14 & 1) == 1, (frame.buttons1BitMap >> 13 & 1) == 1, false, false, false, false, (frame.buttons1BitMap >> 1 & 1) == 1, (frame.buttons1BitMap >> 0 & 1) == 1));
    }

    private boolean checkData(byte[] data, int readCnt) {
        int first4Bytes = -65534;
        int first4BytesAlt = -65535;
        boolean inputFail = readCnt < data.length;
        boolean startMarkerFail = false;
        if (!inputFail) {
            boolean bl = startMarkerFail = this.first4Bytes(data) != first4Bytes;
            if (startMarkerFail && this.first4Bytes(data) == first4BytesAlt) {
                startMarkerFail = false;
                int i = 4;
                int j = 0;
                while (j < startMarker.length) {
                    if (data[i] != startMarker[j]) {
                        startMarkerFail = true;
                        break;
                    }
                    ++j;
                    i += 8;
                }
            }
        }
        return !inputFail && !startMarkerFail;
    }

    private int first4Bytes(byte[] data) {
        return data[0] << 24 | data[1] << 16 | data[2] << 8 | data[3];
    }

    @Override
    public GamepadState.GyroStateC getGyroState() {
        return this.gyroDelta;
    }

    @Override
    public BasicGamepadInputDriver.BasicGamepadState getBasicGamepadState() {
        return this.basicGamepadState;
    }

    @Override
    public boolean isGyroSupported() {
        return true;
    }

    @Override
    public void close() {
        this.hidDevice.close();
    }

    @Override
    public String getBasicGamepadDetails() {
        return "SteamDeck HIDAPI";
    }

    @Override
    public String getGyroDetails() {
        return "SteamDeck HIDAPI";
    }

    public static boolean isSteamDeck(int vendorId, int productId) {
        return vendorId == 10462 && productId == 4613;
    }

    private record Frame(int header, int increment, int buttons1BitMap, int buttons2BitMap, short leftTrackpadX, short leftTrackpadY, short rightTrackpadX, short rightTrackpadY, short accelAxisRightToLeft, short accelAxisTopToBottom, short accelAxisFrontToBack, short gyroAxisRightToLeft, short gyroAxisTopToBottom, short gyroAxisFrontToBack, short unknown1, short unknown2, short unknown3, short unknown4, short l2Analog, short r2Analog, short leftStickX, short leftStickY, short rightStickX, short rightStickY, short leftTrackpadPushForce, short rightTrackpadPushForce, short leftStickTouchCoverage, short rightStickTouchCoverage) {
        public static Frame fromBytes(byte[] bytes) {
            return new Frame(bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3], bytes[4] << 24 | bytes[5] << 16 | bytes[6] << 8 | bytes[7], bytes[8] << 24 | bytes[9] << 16 | bytes[10] << 8 | bytes[11], bytes[12] << 24 | bytes[13] << 16 | bytes[14] << 8 | bytes[15], (short)(bytes[16] << 8 | bytes[17]), (short)(bytes[18] << 8 | bytes[19]), (short)(bytes[20] << 8 | bytes[21]), (short)(bytes[22] << 8 | bytes[23]), (short)(bytes[24] << 8 | bytes[25]), (short)(bytes[26] << 8 | bytes[27]), (short)(bytes[28] << 8 | bytes[29]), (short)(bytes[30] << 8 | bytes[31]), (short)(bytes[32] << 8 | bytes[33]), (short)(bytes[34] << 8 | bytes[35]), (short)(bytes[36] << 8 | bytes[37]), (short)(bytes[38] << 8 | bytes[39]), (short)(bytes[40] << 8 | bytes[41]), (short)(bytes[42] << 8 | bytes[43]), (short)(bytes[44] << 8 | bytes[45]), (short)(bytes[46] << 8 | bytes[47]), (short)(bytes[48] << 8 | bytes[49]), (short)(bytes[50] << 8 | bytes[51]), (short)(bytes[52] << 8 | bytes[53]), (short)(bytes[54] << 8 | bytes[55]), (short)(bytes[56] << 8 | bytes[57]), (short)(bytes[58] << 8 | bytes[59]), (short)(bytes[60] << 8 | bytes[61]), (short)(bytes[62] << 8 | bytes[63]));
        }
    }
}

