/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.guide;

import dev.isxander.controlify.api.bind.BindRenderer;
import dev.isxander.controlify.gui.DrawSize;
import dev.isxander.controlify.gui.guide.GuideAction;
import dev.isxander.controlify.gui.layout.RenderComponent;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class GuideActionRenderer<T>
implements RenderComponent {
    private final GuideAction<T> guideAction;
    private final boolean rtl;
    private final boolean textContrast;
    private Optional<class_2561> name = Optional.empty();

    public GuideActionRenderer(GuideAction<T> action, boolean rtl, boolean textContrast) {
        this.guideAction = action;
        this.rtl = rtl;
        this.textContrast = textContrast;
    }

    @Override
    public void render(class_332 graphics, int x, int y, float deltaTime) {
        if (!this.isVisible()) {
            return;
        }
        class_327 font = class_310.method_1551().field_1772;
        BindRenderer renderer = this.guideAction.binding().renderer();
        DrawSize drawSize = renderer.size();
        int textWidth = font.method_27525((class_5348)this.name.get());
        renderer.render(graphics, x + (!this.rtl ? 0 : textWidth + 2), y + drawSize.height() / 2);
        int textX = x + (this.rtl ? 0 : drawSize.width() + 2);
        int n = y + drawSize.height() / 2;
        Objects.requireNonNull(font);
        int textY = n - 9 / 2;
        if (this.textContrast) {
            Objects.requireNonNull(font);
            graphics.method_25294(textX - 1, textY - 1, textX + textWidth + 1, textY + 9 + 1, Integer.MIN_VALUE);
        }
        graphics.method_51439(font, this.name.get(), textX, textY, 0xFFFFFF, false);
    }

    @Override
    public Vector2ic size() {
        DrawSize bindSize = this.guideAction.binding().renderer().size();
        class_327 font = class_310.method_1551().field_1772;
        int n = bindSize.width() + 2 + this.name.map(arg_0 -> ((class_327)font).method_27525(arg_0)).orElse(-2);
        int n2 = bindSize.height();
        Objects.requireNonNull(font);
        return new Vector2i(n, Math.max(n2, 9));
    }

    @Override
    public boolean isVisible() {
        return this.name.isPresent() && !this.guideAction.binding().isUnbound();
    }

    public void updateName(T ctx) {
        this.name = this.guideAction.name().supply(ctx);
    }
}

