/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop;

import com.google.common.collect.ImmutableList;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.bindings.ControllerBindings;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.gamepad.GamepadState;
import dev.isxander.controlify.mixins.feature.screenop.ScreenAccessor;
import dev.isxander.controlify.mixins.feature.screenop.vanilla.TabNavigationBarAccessor;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ComponentProcessorProvider;
import dev.isxander.controlify.screenop.CustomFocus;
import dev.isxander.controlify.screenop.ScreenControllerEventListener;
import dev.isxander.controlify.sound.ControlifySounds;
import dev.isxander.controlify.utils.NavigationHelper;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import dev.isxander.controlify.virtualmouse.VirtualMouseHandler;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8028;
import net.minecraft.class_8087;
import net.minecraft.class_8089;

public class ScreenProcessor<T extends class_437> {
    public final T screen;
    protected final NavigationHelper navigationHelper = new NavigationHelper(10, 3);
    protected static final class_310 minecraft = class_310.method_1551();

    public ScreenProcessor(T screen) {
        this.screen = screen;
        ControlifyEvents.VIRTUAL_MOUSE_TOGGLED.register(this::onVirtualMouseToggled);
    }

    public void onControllerUpdate(Controller<?, ?> controller) {
        if (!Controlify.instance().virtualMouseHandler().isVirtualMouseEnabled()) {
            if (!this.handleComponentNavOverride(controller)) {
                this.handleComponentNavigation(controller);
            }
            if (!this.handleComponentButtonOverride(controller)) {
                this.handleButtons(controller);
            }
        } else {
            this.handleScreenVMouse(controller, Controlify.instance().virtualMouseHandler());
        }
        this.handleTabNavigation(controller);
        T t = this.screen;
        if (t instanceof ScreenControllerEventListener) {
            ScreenControllerEventListener eventListener = (ScreenControllerEventListener)t;
            eventListener.onControllerInput(controller);
        }
    }

    public void render(Controller<?, ?> controller, class_332 graphics, float tickDelta) {
        VirtualMouseHandler vmouse = Controlify.instance().virtualMouseHandler();
        this.render(controller, graphics, tickDelta, vmouse.isVirtualMouseEnabled() ? Optional.of(vmouse) : Optional.empty());
    }

    public void onInputModeChanged(InputMode mode) {
        switch (mode) {
            case KEYBOARD_MOUSE: {
                boolean shouldKeepFocus = this.getFocusTree().stream().anyMatch(component -> ComponentProcessorProvider.provide(component).shouldKeepFocusOnKeyboardMode(this));
                if (shouldKeepFocus) break;
                ((ScreenAccessor)this.screen).invokeClearFocus();
                break;
            }
            case CONTROLLER: 
            case MIXED: {
                if (Controlify.instance().virtualMouseHandler().isVirtualMouseEnabled()) break;
                this.setInitialFocus();
            }
        }
    }

    protected void handleComponentNavigation(Controller<?, ?> controller) {
        class_8016 path;
        if (this.screen.method_25399() == null) {
            this.setInitialFocus();
        }
        List<class_364> focuses = List.copyOf(this.getFocusTree());
        ScreenAccessor accessor = (ScreenAccessor)this.screen;
        boolean repeatEventAvailable = this.navigationHelper.canNavigate();
        ControllerBindings<?> bindings = controller.bindings();
        class_8023.class_8024 event = null;
        if (bindings.GUI_NAVI_RIGHT.held() && (repeatEventAvailable || !bindings.GUI_NAVI_RIGHT.prevHeld())) {
            event = accessor.invokeCreateArrowEvent(class_8028.field_41829);
            if (!bindings.GUI_NAVI_RIGHT.prevHeld()) {
                this.navigationHelper.reset();
            }
        } else if (bindings.GUI_NAVI_LEFT.held() && (repeatEventAvailable || !bindings.GUI_NAVI_LEFT.prevHeld())) {
            event = accessor.invokeCreateArrowEvent(class_8028.field_41828);
            if (!bindings.GUI_NAVI_LEFT.prevHeld()) {
                this.navigationHelper.reset();
            }
        } else if (bindings.GUI_NAVI_UP.held() && (repeatEventAvailable || !bindings.GUI_NAVI_UP.prevHeld())) {
            event = accessor.invokeCreateArrowEvent(class_8028.field_41826);
            if (!bindings.GUI_NAVI_UP.prevHeld()) {
                this.navigationHelper.reset();
            }
        } else if (bindings.GUI_NAVI_DOWN.held() && (repeatEventAvailable || !bindings.GUI_NAVI_DOWN.prevHeld())) {
            event = accessor.invokeCreateArrowEvent(class_8028.field_41827);
            if (!bindings.GUI_NAVI_DOWN.prevHeld()) {
                this.navigationHelper.reset();
            }
        } else {
            Object obj = controller.state();
            if (obj instanceof GamepadState) {
                GamepadState state = (GamepadState)obj;
                obj = controller.prevState();
                if (obj instanceof GamepadState) {
                    GamepadState prevState = (GamepadState)obj;
                    if (state.gamepadButtons().dpadRight() && (repeatEventAvailable || !prevState.gamepadButtons().dpadRight())) {
                        event = accessor.invokeCreateArrowEvent(class_8028.field_41829);
                        if (!prevState.gamepadButtons().dpadRight()) {
                            this.navigationHelper.reset();
                        }
                    } else if (state.gamepadButtons().dpadLeft() && (repeatEventAvailable || !prevState.gamepadButtons().dpadLeft())) {
                        event = accessor.invokeCreateArrowEvent(class_8028.field_41828);
                        if (!prevState.gamepadButtons().dpadLeft()) {
                            this.navigationHelper.reset();
                        }
                    } else if (state.gamepadButtons().dpadUp() && (repeatEventAvailable || !prevState.gamepadButtons().dpadUp())) {
                        event = accessor.invokeCreateArrowEvent(class_8028.field_41826);
                        if (!prevState.gamepadButtons().dpadUp()) {
                            this.navigationHelper.reset();
                        }
                    } else if (state.gamepadButtons().dpadDown() && (repeatEventAvailable || !prevState.gamepadButtons().dpadDown())) {
                        event = accessor.invokeCreateArrowEvent(class_8028.field_41827);
                        if (!prevState.gamepadButtons().dpadDown()) {
                            this.navigationHelper.reset();
                        }
                    }
                }
            }
        }
        if (event != null && (path = this.screen.method_48205((class_8023)event)) != null) {
            accessor.invokeChangeFocus(path);
            this.navigationHelper.onNavigate();
            if (Controlify.instance().config().globalSettings().uiSounds) {
                minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)ControlifySounds.SCREEN_FOCUS_CHANGE, (float)1.0f));
            }
            Queue<class_364> newFocusTree = this.getFocusTree();
            while (!newFocusTree.isEmpty() && !focuses.contains(newFocusTree.peek())) {
                ComponentProcessorProvider.provide(newFocusTree.poll()).onFocusGained(this, controller);
            }
        }
    }

    protected void handleButtons(Controller<?, ?> controller) {
        if (controller.bindings().GUI_PRESS.justPressed()) {
            this.screen.method_25404(257, 0, 0);
        }
        if (this.screen.method_25422() && controller.bindings().GUI_BACK.justPressed()) {
            ScreenProcessor.playClackSound();
            this.screen.method_25419();
        }
    }

    protected void handleScreenVMouse(Controller<?, ?> controller, VirtualMouseHandler vmouse) {
    }

    protected boolean handleComponentButtonOverride(Controller<?, ?> controller) {
        Queue<class_364> focusTree = this.getFocusTree();
        while (!focusTree.isEmpty()) {
            class_364 focused = focusTree.poll();
            ComponentProcessor processor = ComponentProcessorProvider.provide(focused);
            if (!processor.overrideControllerButtons(this, controller)) continue;
            return true;
        }
        return false;
    }

    protected boolean handleComponentNavOverride(Controller<?, ?> controller) {
        Queue<class_364> focusTree = this.getFocusTree();
        while (!focusTree.isEmpty()) {
            class_364 focused = focusTree.poll();
            ComponentProcessor processor = ComponentProcessorProvider.provide(focused);
            if (!processor.overrideControllerNavigation(this, controller)) continue;
            return true;
        }
        return false;
    }

    protected void handleTabNavigation(Controller<?, ?> controller) {
        block3: {
            boolean prevTab;
            block2: {
                boolean nextTab = controller.bindings().GUI_NEXT_TAB.justPressed();
                prevTab = controller.bindings().GUI_PREV_TAB.justPressed();
                if (nextTab) break block2;
                if (!prevTab) break block3;
            }
            this.screen.method_25396().stream().filter(child -> child instanceof class_8089).map(class_8089.class::cast).findAny().ifPresent(navBar -> {
                TabNavigationBarAccessor accessor = (TabNavigationBarAccessor)navBar;
                ImmutableList<class_8087> tabs = accessor.getTabs();
                int currentIndex = tabs.indexOf(accessor.getTabManager().method_48614());
                int newIndex = currentIndex + (prevTab ? -1 : 1);
                if (newIndex < 0) {
                    newIndex = tabs.size() - 1;
                }
                if (newIndex >= tabs.size()) {
                    newIndex = 0;
                }
                navBar.method_48987(newIndex, true);
            });
        }
    }

    public void onWidgetRebuild() {
        this.setInitialFocus();
    }

    public void onVirtualMouseToggled(boolean enabled) {
        if (enabled) {
            ((ScreenAccessor)this.screen).invokeClearFocus();
        } else {
            this.setInitialFocus();
        }
    }

    protected void render(Controller<?, ?> controller, class_332 graphics, float tickDelta, Optional<VirtualMouseHandler> vmouse) {
    }

    protected void setInitialFocus() {
        ScreenAccessor accessor;
        class_8016 path;
        if (this.screen.method_25399() == null && Controlify.instance().currentInputMode().isController() && !Controlify.instance().virtualMouseHandler().isVirtualMouseEnabled() && (path = this.screen.method_48205((class_8023)(accessor = (ScreenAccessor)this.screen).invokeCreateArrowEvent(class_8028.field_41827))) != null) {
            accessor.invokeChangeFocus(path);
            this.navigationHelper.clearDelay();
        }
    }

    public VirtualMouseBehaviour virtualMouseBehaviour() {
        return VirtualMouseBehaviour.DEFAULT;
    }

    protected Queue<class_364> getFocusTree() {
        if (this.screen.method_25399() == null) {
            return new ArrayDeque<class_364>();
        }
        ArrayDeque<class_364> tree = new ArrayDeque<class_364>();
        class_364 focused = this.screen.method_25399();
        tree.add(focused);
        while (focused instanceof CustomFocus) {
            CustomFocus customFocus = (CustomFocus)focused;
            if ((focused = customFocus.getCustomFocus()) == null) continue;
            tree.addFirst(focused);
        }
        return tree;
    }

    protected final Optional<class_339> getWidget(String translationKey) {
        String translatedName = class_2561.method_43471((String)translationKey).getString();
        return this.screen.method_25396().stream().filter(child -> child instanceof class_339).map(class_339.class::cast).filter(widget -> widget.method_25369().getString().equals(translatedName)).findAny();
    }

    public static void playClackSound() {
        minecraft.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }
}

