/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.server;

import dev.isxander.controlify.server.ServerPolicy;
import java.util.Map;

public enum ServerPolicies {
    REACH_AROUND("reachAround"),
    DISABLE_FLY_DRIFTING("disableFlyDrifting");

    private static final Map<String, ServerPolicies> BY_ID;
    private final String id;
    private ServerPolicy value;

    private ServerPolicies(String id) {
        this.id = id;
        this.value = ServerPolicy.UNSET;
    }

    public ServerPolicy get() {
        return this.value;
    }

    public void set(ServerPolicy value) {
        this.value = value;
    }

    public String getId() {
        return this.id;
    }

    public static ServerPolicies getById(String id) {
        return BY_ID.get(id);
    }

    public static void unsetAll() {
        for (ServerPolicies policy : ServerPolicies.values()) {
            policy.set(ServerPolicy.UNSET);
        }
    }

    static {
        BY_ID = Map.of(REACH_AROUND.getId(), REACH_AROUND, DISABLE_FLY_DRIFTING.getId(), DISABLE_FLY_DRIFTING);
    }
}

