/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils;

import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.ControllerType;
import dev.isxander.controlify.controller.gamepad.GamepadController;
import dev.isxander.controlify.hid.ControllerHIDService;
import java.util.HexFormat;
import java.util.Optional;
import net.minecraft.class_3532;

public class ControllerUtils {
    public static String createControllerString(Controller<?, ?> controller) {
        Optional<String> hid = controller.hidInfo().flatMap(ControllerHIDService.ControllerHIDInfo::hidDevice);
        HexFormat hexFormat = HexFormat.of().withPrefix("0x");
        return String.format("'%s'#%s-%s (%s, %s: %s)", controller.name(), controller.joystickId(), controller instanceof GamepadController ? "gamepad" : "joy", hid.map(device -> hexFormat.toHexDigits(device.vendorID())).orElse("?"), hid.map(device -> hexFormat.toHexDigits(device.productID())).orElse("?"), controller.hidInfo().map(ControllerHIDService.ControllerHIDInfo::type).orElse(ControllerType.UNKNOWN).friendlyName());
    }

    public static float deadzone(float value, float deadzone) {
        return (value - Math.copySign(Math.min(deadzone, Math.abs(value)), value)) / (1.0f - deadzone);
    }

    public static float applyCircularityX(float x, float y) {
        return (float)((double)x * Math.sqrt(1.0f - y * y / 2.0f));
    }

    public static float applyCircularityY(float x, float y) {
        return (float)((double)y * Math.sqrt(1.0f - x * x / 2.0f));
    }

    public static boolean shouldApplyAntiSnapBack(float x, float y, float px, float py, float threshold) {
        boolean hasCrossedOrigin;
        float dx = x - px;
        float dy = y - py;
        float distanceSquared = dx * dx + dy * dy;
        boolean isSnap = distanceSquared >= threshold * threshold;
        boolean bl = hasCrossedOrigin = Math.signum(x) != Math.signum(px) && Math.signum(y) != Math.signum(py);
        if (isSnap && hasCrossedOrigin) {
            float t = (-x * (px - x) + -y * (py - y)) / distanceSquared;
            double distanceToMiddle = Math.sqrt(Math.pow(-(t = class_3532.method_15363((float)t, (float)0.0f, (float)1.0f)) * x + t * px, 2.0) + Math.pow(-t * y + t * py, 2.0));
            return distanceToMiddle <= 0.01;
        }
        return false;
    }
}

