/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.mixin.mixins.client;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.customization.DrippyOverlayMenuHandler;
import de.keksuccino.drippyloadingscreen.customization.DrippyOverlayScreen;
import de.keksuccino.drippyloadingscreen.customization.deepcustomization.DeepCustomizationLayers;
import de.keksuccino.drippyloadingscreen.customization.items.Items;
import de.keksuccino.drippyloadingscreen.customization.placeholders.Placeholders;
import de.keksuccino.drippyloadingscreen.mixin.MixinCache;
import de.keksuccino.drippyloadingscreen.mixin.mixins.client.IMixinLoadingOverlay;
import de.keksuccino.drippyloadingscreen.mixin.mixins.client.IMixinMinecraft;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import de.keksuccino.fancymenu.api.item.CustomizationItemRegistry;
import de.keksuccino.fancymenu.events.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.RenderScreenEvent;
import de.keksuccino.fancymenu.events.ScreenBackgroundRenderedEvent;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.gameintro.GameIntroHandler;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMNotificationPopup;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.fancy.item.items.ticker.TickerCustomizationItemContainer;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerBase;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerRegistry;
import de.keksuccino.konkrete.events.client.ClientTickEvent;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.StringUtils;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3694;
import net.minecraft.class_3695;
import net.minecraft.class_378;
import net.minecraft.class_4011;
import net.minecraft.class_425;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_425.class})
public class MixinLoadingOverlay {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final File CHECKED_FOR_OLD_LAYOUTS_FILE = new File(DrippyLoadingScreen.MOD_DIR.getPath(), "/.checked_for_old_layouts");
    private static final File LEGACY_LAYOUT_DIR = new File(DrippyLoadingScreen.MOD_DIR.getPath(), "/customization");
    @Shadow
    private float field_17770;
    private static boolean initialized = false;
    private static DrippyOverlayScreen drippyOverlayScreen = null;
    private static DrippyOverlayMenuHandler drippyOverlayHandler = null;
    private int lastScreenWidth = 0;
    private int lastScreenHeight = 0;
    private double renderScale = 0.0;
    private boolean overlayScaled = false;
    private static final IntSupplier BACKGROUND_COLOR = () -> {
        if (drippyOverlayHandler != null && MixinLoadingOverlay.drippyOverlayHandler.customBackgroundColor != null) {
            return MixinLoadingOverlay.drippyOverlayHandler.customBackgroundColor.getRGB();
        }
        return IMixinLoadingOverlay.getBrandBackgroundDrippy().getAsInt();
    };

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstruct(class_310 mc, class_4011 reload, Consumer consumer, boolean b, CallbackInfo info) {
        if (!initialized) {
            DrippyLoadingScreen.initConfig();
            LOGGER.info("[DRIPPY LOADING SCREEN] Initializing fonts for text rendering..");
            this.loadFonts();
            Placeholders.registerAll();
            Items.registerAll();
            DeepCustomizationLayers.registerAll();
            LOGGER.info("[DRIPPY LOADING SCREEN] Calculating animation sizes for FancyMenu..");
            AnimationHandler.setupAnimationSizes();
            initialized = true;
        }
        this.handleInitOverlay();
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onRenderPre(class_332 graphics, int mouseX, int mouseY, float partial, CallbackInfo info) {
        MixinCache.cachedCurrentLoadingScreenProgress = this.field_17770;
        this.handleInitOverlay();
        this.scaleOverlayStart(graphics);
        if (drippyOverlayScreen != null) {
            this.runMenuHandlerTask(() -> drippyOverlayHandler.onRenderPre(new RenderScreenEvent.Pre((class_437)drippyOverlayScreen, graphics, mouseX, mouseY, partial)));
        }
        this.scaleOverlayEnd(graphics);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRenderPost(class_332 graphics, int mouseX, int mouseY, float partial, CallbackInfo info) {
        this.scaleOverlayStart(graphics);
        if (drippyOverlayScreen != null) {
            this.runMenuHandlerTask(() -> drippyOverlayHandler.onRenderPost(new RenderScreenEvent.Post((class_437)drippyOverlayScreen, graphics, mouseX, mouseY, partial)));
        }
        this.scaleOverlayEnd(graphics);
        MixinCache.cachedCurrentLoadingScreenProgress = this.field_17770;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;disableDepthTest()V")})
    private void onBackgroundRendered(class_332 graphics, int mouseX, int mouseY, float partial, CallbackInfo info) {
        this.scaleOverlayStart(graphics);
        if (drippyOverlayScreen != null) {
            this.runMenuHandlerTask(() -> drippyOverlayHandler.drawToBackground(new ScreenBackgroundRenderedEvent((class_437)drippyOverlayScreen, graphics)));
        }
        this.scaleOverlayEnd(graphics);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setOverlay(Lnet/minecraft/client/gui/screens/Overlay;)V")})
    private void onClose(class_332 graphics, int mouseX, int mouseY, float partial, CallbackInfo info) {
        if (class_310.method_1551().field_1755 != null) {
            this.checkForOldLayouts();
        }
    }

    private void checkForOldLayouts() {
        String[] layoutFilesList;
        if (LEGACY_LAYOUT_DIR.isDirectory() && (layoutFilesList = LEGACY_LAYOUT_DIR.list((dir, name) -> name.toLowerCase().endsWith(".dllayout"))).length > 0 && !CHECKED_FOR_OLD_LAYOUTS_FILE.isFile()) {
            try {
                CHECKED_FOR_OLD_LAYOUTS_FILE.createNewFile();
                PopupHandler.displayPopup((Popup)new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, StringUtils.splitLines((String)class_1074.method_4662((String)"drippyloadingscreen.legacy_support.old_layouts", (Object[])new Object[0]), (String)"\n")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_clearColor(FFFF)V"), index=0)
    private float overrideBackgroundColorInClearColor0(float f) {
        int i2 = BACKGROUND_COLOR.getAsInt();
        return (float)(i2 >> 16 & 0xFF) / 255.0f;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_clearColor(FFFF)V"), index=1)
    private float overrideBackgroundColorInClearColor1(float f) {
        int i2 = BACKGROUND_COLOR.getAsInt();
        return (float)(i2 >> 8 & 0xFF) / 255.0f;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_clearColor(FFFF)V"), index=2)
    private float overrideBackgroundColorInClearColor2(float f) {
        int i2 = BACKGROUND_COLOR.getAsInt();
        return (float)(i2 & 0xFF) / 255.0f;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/LoadingOverlay;replaceAlpha(II)I"), index=0)
    private int overrideBackgroundColorInReplaceAlpha(int originalColor) {
        return BACKGROUND_COLOR.getAsInt();
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/LoadingOverlay;replaceAlpha(II)I"), index=1)
    private int setCustomBackgroundOpacityInReplaceAlpha(int alpha) {
        float opacity = Math.max(0.0f, Math.min(1.0f, (float)alpha / 255.0f));
        this.setCustomBackgroundOpacity(opacity);
        if (!((Boolean)DrippyLoadingScreen.config.getOrDefault("early_fade_out_elements", (Object)false)).booleanValue()) {
            this.setOverlayOpacity(opacity);
        }
        return alpha;
    }

    @Inject(method={"drawProgressBar"}, at={@At(value="HEAD")}, cancellable=true)
    private void replaceOriginalProgressBar(class_332 graphics, int p_96184_, int p_96185_, int p_96186_, int p_96187_, float opacity, CallbackInfo info) {
        info.cancel();
        if (((Boolean)DrippyLoadingScreen.config.getOrDefault("early_fade_out_elements", (Object)false)).booleanValue()) {
            this.setOverlayOpacity(opacity);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (drippyOverlayHandler != null && MixinLoadingOverlay.drippyOverlayHandler.progressBarItem != null && drippyOverlayScreen != null) {
            if (!MixinLoadingOverlay.drippyOverlayHandler.progressBarItem.useOriginalSizeAndPosCalculation) {
                this.scaleOverlayStart(graphics);
            }
            MixinLoadingOverlay.drippyOverlayHandler.progressBarItem.render(graphics, drippyOverlayScreen);
            this.scaleOverlayEnd(graphics);
        }
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIIIFFIIII)V"), index=1)
    private int renderOriginalLogoOffscreenSetXMin(int xMinOriginal) {
        return -1000000;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIIIFFIIII)V"), index=2)
    private int renderOriginalLogoOffscreenSetYMin(int yMinOriginal) {
        return -1000000;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIIIFFIIII)V"), index=3)
    private int renderOriginalLogoOffscreenSetXMax(int xMaxOriginal) {
        return -1000000;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIIIFFIIII)V"), index=4)
    private int renderOriginalLogoOffscreenSetYMax(int yMaxOriginal) {
        return -1000000;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(Lnet/minecraft/client/renderer/RenderType;IIIII)V")})
    private void clearColorBeforeFillDrippy(class_332 graphics, int p_282704_, int p_283650_, float p_283394_, CallbackInfo info) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_clear(IZ)V", shift=At.Shift.AFTER)})
    private void clearColorAfterBackgroundRenderingDrippy(class_332 graphics, int p_282704_, int p_283650_, float p_283394_, CallbackInfo info) {
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;disableBlend()V", shift=At.Shift.AFTER)})
    private void renderCustomizableInstanceOfLogo(class_332 graphics, int p_96179_, int p_96180_, float p_96181_, CallbackInfo info) {
        if (drippyOverlayHandler != null && MixinLoadingOverlay.drippyOverlayHandler.logoItem != null && drippyOverlayScreen != null) {
            if (!MixinLoadingOverlay.drippyOverlayHandler.logoItem.useOriginalSizeAndPosCalculation) {
                this.scaleOverlayStart(graphics);
            }
            MixinLoadingOverlay.drippyOverlayHandler.logoItem.render(graphics, drippyOverlayScreen);
            this.scaleOverlayEnd(graphics);
        }
    }

    private void setCustomBackgroundOpacity(float opacity) {
        if (drippyOverlayHandler != null) {
            MixinLoadingOverlay.drippyOverlayHandler.backgroundOpacity = opacity;
        }
    }

    private void setOverlayOpacity(float opacity) {
        if (opacity < 0.02f) {
            opacity = 0.02f;
        }
        if (drippyOverlayHandler != null) {
            ArrayList l = new ArrayList();
            l.addAll(MixinLoadingOverlay.drippyOverlayHandler.frontRenderItems);
            l.addAll(MixinLoadingOverlay.drippyOverlayHandler.backgroundRenderItems);
            for (CustomizationItemBase i : l) {
                i.opacity = opacity;
                if (!(i.opacity <= 0.02f)) continue;
                i.visible = false;
            }
            if (MixinLoadingOverlay.drippyOverlayHandler.logoItem != null) {
                MixinLoadingOverlay.drippyOverlayHandler.logoItem.opacity = opacity;
                if (MixinLoadingOverlay.drippyOverlayHandler.logoItem.opacity <= 0.02f) {
                    MixinLoadingOverlay.drippyOverlayHandler.logoItem.hidden = true;
                }
            }
            if (MixinLoadingOverlay.drippyOverlayHandler.progressBarItem != null) {
                MixinLoadingOverlay.drippyOverlayHandler.progressBarItem.opacity = opacity;
                if (MixinLoadingOverlay.drippyOverlayHandler.progressBarItem.opacity <= 0.02f) {
                    MixinLoadingOverlay.drippyOverlayHandler.progressBarItem.hidden = true;
                }
            }
        }
    }

    private void loadFonts() {
        try {
            MixinCache.gameThreadRunnables.add(() -> {
                try {
                    class_378 fontManager = ((IMixinMinecraft)class_310.method_1551()).getFontManagerDrippy();
                    fontManager.method_51614((class_378.class_8536)fontManager.method_51608(class_310.method_1551().method_1478(), (Executor)class_156.method_18349()).get(), (class_3695)class_3694.field_16280);
                }
                catch (Exception ex) {
                    LOGGER.info("[DRIPPY LOADING SCREEN] Failed to load fonts!");
                    ex.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleInitOverlay() {
        try {
            CustomizationItemContainer tickerItem = CustomizationItemRegistry.getItem((String)"fancymenu_customization_item_ticker");
            if (tickerItem != null) {
                ((TickerCustomizationItemContainer)tickerItem).onClientTick(new ClientTickEvent.Post());
            }
            int screenWidth = class_310.method_1551().method_22683().method_4486();
            int screenHeight = class_310.method_1551().method_22683().method_4502();
            if (drippyOverlayScreen == null) {
                Map<String, MenuHandlerBase> m;
                drippyOverlayScreen = new DrippyOverlayScreen();
                MenuHandlerBase b = MenuHandlerRegistry.getHandlerFor((class_437)drippyOverlayScreen);
                if (b != null && (m = this.getMenuHandlerRegistryMap()) != null) {
                    m.remove(DrippyOverlayScreen.class.getName());
                }
                b = new DrippyOverlayMenuHandler();
                MenuHandlerRegistry.registerHandler((MenuHandlerBase)b);
                drippyOverlayHandler = (DrippyOverlayMenuHandler)b;
                this.initOverlay(screenWidth, screenHeight);
                this.lastScreenWidth = screenWidth;
                this.lastScreenHeight = screenHeight;
            }
            if (screenWidth != this.lastScreenWidth || screenHeight != this.lastScreenHeight) {
                this.initOverlay(screenWidth, screenHeight);
            }
            this.lastScreenWidth = screenWidth;
            this.lastScreenHeight = screenHeight;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    private Map<String, MenuHandlerBase> getMenuHandlerRegistryMap() {
        try {
            Field f = MenuHandlerRegistry.class.getDeclaredField("handlers");
            f.setAccessible(true);
            return (Map)f.get(MenuHandlerRegistry.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void initOverlay(int screenWidth, int screenHeight) {
        this.runMenuHandlerTask(() -> {
            try {
                MixinLoadingOverlay.drippyOverlayScreen.field_22789 = screenWidth;
                MixinLoadingOverlay.drippyOverlayScreen.field_22790 = screenHeight;
                double oriScale = class_310.method_1551().method_22683().method_4495();
                drippyOverlayHandler.onInitPre(new InitOrResizeScreenEvent.Pre((class_437)drippyOverlayScreen));
                drippyOverlayHandler.onButtonsCached(new ButtonCachedEvent((class_437)drippyOverlayScreen, new ArrayList(), false));
                this.renderScale = class_310.method_1551().method_22683().method_4495();
                class_310.method_1551().method_22683().method_15997(oriScale);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void scaleOverlayStart(class_332 graphics) {
        this.overlayScaled = true;
        double guiScale = class_310.method_1551().method_22683().method_4495();
        float scale = (float)(1.0 * (1.0 / guiScale) * this.renderScale);
        if (drippyOverlayHandler != null) {
            ArrayList l = new ArrayList();
            l.addAll(MixinLoadingOverlay.drippyOverlayHandler.frontRenderItems);
            l.addAll(MixinLoadingOverlay.drippyOverlayHandler.backgroundRenderItems);
            for (CustomizationItemBase i : l) {
                i.customGuiScale = (float)this.renderScale;
            }
        }
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(scale, scale, scale);
    }

    private void scaleOverlayEnd(class_332 graphics) {
        if (this.overlayScaled) {
            graphics.method_51448().method_22909();
            this.overlayScaled = false;
        }
    }

    private void runMenuHandlerTask(Runnable run) {
        try {
            boolean gameIntroDisplayed = GameIntroHandler.introDisplayed;
            GameIntroHandler.introDisplayed = true;
            MenuHandlerBase menuHandler = MenuHandlerRegistry.getLastActiveHandler();
            MenuHandlerRegistry.setActiveHandler((String)DrippyOverlayScreen.class.getName());
            boolean allowCustomizations = MenuCustomization.allowScreenCustomization;
            MenuCustomization.allowScreenCustomization = true;
            boolean animationsReady = AnimationHandler.isReady();
            AnimationHandler.setReady((boolean)true);
            class_437 s = class_310.method_1551().field_1755;
            if (s == null || !(s instanceof DrippyOverlayScreen)) {
                class_310.method_1551().field_1755 = drippyOverlayScreen;
                run.run();
                class_310.method_1551().field_1755 = s;
            }
            GameIntroHandler.introDisplayed = gameIntroDisplayed;
            MenuCustomization.allowScreenCustomization = allowCustomizations;
            AnimationHandler.setReady((boolean)animationsReady);
            if (menuHandler != null) {
                MenuHandlerRegistry.setActiveHandler((String)menuHandler.getMenuIdentifier());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

