/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledConfig;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2802;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class EntangledBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    private boolean bound = false;
    private class_2338 boundPos;
    private class_5321<class_1937> boundDimension;
    private class_2680 boundBlockState;
    private class_2586 boundBlockEntity;
    private final int[] redstoneSignal = new int[]{0, 0, 0, 0, 0, 0};
    private final int[] directRedstoneSignal = new int[]{0, 0, 0, 0, 0, 0};
    private int analogOutputSignal = -1;
    private int callDepth = 0;

    public EntangledBlockEntity(class_2338 pos, class_2680 state) {
        super(Entangled.tile, pos, state);
    }

    void updateBoundBlockData(boolean forceLoad) {
        if (this.field_11863 == null || !this.bound || this.boundPos == null) {
            return;
        }
        class_1937 level = this.getBoundDimension();
        if (level == null) {
            return;
        }
        class_2802 chunkSource = level.method_8398();
        if (chunkSource instanceof class_3215 && ((class_3215)chunkSource).field_17253 != Thread.currentThread()) {
            return;
        }
        boolean sendUpdate = false;
        if (forceLoad || chunkSource.method_21730(class_4076.method_18675((int)this.boundPos.method_10263()), class_4076.method_18675((int)this.boundPos.method_10260())) != null) {
            class_2680 state = level.method_8320(this.boundPos);
            class_2586 entity = level.method_8321(this.boundPos);
            int analogOutputSignal = state.method_26221() ? state.method_26176(level, this.boundPos) : 0;
            boolean signalChanged = false;
            for (class_2350 direction : class_2350.values()) {
                int redstoneSignal = state.method_26195((class_1922)level, this.boundPos, direction);
                int directRedstoneSignal = state.method_26203((class_1922)level, this.boundPos, direction);
                if (redstoneSignal == this.redstoneSignal[direction.method_10146()] && directRedstoneSignal == this.directRedstoneSignal[direction.method_10146()]) continue;
                signalChanged = true;
                this.redstoneSignal[direction.method_10146()] = redstoneSignal;
                this.directRedstoneSignal[direction.method_10146()] = directRedstoneSignal;
            }
            if (state != this.boundBlockState || entity != this.boundBlockEntity || analogOutputSignal != this.analogOutputSignal || signalChanged) {
                this.boundBlockState = state;
                this.boundBlockEntity = entity;
                this.analogOutputSignal = analogOutputSignal;
                sendUpdate = true;
            }
        } else if (this.boundBlockEntity != null && this.boundBlockEntity.method_11015()) {
            this.boundBlockEntity = null;
            sendUpdate = true;
        }
        if (sendUpdate) {
            this.dataChanged();
            this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
            this.field_11863.method_8452(this.field_11867, this.method_11010().method_26204());
        }
    }

    public void update() {
        boolean forceLoad = this.boundBlockState == null || (this.boundBlockEntity != null ? this.boundBlockEntity.method_11015() : this.boundBlockState.method_31709()) || this.analogOutputSignal == -1;
        this.updateBoundBlockData(forceLoad);
    }

    public boolean isBound() {
        return this.bound;
    }

    @Nullable
    public class_2338 getBoundBlockPos() {
        return this.boundPos;
    }

    public class_5321<class_1937> getBoundDimensionIdentifier() {
        return this.boundDimension;
    }

    public class_2680 getBoundBlockState() {
        return this.boundBlockState;
    }

    public <A, C> A getCapability(BlockApiLookup<A, C> apiLookup, C context) {
        if (this.bound && this.callDepth < 10) {
            if (this.boundBlockEntity == null ? this.boundBlockState == null || this.boundBlockState.method_31709() : this.boundBlockEntity.method_11015()) {
                this.updateBoundBlockData(false);
            }
            if (this.boundBlockEntity != null && !this.boundBlockEntity.method_11015()) {
                ++this.callDepth;
                Object value = apiLookup.find(this.getBoundDimension(), this.boundPos, this.boundBlockState, this.boundBlockEntity, context);
                --this.callDepth;
                return (A)value;
            }
        }
        return null;
    }

    public boolean bind(class_2338 pos, String dimension) {
        if (!this.canBindTo(pos, dimension)) {
            return false;
        }
        this.boundPos = pos == null ? null : new class_2338((class_2382)pos);
        this.boundDimension = dimension == null ? null : class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(dimension));
        this.bound = pos != null;
        this.boundBlockState = null;
        this.boundBlockEntity = null;
        this.field_11863.method_8452(this.method_11016(), this.method_11010().method_26204());
        this.dataChanged();
        return true;
    }

    public boolean canBindTo(class_2338 pos, String dimension) {
        return pos == null && dimension == null || dimension.equals(this.field_11863.method_27983().method_29177().toString()) ? EntangledConfig.maxDistance.get() == -1 || this.field_11867.method_19771((class_2382)pos, (double)EntangledConfig.maxDistance.get().intValue() + 0.5) : EntangledConfig.allowDimensional.get();
    }

    class_1937 getBoundDimension() {
        if (this.boundDimension == null) {
            return null;
        }
        return this.field_11863.field_9236 ? (this.field_11863.method_27983() == this.boundDimension ? this.field_11863 : null) : this.field_11863.method_8503().method_3847(this.boundDimension);
    }

    private boolean isTargetLoaded() {
        if (this.field_11863.field_9236 || !this.bound) {
            return false;
        }
        class_1937 level = this.field_11863.method_27983() == this.boundDimension ? this.field_11863 : this.field_11863.method_8503().method_3847(this.boundDimension);
        return level != null && level.method_8477(this.boundPos);
    }

    public int getRedstoneSignal(class_2350 side) {
        if (!this.bound) {
            return 0;
        }
        if (this.isTargetLoaded() && this.callDepth < 10) {
            ++this.callDepth;
            class_1937 level = this.getBoundDimension();
            this.redstoneSignal[side.method_10146()] = level.method_8320(this.boundPos).method_26195((class_1922)level, this.boundPos, side);
            --this.callDepth;
            return Math.max(this.redstoneSignal[side.method_10146()], 0);
        }
        return Math.max(this.redstoneSignal[side.method_10146()], 0);
    }

    public int getDirectRedstoneSignal(class_2350 side) {
        if (!this.bound) {
            return 0;
        }
        if (this.isTargetLoaded() && this.callDepth < 10) {
            ++this.callDepth;
            class_1937 level = this.getBoundDimension();
            this.directRedstoneSignal[side.method_10146()] = level.method_8320(this.boundPos).method_26203((class_1922)level, this.boundPos, side);
            --this.callDepth;
            return Math.max(this.directRedstoneSignal[side.method_10146()], 0);
        }
        return Math.max(this.directRedstoneSignal[side.method_10146()], 0);
    }

    public int getAnalogOutputSignal() {
        if (!this.bound) {
            return 0;
        }
        if (this.isTargetLoaded() && this.callDepth < 10) {
            ++this.callDepth;
            class_1937 level = this.getBoundDimension();
            this.analogOutputSignal = level.method_8320(this.boundPos).method_26176(level, this.boundPos);
            --this.callDepth;
            return Math.max(this.analogOutputSignal, 0);
        }
        return Math.max(this.analogOutputSignal, 0);
    }

    public void method_11014(class_2487 compound) {
        if (compound.method_10545("bound")) {
            class_2487 data = new class_2487();
            data.method_10556("bound", compound.method_10577("bound"));
            data.method_10569("boundx", compound.method_10550("boundx"));
            data.method_10569("boundy", compound.method_10550("boundy"));
            data.method_10569("boundz", compound.method_10550("boundz"));
            data.method_10582("dimension", compound.method_10558("dimension"));
            compound.method_10566("data", (class_2520)data);
        }
        super.method_11014(compound);
    }

    protected class_2487 writeData() {
        class_2487 compound = new class_2487();
        if (this.bound) {
            compound.method_10556("bound", true);
            compound.method_10569("boundx", this.boundPos.method_10263());
            compound.method_10569("boundy", this.boundPos.method_10264());
            compound.method_10569("boundz", this.boundPos.method_10260());
            compound.method_10582("dimension", this.boundDimension.method_29177().toString());
            compound.method_10569("blockstate", class_2248.method_9507((class_2680)this.boundBlockState));
            for (class_2350 direction : class_2350.values()) {
                int index = direction.method_10146();
                compound.method_10569("redstoneSignal" + index, this.redstoneSignal[index]);
                compound.method_10569("directRedstoneSignal" + index, this.directRedstoneSignal[index]);
            }
            compound.method_10569("analogOutputSignal", this.analogOutputSignal);
        }
        return compound;
    }

    protected void readData(class_2487 compound) {
        this.bound = compound.method_10577("bound");
        if (this.bound) {
            this.boundPos = new class_2338(compound.method_10550("boundx"), compound.method_10550("boundy"), compound.method_10550("boundz"));
            this.boundDimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(compound.method_10558("dimension")));
            this.boundBlockState = class_2248.method_9531((int)compound.method_10550("blockstate"));
            for (class_2350 direction : class_2350.values()) {
                int index = direction.method_10146();
                this.redstoneSignal[index] = compound.method_10550("redstoneSignal" + index);
                this.directRedstoneSignal[index] = compound.method_10550("directRedstoneSignal" + index);
            }
            this.analogOutputSignal = compound.method_10550("analogOutputSignal");
        }
    }
}

