/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v3;

import fuzs.puzzleslib.api.core.v1.Buildable;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializer;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializers;
import fuzs.puzzleslib.impl.core.ModContext;
import fuzs.puzzleslib.impl.network.NetworkHandlerRegistry;
import java.lang.reflect.Type;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2792;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public interface NetworkHandlerV3 {
    public static Builder builder(String modId) {
        return ModContext.get(modId).getNetworkHandlerV3$Builder();
    }

    public <T extends Record> class_2596<class_2602> toClientboundPacket(T var1);

    public <T extends Record> class_2596<class_2792> toServerboundPacket(T var1);

    default public <T extends Record> void sendToServer(T message) {
        Proxy.INSTANCE.getClientPacketListener().method_2883(this.toServerboundPacket(message));
    }

    default public <T extends Record> void sendTo(class_3222 player, T message) {
        player.field_13987.method_14364(this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAll(T message) {
        Proxy.INSTANCE.getGameServer().method_3760().method_14581(this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAllExcept(class_3222 exclude, T message) {
        for (class_3222 player : Proxy.INSTANCE.getGameServer().method_3760().method_14571()) {
            if (player == exclude) continue;
            this.sendTo(player, message);
        }
    }

    default public <T extends Record> void sendToAllNear(class_2338 pos, class_1937 level, T message) {
        this.sendToAllNearExcept(null, pos.method_10263(), pos.method_10264(), pos.method_10260(), 64.0, level, message);
    }

    default public <T extends Record> void sendToAllNear(double posX, double posY, double posZ, double distance, class_1937 level, T message) {
        this.sendToAllNearExcept(null, posX, posY, posZ, 64.0, level, message);
    }

    default public <T extends Record> void sendToAllNearExcept(@Nullable class_3222 exclude, double posX, double posY, double posZ, double distance, class_1937 level, T message) {
        Proxy.INSTANCE.getGameServer().method_3760().method_14605((class_1657)exclude, posX, posY, posZ, distance, level.method_27983(), this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAllTracking(class_1297 entity, T message) {
        ((class_3215)entity.method_5770().method_8398()).method_18754(entity, this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAllTrackingAndSelf(class_1297 entity, T message) {
        ((class_3215)entity.method_5770().method_8398()).method_18751(entity, this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToDimension(class_1937 level, T message) {
        this.sendToDimension((class_5321<class_1937>)level.method_27983(), message);
    }

    default public <T extends Record> void sendToDimension(class_5321<class_1937> dimension, T message) {
        Proxy.INSTANCE.getGameServer().method_3760().method_14589(this.toClientboundPacket(message), dimension);
    }

    public static interface Builder
    extends NetworkHandlerRegistry,
    Buildable {
        default public <T> Builder registerSerializer(Class<T> type, class_2540.class_7462<T> writer, class_2540.class_7461<T> reader) {
            MessageSerializers.registerSerializer(type, writer, reader);
            return this;
        }

        default public <T> Builder registerSerializer(Class<? super T> type, class_5321<class_2378<T>> resourceKey) {
            MessageSerializers.registerSerializer(type, resourceKey);
            return this;
        }

        default public <T> Builder registerContainerProvider(Class<T> type, Function<Type[], MessageSerializer<? extends T>> factory) {
            MessageSerializers.registerContainerProvider(type, factory);
            return this;
        }

        public <T extends Record> Builder registerClientbound(Class<T> var1);

        public <T extends Record> Builder registerServerbound(Class<T> var1);

        public Builder clientAcceptsVanillaOrMissing();

        public Builder serverAcceptsVanillaOrMissing();

        default public Builder allAcceptVanillaOrMissing() {
            return this.clientAcceptsVanillaOrMissing().serverAcceptsVanillaOrMissing();
        }
    }
}

